/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.map;

import java.awt.Graphics2D;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.bt747.j2se.app.map.BT747MapWayPointRenderer;
import net.sf.bt747.j2se.app.map.BT747WaypointRenderer;
import net.sf.bt747.j2se.app.map.IconWayPointRenderer;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;

public final class MapRendererFactoryMethod
implements WaypointRenderer {
    private static MapRendererFactoryMethod factory = new MapRendererFactoryMethod();
    private static final Hashtable<Class<?>, BT747WaypointRenderer> renderHash = new Hashtable();
    private static final Vector<BT747WaypointRenderer> renderers = new Vector<BT747MapWayPointRenderer>();

    public static final MapRendererFactoryMethod getInstance() {
        return factory;
    }

    public final boolean paintWaypoint(Graphics2D graphics2D, JXMapViewer jXMapViewer, Waypoint waypoint) {
        return MapRendererFactoryMethod.getRenderer(waypoint).paintWaypoint(graphics2D, jXMapViewer, waypoint);
    }

    public static BT747WaypointRenderer getRenderer(Waypoint waypoint) {
        BT747WaypointRenderer bT747WaypointRenderer = renderHash.get(waypoint.getClass());
        if (bT747WaypointRenderer == null) {
            for (int i = renderers.size() - 1; i >= 0; --i) {
                BT747WaypointRenderer bT747WaypointRenderer2 = renderers.get(i);
                if (!bT747WaypointRenderer2.isRendererOf(waypoint)) continue;
                renderHash.put(waypoint.getClass(), bT747WaypointRenderer2);
                return bT747WaypointRenderer2;
            }
        }
        return bT747WaypointRenderer;
    }

    static {
        renderers.add(new BT747MapWayPointRenderer());
        renderers.add(new IconWayPointRenderer());
    }
}

