/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MoldenReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.writers.QCSchema;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class QCJSONReader
extends MoldenReader {
    private Map<String, Object> job;
    private int jobCount;
    private int modelCount;
    private boolean haveEnergy = true;
    String lastBasisID = null;

    @Override
    protected void initializeReader() {
        super.initializeReader();
        SB sb = new SB();
        try {
            while (this.rd() != null) {
                sb.append(this.line);
            }
            Lst json = this.vwr.parseJSONArray(sb.toString());
            Logger.info((String)json.get(0).toString());
            this.jobCount = json.size() - 2;
            for (int i = 0; i < this.jobCount; ++i) {
                this.processJob((Map)json.get(i + 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void processJob(Map<String, Object> job) throws Exception {
        this.job = job;
        this.readSteps();
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
    }

    private void readSteps() throws Exception {
        Lst<Object> steps = this.getList(this.job, "steps");
        int nSteps = steps.size();
        for (int iStep = 0; iStep < nSteps; ++iStep) {
            if (!this.doGetModel(++this.modelCount, null)) {
                if (this.checkLastModel()) continue;
                return;
            }
            this.asc.newAtomSet();
            Map step = (Map)steps.get(iStep);
            Map<String, Object> topology = this.getMap(step, "topology");
            Map<String, Object> atoms = this.getMap(topology, "atoms");
            String[] symbols = this.getStringArray(atoms, "symbol");
            int[] atomNumbers = this.getIntArray(atoms, "atom_number");
            String[] atom_names = this.getStringArray(atoms, "atom_names");
            float[] coords = this.getFloatArray(atoms, "coords");
            this.modelAtomCount = coords.length / 3;
            float f = this.getConversionFactor(atoms, "coords", "angstroms");
            boolean isFractional = f == 0.0f;
            this.setFractionalCoordinates(isFractional);
            if (isFractional) {
                f = this.getConversionFactor(atoms, "unit_cell", "angstroms");
                float[] cell = this.getFloatArray(atoms, "unit_cell");
                if (cell == null) {
                    Logger.error((String)"topology.unit_cell is missing even though atoms are listed as fractional");
                } else {
                    for (int i = 0; i < 6; ++i) {
                        switch (i) {
                            case 3: {
                                f = 1.0f;
                            }
                        }
                        this.setUnitCellItem(i, cell[i] * f);
                    }
                }
            }
            int pt = 0;
            for (int i = 0; i < this.modelAtomCount; ++i) {
                Atom atom = this.asc.addNewAtom();
                this.setAtomCoordXYZ(atom, coords[pt++] * f, coords[pt++] * f, coords[pt++] * f);
                String sym = symbols == null ? JmolAdapter.getElementSymbol((int)atomNumbers[i]) : symbols[i];
                atom.atomName = atom_names == null ? sym : atom_names[i];
                atom.elementNumber = (short)(atomNumbers == null ? JmolAdapter.getElementNumber((String)sym) : atomNumbers[i]);
            }
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals(this.getMap(step, "molecular_orbitals"));
                this.clearOrbitals();
            }
            this.applySymmetryAndSetTrajectory();
            if (!this.loadVibrations) continue;
            this.readFreqsAndModes(this.getList(step, "vibrations"));
        }
    }

    private boolean readFreqsAndModes(Lst<Object> vibrations) throws Exception {
        if (vibrations != null) {
            int n = vibrations.size();
            for (int i = 0; i < n; ++i) {
                Map vib = (Map)vibrations.get(i);
                float freq = this.getFloat(vib, "frequency", "cm-1");
                float[] vectors = this.getFloatArray(vib, "vectors");
                if (i > 0) {
                    this.asc.cloneLastAtomSet();
                }
                this.asc.setAtomSetFrequency(null, null, "" + freq, "cm-1");
                int i0 = this.asc.getLastAtomSetAtomIndex();
                int pt = 0;
                for (int j = 0; j < this.modelAtomCount; ++j) {
                    this.asc.addVibrationVector(j + i0, vectors[pt++] * 0.5291772f, vectors[pt++] * 0.5291772f, vectors[pt++] * 0.5291772f);
                }
            }
        }
        return true;
    }

    private float getFloat(Map<String, Object> mo, String key, String toUnits) {
        Float f;
        Object o = mo.get(key);
        float conv = 1.0f;
        if (toUnits != null) {
            if (o instanceof Map) {
                return this.convertTo((Map)o, toUnits);
            }
            if (mo.containsKey(key + "_units")) {
                conv = this.getConversionFactor(mo, key, toUnits);
            }
        }
        return (f = (Float)o) == null ? Float.NaN : f.floatValue() * conv;
    }

    private float convertTo(Map<String, Object> map, String toUnits) {
        return this.getFloat(map, "value", null) * this.getConversionFactor(map, "units", toUnits);
    }

    private float getConversionFactor(Map<String, Object> map, String key, String toUnits) {
        Lst<Object> list = this.getList(map, key + "_units");
        String units = list == null ? null : list.get(0).toString();
        float f = QCSchema.getConversionFactorTo(list, (String)toUnits);
        if (Float.isNaN(f)) {
            System.out.println("units for " + units + "? " + units);
            f = 1.0f;
        }
        return f;
    }

    private Map<String, Object> getMap(Object obj, String key) {
        return obj == null ? null : (Map)((Map)obj).get(key);
    }

    private Lst<Object> getList(Object mapOrList, String key) {
        Lst list = (Lst)(key == null ? mapOrList : ((Map)mapOrList).get(key));
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0 || !"_RLE_".equals(list.get(0))) {
            return list;
        }
        Lst list1 = new Lst();
        for (int i = 1; i < n; ++i) {
            int count = ((Number)list.get(i)).intValue();
            Object value = list.get(++i);
            for (int j = 0; j < count; ++j) {
                list1.addLast(value);
            }
        }
        return list1;
    }

    private float[] getFloatArray(Object mapOrList, String key) {
        Lst<Object> list = this.getList(mapOrList, key);
        if (list == null) {
            return null;
        }
        float[] a = new float[list.size()];
        int i = a.length;
        while (--i >= 0) {
            try {
                a[i] = ((Number)list.get(i)).floatValue();
            }
            catch (Exception e) {
                a[i] = Float.NaN;
            }
        }
        return a;
    }

    private int[] getIntArray(Object mapOrList, String key) {
        Lst<Object> list = this.getList(mapOrList, key);
        if (list == null) {
            return null;
        }
        int[] a = new int[list.size()];
        int i = a.length;
        while (--i >= 0) {
            a[i] = ((Number)list.get(i)).intValue();
        }
        return a;
    }

    private String[] getStringArray(Object mapOrList, String key) {
        Lst<Object> list = this.getList(mapOrList, key);
        if (list == null) {
            return null;
        }
        String[] a = new String[list.size()];
        int i = a.length;
        while (--i >= 0) {
            a[i] = list.get(i).toString();
            if (!a[i].equals("null")) continue;
            a[i] = null;
        }
        return a;
    }

    private boolean readMolecularOrbitals(Map<String, Object> molecular_orbitals) throws Exception {
        Lst<Object> units;
        if (molecular_orbitals == null) {
            return false;
        }
        String moBasisID = molecular_orbitals.get("basis_id").toString();
        if (!this.readBasis(moBasisID)) {
            return false;
        }
        Boolean isNormalized = (Boolean)molecular_orbitals.get("__jmol_normalized");
        if (isNormalized != null && isNormalized.booleanValue()) {
            this.moData.put("isNormalized", isNormalized);
        }
        this.calculationType = (String)molecular_orbitals.get("__jmol_calculation_type");
        if (this.calculationType == null) {
            this.calculationType = "?";
        }
        this.moData.put("calculationType", this.calculationType);
        Lst<Object> mos = this.getList(molecular_orbitals, "orbitals");
        int n = mos.size();
        for (int i = 0; i < n; ++i) {
            Map thisMO = (Map)mos.get(i);
            float energy = this.getFloat(thisMO, "energy", "ev");
            float occupancy = this.getFloat(thisMO, "occupancy", null);
            String symmetry = (String)thisMO.get("symmetry");
            String spin = (String)thisMO.get("type");
            if (spin != null) {
                if (spin.indexOf("beta") >= 0) {
                    this.alphaBeta = "beta";
                } else if (spin.indexOf("alpha") >= 0) {
                    this.alphaBeta = "alpha";
                }
            }
            float[] coefs = this.getFloatArray(thisMO, "coefficients");
            this.line = "" + symmetry;
            if (!this.filterMO()) continue;
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("coefficients", coefs);
            if (Float.isNaN(energy)) {
                this.haveEnergy = false;
            } else {
                mo.put("energy", Float.valueOf(energy));
            }
            if (!Float.isNaN(occupancy)) {
                mo.put("occupancy", Float.valueOf(occupancy));
            }
            if (symmetry != null) {
                mo.put("symmetry", symmetry);
            }
            if (this.alphaBeta.length() > 0) {
                mo.put("type", this.alphaBeta);
            }
            this.setMO(mo);
            if (!this.debugging) continue;
            Logger.debug((String)(coefs.length + " coefficients in MO " + this.orbitals.size()));
        }
        if (this.debugging) {
            Logger.debug((String)("read " + this.orbitals.size() + " MOs"));
        }
        String sunits = (units = this.getList(molecular_orbitals, "orbitals_energy_units")) == null ? null : units.get(0).toString();
        this.setMOs(sunits == null || sunits.equals("?") ? "?" : sunits);
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private boolean readBasis(String moBasisID) throws Exception {
        Map<String, Object> moBasisData = this.getMap(this.job, "mo_bases");
        Map<String, Object> moBasis = this.getMap(moBasisData, moBasisID);
        if (moBasis == null) {
            Logger.error((String)("No job.mo_bases entry for " + moBasisID));
            return false;
        }
        if (moBasisID == this.lastBasisID) {
            return true;
        }
        this.lastBasisID = moBasisID;
        Lst<Object> listG = this.getList(moBasis, "gaussians");
        Lst<Object> listS = this.getList(moBasis, "shells");
        if (listG == null && listS == null) {
            listG = listS = this.getList(moBasis, "slaters");
        }
        if (listG == null != (listS == null)) {
            Logger.error((String)"gaussians/shells or slaters missing");
            return false;
        }
        if (listG == listS) {
            this.readSlaterBasis(listS);
        } else {
            this.readGaussianBasis(listG, listS);
        }
        return true;
    }

    boolean readSlaterBasis(Lst<Object> listS) throws Exception {
        this.nCoef = listS.size();
        for (int i = 0; i < this.nCoef; ++i) {
            float[] a = this.getFloatArray(listS.get(i), null);
            this.addSlater((int)a[0], (int)a[1], (int)a[2], (int)a[3], (int)a[4], a[5], a[6]);
        }
        this.setSlaters(false, false);
        return true;
    }

    private boolean readGaussianBasis(Lst<Object> listG, Lst<Object> listS) throws Exception {
        this.shells = new Lst();
        for (int i = 0; i < listS.size(); ++i) {
            this.shells.addLast((Object)this.getIntArray(listS.get(i), null));
        }
        int gaussianPtr = listG.size();
        float[][] garray = AU.newFloat2((int)gaussianPtr);
        for (int i = 0; i < gaussianPtr; ++i) {
            garray[i] = this.getFloatArray(listG.get(i), null);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", garray);
        Logger.info((String)(this.shells.size() + " slater shells read"));
        Logger.info((String)(garray.length + " gaussian primitives read"));
        this.asc.setCurrentModelInfo("moData", (Object)this.moData);
        return false;
    }

    private void sortMOs() {
        Object[] list = this.orbitals.toArray(new Object[this.orbitals.size()]);
        Arrays.sort(list, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        for (int i = 0; i < list.length; ++i) {
            this.orbitals.addLast((Object)((Map)list[i]));
        }
    }
}

