/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourPluginsPath;

    @NotNull
    public static String getHomePath() {
        if (ourHomePath != null) {
            String string = ourHomePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
            }
            return string;
        }
        String fromProperty = System.getProperty("idea.home.path", System.getProperty("idea.home"));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
        }
        if (SystemInfo.isWindows) {
            try {
                ourHomePath = new File(ourHomePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ourBinDirectories = PathManager.getBinDirectories(new File(ourHomePath));
        String string = ourHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
        }
        return string;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass2) {
        String parent2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getHomePathFor"));
        }
        String rootPath = PathManager.getResourceRoot(aClass2, "/" + aClass2.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        File root2 = new File(rootPath).getAbsoluteFile();
        do {
            if ((parent2 = root2.getParent()) != null) continue;
            return null;
        } while (!PathManager.isIdeaHome(root2 = new File(parent2).getAbsoluteFile()));
        return root2.getAbsolutePath();
    }

    private static boolean isIdeaHome(File root2) {
        for (String binDir : PathManager.getBinDirectories(root2)) {
            if (!new File(binDir, "idea.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    private static String[] getBinDirectories(File root2) {
        List<String> binDirs = ContainerUtil.newSmartList();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root2, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        return ArrayUtil.toStringArray(binDirs);
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + "bin";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getBinPath"));
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/application/PathManager", "findBinFile"));
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file = new File(binDir, fileName);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/application/PathManager", "findBinFileWithException"));
        }
        File file = PathManager.findBinFile(fileName);
        if (file != null) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "findBinFileWithException"));
            }
            return file2;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + File.separator + "lib";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLibPath"));
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + "plugins";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPreInstalledPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
            }
            return string;
        }
        ourConfigPath = System.getProperty("idea.config.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.config.path"))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + "config");
        String string = ourConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", "config");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        return string;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
            }
            return string;
        }
        ourPluginsPath = System.getProperty("idea.plugins.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.plugins.path"))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Application Support" + File.separator + PATHS_SELECTOR : PathManager.getConfigPath() + File.separatorChar + "plugins");
        String string = ourPluginsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
            }
            return string;
        }
        ourSystemPath = System.getProperty("idea.system.path") != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path"))) : (PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Caches", "system") : PathManager.getHomePath() + File.separator + "system");
        FileUtil.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        File file = indexRoot;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getIndexRoot"));
        }
        return file;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/application/PathManager", "getResourceRoot"));
        }
        URL url = context.getResource(path2);
        if (url == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null) {
            resultPath = (String)paths.first;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract: " + resourcePath + " from " + resourceURL);
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path2) {
        path2 = FileUtil.expandUserHome(path2);
        return FileUtil.toCanonicalPath(new File(path2).getAbsolutePath());
    }

    private static String trimPathQuotes(String path2) {
        if (path2 != null && path2.length() >= 3 && StringUtil.startsWithChar(path2, '\"') && StringUtil.endsWithChar(path2, '\"')) {
            path2 = path2.substring(1, path2.length() - 1);
        }
        return path2;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (fallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallback", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (fallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallback", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (macPart != null && SystemInfo.isMac) {
            return SystemProperties.getUserHome() + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = SystemProperties.getUserHome() + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return SystemProperties.getUserHome() + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }
}

