/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.util.ClassLoaderHelper;
import com.amazonaws.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class HandlerChainFactory {
    public List<RequestHandler2> newRequestHandlerChain(String resource2) {
        return this.createRequestHandlerChain(resource2, RequestHandler.class);
    }

    public List<RequestHandler2> newRequestHandler2Chain(String resource2) {
        return this.createRequestHandlerChain(resource2, RequestHandler2.class);
    }

    private List<RequestHandler2> createRequestHandlerChain(String resource2, Class<?> handlerApiClass) {
        ArrayList<RequestHandler2> handlers;
        block17: {
            handlers = new ArrayList<RequestHandler2>();
            BufferedReader reader2 = null;
            try {
                String requestHandlerClassName;
                block18: {
                    InputStream input = this.getClass().getResourceAsStream(resource2);
                    if (input == null) {
                        ArrayList<RequestHandler2> arrayList = handlers;
                        return arrayList;
                    }
                    reader2 = new BufferedReader(new InputStreamReader(input, StringUtils.UTF8));
                    while (true) {
                        Object h;
                        if ((requestHandlerClassName = reader2.readLine()) == null) {
                            break block17;
                        }
                        if ((requestHandlerClassName = requestHandlerClassName.trim()).equals("")) continue;
                        Class<?> requestHandlerClass = ClassLoaderHelper.loadClass(requestHandlerClassName, handlerApiClass, this.getClass());
                        Object requestHandlerObject = requestHandlerClass.newInstance();
                        if (!handlerApiClass.isInstance(requestHandlerObject)) break block18;
                        if (handlerApiClass == RequestHandler2.class) {
                            h = (RequestHandler2)requestHandlerObject;
                            handlers.add((RequestHandler2)h);
                            continue;
                        }
                        if (handlerApiClass != RequestHandler.class) break;
                        h = (RequestHandler)requestHandlerObject;
                        handlers.add(RequestHandler2.adapt((RequestHandler)h));
                    }
                    throw new IllegalStateException();
                }
                throw new AmazonClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + requestHandlerClassName + "') does not implement the " + handlerApiClass + " API.");
            }
            catch (Exception e2) {
                throw new AmazonClientException("Unable to instantiate request handler chain for client: " + e2.getMessage(), e2);
            }
            finally {
                try {
                    if (reader2 != null) {
                        reader2.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return handlers;
    }
}

