/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.regions.LegacyRegionXmlLoadUtils;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadata;
import com.amazonaws.regions.RegionMetadataFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public class RegionUtils {
    private static volatile RegionMetadata regionMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata getRegionMetadata() {
        RegionMetadata rval = regionMetadata;
        if (rval != null) {
            return rval;
        }
        Class<RegionUtils> clazz = RegionUtils.class;
        synchronized (RegionUtils.class) {
            if (regionMetadata == null) {
                RegionUtils.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return regionMetadata;
        }
    }

    public static void initialize() {
        regionMetadata = RegionMetadataFactory.create();
    }

    public static void initializeWithMetadata(RegionMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        regionMetadata = metadata;
    }

    public static List<Region> getRegions() {
        return RegionUtils.getRegionMetadata().getRegions();
    }

    public static List<Region> getRegionsForService(String serviceAbbreviation) {
        return RegionUtils.getRegionMetadata().getRegionsForService(serviceAbbreviation);
    }

    public static Region getRegion(String regionName) {
        return RegionUtils.getRegionMetadata().getRegion(regionName);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromURI(URI uri) throws IOException {
        return RegionUtils.loadMetadataFromURI(uri, null);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromURI(URI uri, ClientConfiguration config) throws IOException {
        return LegacyRegionXmlLoadUtils.load(uri, config);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromFile(File file2) throws IOException {
        return LegacyRegionXmlLoadUtils.load(file2);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(String name2) throws IOException {
        return LegacyRegionXmlLoadUtils.load(RegionUtils.class, name2);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(Class<?> clazz, String name2) throws IOException {
        return LegacyRegionXmlLoadUtils.load(clazz, name2);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromResource(ClassLoader classLoader, String name2) throws IOException {
        return LegacyRegionXmlLoadUtils.load(classLoader, name2);
    }

    @Deprecated
    public static RegionMetadata loadMetadataFromInputStream(InputStream stream) throws IOException {
        return LegacyRegionXmlLoadUtils.load(stream);
    }

    @Deprecated
    public static void init() {
        RegionUtils.initialize();
    }

    @Deprecated
    public static synchronized void initializeFromURI(URI uri) {
        RegionUtils.initializeFromURI(uri, null);
    }

    @Deprecated
    public static synchronized void initializeFromURI(URI uri, ClientConfiguration config) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromURI(uri, config);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from " + uri, exception);
        }
    }

    @Deprecated
    public static synchronized void initializeFromFile(File file2) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromFile(file2);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from " + file2, exception);
        }
    }

    @Deprecated
    public static synchronized void initializeFromResource(String name2) {
        RegionUtils.initializeFromResource(RegionUtils.class, name2);
    }

    @Deprecated
    public static synchronized void initializeFromResource(Class<?> clazz, String name2) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(clazz, name2);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from resource " + name2, exception);
        }
    }

    @Deprecated
    public static synchronized void initializeFromResource(ClassLoader classLoader, String name2) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(classLoader, name2);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from resource " + name2, exception);
        }
    }
}

