/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transport.http.AuthSchemePool;
import org.eclipse.aether.transport.http.SslConfig;
import org.eclipse.aether.transport.http.SslSocketFactory;
import org.eclipse.aether.util.ConfigUtils;

final class GlobalState
implements Closeable {
    private static final String KEY = GlobalState.class.getName();
    private static final String CONFIG_PROP_CACHE_STATE = "aether.connector.http.cacheState";
    private final ConcurrentMap<SslConfig, ClientConnectionManager> connectionManagers = new ConcurrentHashMap<SslConfig, ClientConnectionManager>();
    private final ConcurrentMap<CompoundKey, Object> userTokens = new ConcurrentHashMap<CompoundKey, Object>();
    private final ConcurrentMap<HttpHost, AuthSchemePool> authSchemePools = new ConcurrentHashMap<HttpHost, AuthSchemePool>();
    private final ConcurrentMap<CompoundKey, Boolean> expectContinues = new ConcurrentHashMap<CompoundKey, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalState get(RepositorySystemSession session) {
        RepositoryCache repoCache = session.getCache();
        if (repoCache == null) return null;
        if (!ConfigUtils.getBoolean(session, true, CONFIG_PROP_CACHE_STATE)) {
            return null;
        }
        Object tmp = repoCache.get(session, KEY);
        if (tmp instanceof GlobalState) {
            return (GlobalState)tmp;
        }
        Class<GlobalState> clazz = GlobalState.class;
        synchronized (GlobalState.class) {
            tmp = repoCache.get(session, KEY);
            if (tmp instanceof GlobalState) {
                return (GlobalState)tmp;
            }
            GlobalState cache = new GlobalState();
            repoCache.put(session, KEY, cache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache;
        }
    }

    private GlobalState() {
    }

    @Override
    public void close() {
        Iterator it = this.connectionManagers.entrySet().iterator();
        while (it.hasNext()) {
            ClientConnectionManager connMgr = (ClientConnectionManager)it.next().getValue();
            it.remove();
            connMgr.shutdown();
        }
    }

    public ClientConnectionManager getConnectionManager(SslConfig config) {
        ClientConnectionManager manager = (ClientConnectionManager)this.connectionManagers.get(config);
        if (manager == null) {
            ClientConnectionManager connMgr = GlobalState.newConnectionManager(config);
            manager = this.connectionManagers.putIfAbsent(config, connMgr);
            if (manager != null) {
                connMgr.shutdown();
            } else {
                manager = connMgr;
            }
        }
        return manager;
    }

    public static ClientConnectionManager newConnectionManager(SslConfig sslConfig) {
        SchemeRegistry schemeReg = new SchemeRegistry();
        schemeReg.register(new Scheme("http", 80, new PlainSocketFactory()));
        schemeReg.register(new Scheme("https", 443, new SslSocketFactory(sslConfig)));
        PoolingClientConnectionManager connMgr = new PoolingClientConnectionManager(schemeReg);
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(50);
        return connMgr;
    }

    public Object getUserToken(CompoundKey key2) {
        return this.userTokens.get(key2);
    }

    public void setUserToken(CompoundKey key2, Object userToken) {
        if (userToken != null) {
            this.userTokens.put(key2, userToken);
        } else {
            this.userTokens.remove(key2);
        }
    }

    public ConcurrentMap<HttpHost, AuthSchemePool> getAuthSchemePools() {
        return this.authSchemePools;
    }

    public Boolean getExpectContinue(CompoundKey key2) {
        return (Boolean)this.expectContinues.get(key2);
    }

    public void setExpectContinue(CompoundKey key2, boolean enabled) {
        this.expectContinues.put(key2, enabled);
    }

    static class CompoundKey {
        private final Object[] keys;

        public CompoundKey(Object ... keys2) {
            this.keys = keys2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            CompoundKey that = (CompoundKey)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            int hash2 = 17;
            hash2 = hash2 * 31 + Arrays.hashCode(this.keys);
            return hash2;
        }

        public String toString() {
            return Arrays.toString(this.keys);
        }
    }
}

