/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenerManager
implements ListenerManager {
    private final Map<Object, ListenerDetails> allListeners = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Object, ListenerDetails> allLoggers = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Class<?>, EventBroadcast> broadcasters = new HashMap();
    private final Object lock = new Object();
    private final DefaultListenerManager parent;

    public DefaultListenerManager() {
        this(null);
    }

    private DefaultListenerManager(DefaultListenerManager parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allListeners.containsKey(listener)) {
                details = new ListenerDetails(listener);
                this.allListeners.put(listener, details);
            }
        }
        if (details != null) {
            details.useAsListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        ListenerDetails details;
        Object object = this.lock;
        synchronized (object) {
            details = this.allListeners.remove(listener);
            if (details != null) {
                details.disconnect();
            }
        }
        if (details != null) {
            details.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object logger) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allLoggers.containsKey(logger)) {
                details = new ListenerDetails(logger);
                this.allLoggers.put(logger, details);
            }
        }
        if (details != null) {
            details.useAsLogger();
        }
    }

    @Override
    public <T> T getBroadcaster(Class<T> listenerClass) {
        return this.getBroadcasterInternal(listenerClass).getBroadcaster();
    }

    @Override
    public <T> ListenerBroadcast<T> createAnonymousBroadcaster(Class<T> listenerClass) {
        ListenerBroadcast<T> broadcast = new ListenerBroadcast<T>(listenerClass);
        broadcast.add(this.getBroadcasterInternal(listenerClass).getDispatch(true));
        return broadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> EventBroadcast<T> getBroadcasterInternal(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            EventBroadcast<T> broadcaster = this.broadcasters.get(listenerClass);
            if (broadcaster == null) {
                broadcaster = new EventBroadcast<T>(listenerClass);
                this.broadcasters.put(listenerClass, broadcaster);
                for (ListenerDetails listener : this.allListeners.values()) {
                    broadcaster.maybeAdd(listener);
                }
                for (ListenerDetails logger : this.allLoggers.values()) {
                    broadcaster.maybeSetLogger(logger);
                }
            }
            return broadcaster;
        }
    }

    @Override
    public ListenerManager createChild() {
        return new DefaultListenerManager(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerDetails
    implements Dispatch<MethodInvocation> {
        final Object listener;
        final Dispatch<MethodInvocation> dispatch;
        final AtomicBoolean removed = new AtomicBoolean();
        final ReentrantLock notifyingLock = new ReentrantLock();

        public ListenerDetails(Object listener) {
            this.listener = listener;
            this.dispatch = new ReflectionDispatch(listener);
        }

        void disconnect() {
            this.removed.set(true);
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (!this.removed.get()) {
                this.dispatch.dispatch(message);
            }
        }

        void startNotification() {
            this.notifyingLock.lock();
        }

        void endNotification() {
            this.notifyingLock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove() {
            this.notifyingLock.lock();
            try {
                for (EventBroadcast broadcaster : Lists.newArrayList(DefaultListenerManager.this.broadcasters.values())) {
                    broadcaster.maybeRemove(this);
                }
            }
            finally {
                this.notifyingLock.unlock();
            }
        }

        void useAsLogger() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeSetLogger(this);
            }
        }

        void useAsListener() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeAdd(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventBroadcast<T>
    implements Dispatch<MethodInvocation> {
        private final Class<T> type;
        private final ListenerDispatch dispatch;
        private final ListenerDispatch dispatchNoLogger;
        private volatile ProxyDispatchAdapter<T> source;
        private final Set<ListenerDetails> listeners = new LinkedHashSet<ListenerDetails>();
        private final List<Runnable> queuedOperations = new LinkedList<Runnable>();
        private final ReentrantLock broadcasterLock = new ReentrantLock();
        private ListenerDetails logger;
        private Dispatch<MethodInvocation> parentDispatch;
        private List<Dispatch<MethodInvocation>> allWithLogger = Collections.emptyList();
        private List<Dispatch<MethodInvocation>> allWithNoLogger = Collections.emptyList();

        EventBroadcast(Class<T> type) {
            this.type = type;
            this.dispatch = new ListenerDispatch(type, true);
            this.dispatchNoLogger = new ListenerDispatch(type, false);
            if (DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(type).getDispatch(true);
                this.invalidateDispatchCache();
            }
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch.dispatch(message);
        }

        Dispatch<MethodInvocation> getDispatch(boolean includeLogger) {
            return includeLogger ? this.dispatch : this.dispatchNoLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getBroadcaster() {
            if (this.source == null) {
                EventBroadcast eventBroadcast = this;
                synchronized (eventBroadcast) {
                    if (this.source == null) {
                        this.source = new ProxyDispatchAdapter<T>(this, this.type, new Class[0]);
                    }
                }
            }
            return this.source.getSource();
        }

        private void invalidateDispatchCache() {
            this.ensureAllWithLoggerInitialized();
            this.ensureAllWithoutLoggerInitialized();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeAdd(final ListenerDetails listener) {
            if (this.type.isInstance(listener.listener)) {
                if (this.broadcasterLock.tryLock()) {
                    try {
                        this.listeners.add(listener);
                        this.invalidateDispatchCache();
                    }
                    finally {
                        this.broadcasterLock.unlock();
                    }
                }
                List<Runnable> list = this.queuedOperations;
                synchronized (list) {
                    this.queuedOperations.add(new Runnable(){

                        public void run() {
                            EventBroadcast.this.listeners.add(listener);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void maybeRemove(final ListenerDetails listener) {
            if (this.broadcasterLock.tryLock()) {
                try {
                    if (!this.listeners.remove(listener)) return;
                    this.invalidateDispatchCache();
                    return;
                }
                finally {
                    this.broadcasterLock.unlock();
                }
            }
            List<Runnable> list = this.queuedOperations;
            synchronized (list) {
                this.queuedOperations.add(new Runnable(){

                    public void run() {
                        EventBroadcast.this.listeners.remove(listener);
                    }
                });
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeSetLogger(final ListenerDetails candidate) {
            if (this.type.isInstance(candidate.listener)) {
                if (this.broadcasterLock.tryLock()) {
                    try {
                        this.doSetLogger(candidate);
                        this.invalidateDispatchCache();
                    }
                    finally {
                        this.broadcasterLock.unlock();
                    }
                }
                List<Runnable> list = this.queuedOperations;
                synchronized (list) {
                    this.queuedOperations.add(new Runnable(){

                        public void run() {
                            EventBroadcast.this.doSetLogger(candidate);
                        }
                    });
                }
            }
        }

        private void doSetLogger(ListenerDetails candidate) {
            if (this.logger == null && DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(this.type).getDispatch(false);
            }
            this.logger = candidate;
        }

        private List<Dispatch<MethodInvocation>> startNotification(boolean includeLogger) {
            this.takeOwnership();
            List<Dispatch<MethodInvocation>> result = includeLogger ? this.allWithLogger : this.allWithNoLogger;
            this.doStartNotification(result);
            return result;
        }

        private void doStartNotification(List<Dispatch<MethodInvocation>> result) {
            for (Dispatch<MethodInvocation> dispatch : result) {
                if (!(dispatch instanceof ListenerDetails)) continue;
                ListenerDetails listenerDetails = (ListenerDetails)dispatch;
                listenerDetails.startNotification();
            }
        }

        private void ensureAllWithoutLoggerInitialized() {
            if (this.parentDispatch == null && this.listeners.isEmpty()) {
                this.allWithNoLogger = Collections.emptyList();
            } else {
                ArrayList<Dispatch<MethodInvocation>> dispatchers = new ArrayList<Dispatch<MethodInvocation>>();
                if (this.parentDispatch != null) {
                    dispatchers.add(this.parentDispatch);
                }
                dispatchers.addAll(this.listeners);
                this.allWithNoLogger = dispatchers;
            }
        }

        private void ensureAllWithLoggerInitialized() {
            this.allWithLogger = this.logger == null && this.parentDispatch == null && this.listeners.isEmpty() ? Collections.emptyList() : this.buildAllWithLogger();
        }

        private void takeOwnership() {
            if (this.broadcasterLock.isHeldByCurrentThread()) {
                throw new IllegalStateException(String.format("Cannot notify listeners of type %s as these listeners are already being notified.", this.type.getSimpleName()));
            }
            this.broadcasterLock.lock();
        }

        private List<Dispatch<MethodInvocation>> buildAllWithLogger() {
            ArrayList<Dispatch<MethodInvocation>> result = new ArrayList<Dispatch<MethodInvocation>>();
            if (this.logger != null) {
                result.add(this.logger);
            }
            if (this.parentDispatch != null) {
                result.add(this.parentDispatch);
            }
            result.addAll(this.listeners);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endNotification(List<Dispatch<MethodInvocation>> dispatchers) {
            for (Dispatch<MethodInvocation> dispatcher : dispatchers) {
                if (!(dispatcher instanceof ListenerDetails)) continue;
                ListenerDetails listener = (ListenerDetails)dispatcher;
                listener.endNotification();
            }
            try {
                List<Runnable> list = this.queuedOperations;
                synchronized (list) {
                    if (!this.queuedOperations.isEmpty()) {
                        for (Runnable queuedOperation : this.queuedOperations) {
                            queuedOperation.run();
                        }
                        this.invalidateDispatchCache();
                    }
                }
            }
            finally {
                this.broadcasterLock.unlock();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ListenerDispatch
        extends AbstractBroadcastDispatch<T> {
            private final boolean includeLogger;

            ListenerDispatch(Class<T> type, boolean includeLogger) {
                super(type);
                this.includeLogger = includeLogger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatch(MethodInvocation invocation) {
                List dispatchers = EventBroadcast.this.startNotification(this.includeLogger);
                try {
                    if (!dispatchers.isEmpty()) {
                        this.dispatch(invocation, dispatchers.iterator());
                    }
                }
                finally {
                    EventBroadcast.this.endNotification(dispatchers);
                }
            }
        }
    }
}

