/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.diagnostic;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.DefaultLogger;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.org.apache.log4j.Level;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();
    static final Function<Attachment, String> ATTACHMENT_TO_STRING = new Function<Attachment, String>(){

        @Override
        public String fun(Attachment attachment) {
            return attachment.getPath() + "\n" + attachment.getDisplayText();
        }
    };

    public static void setFactory(@NotNull Class<? extends Factory> factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "setFactory"));
        }
        if (Logger.isInitialized()) {
            if (factory2.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor = factory2.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull @NonNls String category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "getInstance"));
        }
        Logger logger = ourFactory.getLoggerInstance(category);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "getInstance"));
        }
        return logger;
    }

    @NotNull
    public static Logger getInstance(@NotNull Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "getInstance"));
        }
        Logger logger = Logger.getInstance("#" + cl.getName());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "getInstance"));
        }
        return logger;
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(@NonNls String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message, Object ... details) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "debug"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "debug"));
        }
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message) {
        this.debug(message);
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "info"));
        }
        this.info(t.getMessage(), t);
    }

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, @Nullable Throwable var2);

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "warn"));
        }
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(@NonNls String var1, @Nullable Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new Throwable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        if (attachments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachments", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "error"));
        }
        this.error(message, (Throwable)null, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING));
    }

    public void error(@NonNls String message, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "error"));
        }
        this.error(message, new Throwable(), details);
    }

    public void error(@NonNls String message, @Nullable Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger", "error"));
        }
        this.error(t.getMessage(), t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public abstract void error(@NonNls String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value, @Nullable @NonNls Object message) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable());
        }
        return value;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    protected static Throwable checkException(@Nullable Throwable t) {
        return t instanceof ControlFlowException ? new Throwable("Control-flow exceptions should never be logged", t) : t;
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger$DefaultFactory", "getLoggerInstance"));
            }
            DefaultLogger defaultLogger = new DefaultLogger(category);
            if (defaultLogger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger$DefaultFactory", "getLoggerInstance"));
            }
            return defaultLogger;
        }
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }
}

