/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiParameterStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public class PsiMethodStubImpl
extends StubBase<PsiMethod>
implements PsiMethodStub {
    private final TypeInfo myReturnType;
    private final byte myFlags;
    private final String myName;
    private String myDefaultValueText;

    public PsiMethodStubImpl(StubElement parent2, String name, @NotNull TypeInfo returnType, byte flags, @Nullable String defaultValueText) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl", "<init>"));
        }
        super(parent2, PsiMethodStubImpl.isAnnotationMethod(flags) ? JavaStubElementTypes.ANNOTATION_METHOD : JavaStubElementTypes.METHOD);
        this.myReturnType = returnType;
        this.myFlags = flags;
        this.myName = name;
        this.myDefaultValueText = defaultValueText;
    }

    @Override
    public boolean isConstructor() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    @Override
    public boolean isVarArgs() {
        return BitUtil.isSet((int)this.myFlags, 2);
    }

    @Override
    public boolean isAnnotationMethod() {
        return PsiMethodStubImpl.isAnnotationMethod(this.myFlags);
    }

    public static boolean isAnnotationMethod(byte flags) {
        return BitUtil.isSet((int)flags, 4);
    }

    @Override
    public String getDefaultValueText() {
        return this.myDefaultValueText;
    }

    @Override
    @NotNull
    public TypeInfo getReturnTypeText(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myReturnType.applyAnnotations(this) : this.myReturnType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiMethodStubImpl", "getReturnTypeText"));
        }
        return typeInfo;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet((int)this.myFlags, 8);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet((int)this.myFlags, 16);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet((int)this.myFlags, 32);
    }

    @Override
    public PsiParameterStub findParameter(int idx) {
        StubElement list2 = null;
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiParameterListStub)) continue;
            list2 = (PsiParameterListStub)child;
            break;
        }
        if (list2 != null) {
            List<StubElement> params = list2.getChildrenStubs();
            return (PsiParameterStub)params.get(idx);
        }
        throw new RuntimeException("No parameter(s) [yet?]");
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public void setDefaultValueText(String defaultValueText) {
        this.myDefaultValueText = defaultValueText;
    }

    public static byte packFlags(boolean isConstructor, boolean isAnnotationMethod, boolean isVarargs, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isConstructor) {
            flags = (byte)(flags | 1);
        }
        if (isAnnotationMethod) {
            flags = (byte)(flags | 4);
        }
        if (isVarargs) {
            flags = (byte)(flags | 2);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 8);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 0x10);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiMethodStub[");
        if (this.isConstructor()) {
            builder.append("cons ");
        }
        if (this.isAnnotationMethod()) {
            builder.append("annotation ");
        }
        if (this.isVarArgs()) {
            builder.append("varargs ");
        }
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder.append("deprecated ");
        }
        builder.append(this.myName).append(":").append(this.myReturnType);
        String defaultValue = this.getDefaultValueText();
        if (defaultValue != null) {
            builder.append(" default=").append(defaultValue);
        }
        builder.append("]");
        return builder.toString();
    }
}

