/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"escape", "", "s", "generateSignature", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin-compiler"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), Visibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "descriptor.containingDeclaration");
            String string2 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string2 == null) {
                return null;
            }
            String parent2 = string2;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor) && ((CallableDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder = new StringBuilder().append(parent2).append(separator);
            String string3 = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string3, "descriptor.name.asString()");
            string = stringBuilder.append(SignatureUtilsKt.escape(string3)).append("|").append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            String module2 = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Iterable iterable = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Sequence<String> sequence2 = SequencesKt.sequenceOf(module2);
            void var6_9 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Name name = (Name)item$iv$iv;
                collection = destination$iv$iv;
                String string4 = it.getIdentifier();
                collection.add(string4);
            }
            collection = (List)destination$iv$iv;
            Sequence<String> parts = SequencesKt.plus(sequence2, (Iterable)collection);
            string = SequencesKt.joinToString$default(parts, ".", null, null, 0, null, generateSignature.1.INSTANCE, 30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "descriptor.containingDeclaration");
            String string5 = SignatureUtilsKt.generateSignature(declarationDescriptor3);
            if (string5 == null) {
                return null;
            }
            String parent3 = string5;
            if (((ClassDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append(parent3).append("$");
            String string6 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string6, "descriptor.name.asString()");
            string = stringBuilder.append(SignatureUtilsKt.escape(string6)).toString();
        } else {
            return null;
        }
        return string;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        String string = s;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    string2 = "" + '\\' + c;
                    break;
                }
                default: {
                    string2 = String.valueOf(c);
                }
            }
            String escapedChar = string2;
            sb.append(escapedChar);
        }
        String string3 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string3, "sb.toString()");
        return string3;
    }

    @NotNull
    public static final /* synthetic */ String access$escape(@NotNull String s) {
        return SignatureUtilsKt.escape(s);
    }
}

