/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J2\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "defineLocalVariablesFromDestructuringDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getExpectedTypeForComponent", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "resolveComponentFunctionAndGetType", "componentName", "Lorg/jetbrains/kotlin/name/Name;", "resolveInitializer", "componentIndex", "", "resolveLocalVariablesFromDestructuringDeclaration", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "kotlin-compiler"})
public final class DestructuringDeclarationResolver {
    private final FakeCallResolver fakeCallResolver;
    private final LocalVariableResolver localVariableResolver;
    private final TypeResolver typeResolver;

    @NotNull
    public final List<VariableDescriptor> resolveLocalVariablesFromDestructuringDeclaration(@NotNull LexicalScope scope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ArrayList<LocalVariableDescriptor> result2 = new ArrayList<LocalVariableDescriptor>();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)destructuringDeclaration.getEntries())) {
            KtDestructuringDeclarationEntry entry;
            int componentIndex = indexedValue.component1();
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry = (KtDestructuringDeclarationEntry)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclarationEntry, "entry");
            KotlinType componentType = this.resolveInitializer(ktDestructuringDeclarationEntry, receiver, initializer2, context, componentIndex);
            KtVariableDeclaration ktVariableDeclaration = entry;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$kotlin_compiler(scope, ktVariableDeclaration, componentType, bindingTrace);
            result2.add(variableDescriptor);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void defineLocalVariablesFromDestructuringDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(writableScope, "writableScope");
        Intrinsics.checkParameterIsNotNull(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable iterable = this.resolveLocalVariablesFromDestructuringDeclaration(writableScope, destructuringDeclaration, receiver, initializer2, context);
        for (Object element$iv : $receiver$iv) {
            VariableDescriptor it = (VariableDescriptor)element$iv;
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context.trace, it);
            writableScope.addVariableDescriptor(it);
        }
    }

    @NotNull
    public final KotlinType resolveInitializer(@NotNull KtDestructuringDeclarationEntry entry, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context, int componentIndex) {
        Intrinsics.checkParameterIsNotNull(entry, "entry");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Name componentName = DataClassDescriptorResolver.INSTANCE.createComponentName(componentIndex + 1);
        return this.resolveComponentFunctionAndGetType(componentName, context, entry, receiver, initializer2);
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer2) {
        KotlinType kotlinType;
        ExpressionTypingContext newContext;
        Function0<SimpleType> errorType$ = new Function0<SimpleType>(componentName){
            final /* synthetic */ Name $componentName;

            @NotNull
            public final SimpleType invoke() {
                return ErrorUtils.createErrorType("" + this.$componentName + "() return type");
            }
            {
                this.$componentName = name;
                super(0);
            }
        };
        if (receiver == null) {
            Object object = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull(object, "errorType()");
            return (KotlinType)object;
        }
        KotlinType expectedType2 = this.getExpectedTypeForComponent(context, entry);
        ExpressionTypingContext expressionTypingContext = newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType2)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "newContext");
        ResolutionContext resolutionContext = expressionTypingContext;
        KtExpression ktExpression = entry;
        KtExpression ktExpression2 = initializer2;
        if (ktExpression2 == null) {
            ktExpression2 = entry;
        }
        OverloadResolutionResults<FunctionDescriptor> results = this.fakeCallResolver.resolveFakeCall(resolutionContext, receiver, componentName, ktExpression, ktExpression2, FakeCallKind.COMPONENT, CollectionsKt.emptyList());
        if (!results.isSuccess()) {
            Object object = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull(object, "errorType()");
            return (KotlinType)object;
        }
        context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
        KotlinType functionReturnType = results.getResultingDescriptor().getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType2)) {
            BindingTrace bindingTrace = context.trace;
            KtExpression ktExpression3 = initializer2;
            if (ktExpression3 == null) {
                ktExpression3 = entry;
            }
            bindingTrace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)ktExpression3), componentName, functionReturnType, expectedType2));
        }
        if ((kotlinType = functionReturnType) == null) {
            Object object = errorType$.invoke();
            Intrinsics.checkExpressionValueIsNotNull(object, "errorType()");
            kotlinType = (KotlinType)object;
        }
        return kotlinType;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.NO_EXPECTED_TYPE");
            return simpleType2;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtTypeReference ktTypeReference2 = entryTypeRef;
        Intrinsics.checkExpressionValueIsNotNull(ktTypeReference2, "entryTypeRef");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return this.typeResolver.resolveType(lexicalScope, ktTypeReference2, bindingTrace, true);
    }

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkParameterIsNotNull(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkParameterIsNotNull(localVariableResolver, "localVariableResolver");
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }
}

