/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.VersionConstraintInternal;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;

public class DefaultMutableVersionConstraint
extends AbstractVersionConstraint
implements VersionConstraintInternal {
    private String prefer;
    private List<String> rejects;

    public DefaultMutableVersionConstraint(String version, boolean strict) {
        this.prefer = version;
        if (strict) {
            this.doStrict();
        } else {
            this.rejects = Collections.emptyList();
        }
    }

    public DefaultMutableVersionConstraint(String version, List<String> rejects) {
        this.prefer = Strings.nullToEmpty((String)version);
        this.rejects = rejects;
    }

    private void doStrict() {
        DefaultVersionSelectorScheme versionSelectorScheme = new DefaultVersionSelectorScheme(new DefaultVersionComparator());
        VersionSelector preferredSelector = versionSelectorScheme.parseSelector(this.prefer);
        VersionSelector rejectedSelector = versionSelectorScheme.complementForRejection(preferredSelector);
        this.rejects = Collections.singletonList(rejectedSelector.getSelector());
    }

    public DefaultMutableVersionConstraint(String version) {
        this(version, false);
    }

    @Override
    public ImmutableVersionConstraint asImmutable() {
        String v = this.prefer == null ? "" : this.prefer;
        return new DefaultImmutableVersionConstraint(v, this.rejects);
    }

    public String getPreferredVersion() {
        return this.prefer;
    }

    public void prefer(String version) {
        this.prefer = version;
        this.rejects = Collections.emptyList();
    }

    public void strictly(String version) {
        this.prefer = version;
        this.doStrict();
    }

    public List<String> getRejectedVersions() {
        return this.rejects;
    }
}

