/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.NotNull;

public class PathUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PathUtil");

    private PathUtil() {
    }

    @NotNull
    public static String getLocalPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        String string = FileUtil.toSystemDependentName(StringUtil.trimEnd(path2, "!/"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getLocalPath"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "toPresentableUrl"));
        }
        return string;
    }

    @NotNull
    public static String getFileName(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathUtil", "getFileName"));
        }
        String string = PathUtilRt.getFileName(path2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathUtil", "getFileName"));
        }
        return string;
    }
}

