/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0014\u001a\u00020\u0005H\u0086\u0002J\t\u0010\u0015\u001a\u00020\u0007H\u0086\u0002J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "shouldGenerateCode", "", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Z)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "error", "", "getError", "()Ljava/lang/Throwable;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getShouldGenerateCode", "()Z", "component1", "component2", "component3", "equals", "other", "hashCode", "", "isError", "throwIfError", "", "Companion", "Error", "RetryWithAdditionalJavaRoots", "frontend"})
public class AnalysisResult {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private final boolean shouldGenerateCode;
    @NotNull
    private static final AnalysisResult EMPTY;
    public static final Companion Companion;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AnalysisResult && Intrinsics.areEqual(this.bindingContext, ((AnalysisResult)other).bindingContext) && Intrinsics.areEqual(this.moduleDescriptor, ((AnalysisResult)other).moduleDescriptor) && this.shouldGenerateCode == ((AnalysisResult)other).shouldGenerateCode;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 29 * result2 + this.bindingContext.hashCode();
        result2 = 29 * result2 + this.moduleDescriptor.hashCode();
        result2 = 29 * result2 + ((Object)this.shouldGenerateCode).hashCode();
        return result2;
    }

    @NotNull
    public final BindingContext component1() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor component2() {
        return this.moduleDescriptor;
    }

    public final boolean component3() {
        return this.shouldGenerateCode;
    }

    @NotNull
    public final Throwable getError() {
        if (!(this instanceof Error)) {
            throw (Throwable)new IllegalStateException("Should only be called for error analysis result");
        }
        return ((Error)this).getException();
    }

    public final boolean isError() {
        return this instanceof Error;
    }

    public final void throwIfError() {
        if (this.isError()) {
            throw (Throwable)new IllegalStateException("failed to analyze: " + this.getError(), this.getError());
        }
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public final boolean getShouldGenerateCode() {
        return this.shouldGenerateCode;
    }

    protected AnalysisResult(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, boolean shouldGenerateCode) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        this.bindingContext = bindingContext;
        this.moduleDescriptor = moduleDescriptor;
        this.shouldGenerateCode = shouldGenerateCode;
    }

    public /* synthetic */ AnalysisResult(BindingContext bindingContext, ModuleDescriptor moduleDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(bindingContext, moduleDescriptor, bl);
    }

    static {
        Companion = new Companion(null);
        BindingContext bindingContext = BindingContext.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "BindingContext.EMPTY");
        ModuleDescriptor moduleDescriptor = ErrorUtils.getErrorModule();
        Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "ErrorUtils.getErrorModule()");
        EMPTY = Companion.success(bindingContext, moduleDescriptor);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        return Companion.success(bindingContext, module2);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(module2, "module");
        return Companion.success(bindingContext, module2, shouldGenerateCode);
    }

    @JvmStatic
    @NotNull
    public static final AnalysisResult error(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(error, "error");
        return Companion.error(bindingContext, error);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$Error;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "exception", "", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "frontend"})
    private static final class Error
    extends AnalysisResult {
        @NotNull
        private final Throwable exception;

        @NotNull
        public final Throwable getException() {
            return this.exception;
        }

        public Error(@NotNull BindingContext bindingContext, @NotNull Throwable exception) {
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            Intrinsics.checkParameterIsNotNull(exception, "exception");
            ModuleDescriptor moduleDescriptor = ErrorUtils.getErrorModule();
            Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "ErrorUtils.getErrorModule()");
            super(bindingContext, moduleDescriptor, false, 4, null);
            this.exception = exception;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$RetryWithAdditionalJavaRoots;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "additionalJavaRoots", "", "Ljava/io/File;", "addToEnvironment", "", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Z)V", "getAddToEnvironment", "()Z", "getAdditionalJavaRoots", "()Ljava/util/List;", "frontend"})
    public static final class RetryWithAdditionalJavaRoots
    extends AnalysisResult {
        @NotNull
        private final List<File> additionalJavaRoots;
        private final boolean addToEnvironment;

        @NotNull
        public final List<File> getAdditionalJavaRoots() {
            return this.additionalJavaRoots;
        }

        public final boolean getAddToEnvironment() {
            return this.addToEnvironment;
        }

        public RetryWithAdditionalJavaRoots(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends File> additionalJavaRoots, boolean addToEnvironment) {
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkParameterIsNotNull(additionalJavaRoots, "additionalJavaRoots");
            super(bindingContext, moduleDescriptor, false, 4, null);
            this.additionalJavaRoots = additionalJavaRoots;
            this.addToEnvironment = addToEnvironment;
        }

        public /* synthetic */ RetryWithAdditionalJavaRoots(BindingContext bindingContext, ModuleDescriptor moduleDescriptor, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = true;
            }
            this(bindingContext, moduleDescriptor, list2, bl);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getEMPTY", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "error", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "", "success", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "shouldGenerateCode", "", "frontend"})
    public static final class Companion {
        @NotNull
        public final AnalysisResult getEMPTY() {
            return EMPTY;
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            Intrinsics.checkParameterIsNotNull(module2, "module");
            return new AnalysisResult(bindingContext, module2, true);
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            Intrinsics.checkParameterIsNotNull(module2, "module");
            return new AnalysisResult(bindingContext, module2, shouldGenerateCode);
        }

        @JvmStatic
        @NotNull
        public final AnalysisResult error(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            Intrinsics.checkParameterIsNotNull(error, "error");
            return new Error(bindingContext, error);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

