/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.script;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.script.CliScriptDependenciesProviderKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.ScriptContentLoader;
import org.jetbrains.kotlin.script.ScriptDependenciesProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bj\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/common/script/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/script/ScriptDependenciesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "scriptDefinitionProvider", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;)V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "Lkotlin/collections/HashMap;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "scriptContentLoader", "Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "calculateExternalDependencies", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScriptDependencies", "cli"})
public final class CliScriptDependenciesProvider
implements ScriptDependenciesProvider {
    private final ReentrantReadWriteLock cacheLock;
    private final HashMap<String, ScriptDependencies> cache;
    private final ScriptContentLoader scriptContentLoader;
    private final KotlinScriptDefinitionProvider scriptDefinitionProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull VirtualFile file) {
        ScriptDependencies scriptDependencies;
        Intrinsics.checkParameterIsNotNull(file, "file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            scriptDependencies = this.calculateExternalDependencies(file);
        }
        finally {
            readLock.unlock();
        }
        return scriptDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScriptDependencies calculateExternalDependencies(VirtualFile file) {
        ScriptDependencies scriptDependencies;
        String path2 = file.getPath();
        ScriptDependencies cached = this.cache.get(path2);
        if (cached != null) {
            scriptDependencies = cached;
        } else {
            KotlinScriptDefinition scriptDef = this.scriptDefinitionProvider.findScriptDefinition(file);
            if (scriptDef != null) {
                int n;
                ScriptDependencies deps = this.scriptContentLoader.loadContentsAndResolveDependencies(scriptDef, file);
                if (deps != null) {
                    Logger logger = CliScriptDependenciesProviderKt.access$getLog$p();
                    StringBuilder stringBuilder = new StringBuilder().append("[kts] new cached deps for ").append(path2).append(": ");
                    Iterable iterable = deps.getClasspath();
                    String string = File.pathSeparator;
                    Intrinsics.checkExpressionValueIsNotNull(string, "File.pathSeparator");
                    logger.info(stringBuilder.append(CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null)).toString());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n2 = 0;
                int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    do {
                        n = ++n2;
                        readLock.unlock();
                    } while (n2 != n4);
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    ScriptDependencies scriptDependencies2 = this.cache.put(path2, deps);
                }
                finally {
                    n = 0;
                    int n5 = n3 - 1;
                    if (n <= n5) {
                        do {
                            int n6 = ++n;
                            readLock.lock();
                        } while (n != n5);
                    }
                    writeLock.unlock();
                }
                scriptDependencies = deps;
            } else {
                scriptDependencies = null;
            }
        }
        return scriptDependencies;
    }

    public CliScriptDependenciesProvider(@NotNull Project project, @NotNull KotlinScriptDefinitionProvider scriptDefinitionProvider) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(scriptDefinitionProvider, "scriptDefinitionProvider");
        this.scriptDefinitionProvider = scriptDefinitionProvider;
        this.cacheLock = new ReentrantReadWriteLock();
        this.cache = new HashMap();
        this.scriptContentLoader = new ScriptContentLoader(project);
    }

    @Override
    @Nullable
    public ScriptDependencies getScriptDependencies(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return ScriptDependenciesProvider.DefaultImpls.getScriptDependencies(this, file);
    }
}

