/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0010*\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0010*\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0010*\u00020\u0013\u001a\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DEPRECATED_LEVEL_NAME", "Lorg/jetbrains/kotlin/name/Name;", "DEPRECATED_MESSAGE_NAME", "DEPRECATED_REPLACE_WITH_NAME", "INLINE_ONLY_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "REPLACE_WITH_EXPRESSION_NAME", "REPLACE_WITH_IMPORTS_NAME", "createDeprecatedAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "message", "", "replaceWith", "level", "hasInlineOnlyAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isEffectivelyInlineOnly", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "isInlineOnly", "isInlineOnlyOrReifiable", "isReifiable", "core"})
public final class AnnotationUtilKt {
    private static final Name DEPRECATED_MESSAGE_NAME = Name.identifier("message");
    private static final Name DEPRECATED_REPLACE_WITH_NAME = Name.identifier("replaceWith");
    private static final Name DEPRECATED_LEVEL_NAME = Name.identifier("level");
    private static final Name REPLACE_WITH_EXPRESSION_NAME = Name.identifier("expression");
    private static final Name REPLACE_WITH_IMPORTS_NAME = Name.identifier("imports");
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");

    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(@NotNull KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull String level) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(replaceWith, "replaceWith");
        Intrinsics.checkParameterIsNotNull(level, "level");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.replaceWith;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.replaceWith");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to(REPLACE_WITH_EXPRESSION_NAME, new StringValue(replaceWith, $receiver));
        List list2 = CollectionsKt.emptyList();
        SimpleType simpleType2 = $receiver.getArrayType(Variance.INVARIANT, $receiver.getStringType());
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "getArrayType(Variance.INVARIANT, stringType)");
        pairArray[1] = TuplesKt.to(REPLACE_WITH_IMPORTS_NAME, new ArrayValue(list2, simpleType2, $receiver));
        BuiltInAnnotationDescriptor replaceWithAnnotation = new BuiltInAnnotationDescriptor($receiver, fqName2, MapsKt.mapOf(pairArray));
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.FQ_NAMES.deprecated");
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to(DEPRECATED_MESSAGE_NAME, new StringValue(message, $receiver));
        pairArray2[1] = TuplesKt.to(DEPRECATED_REPLACE_WITH_NAME, new AnnotationValue(replaceWithAnnotation));
        ClassDescriptor classDescriptor = $receiver.getDeprecationLevelEnumEntry(level);
        if (classDescriptor == null) {
            String string = "Deprecation level " + level + " not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        pairArray2[2] = TuplesKt.to(DEPRECATED_LEVEL_NAME, new EnumValue(classDescriptor));
        return new BuiltInAnnotationDescriptor($receiver, fqName3, MapsKt.mapOf(pairArray2));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "WARNING";
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!($receiver instanceof CallableMemberDescriptor)) return false;
        if (AnnotationUtilKt.isReifiable((CallableMemberDescriptor)$receiver)) return true;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
        if (AnnotationUtilKt.isReifiable(callableMemberDescriptor)) return true;
        if (!AnnotationUtilKt.isInlineOnly($receiver)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (AnnotationUtilKt.isInlineOnlyOrReifiable($receiver)) return true;
        MemberDescriptor $receiver$iv = $receiver;
        MemberDescriptor memberDescriptor = $receiver$iv;
        if (!(memberDescriptor instanceof FunctionDescriptor)) {
            memberDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)memberDescriptor;
        if (functionDescriptor == null) return false;
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        FunctionDescriptor it = functionDescriptor2;
        if (!it.isSuspend()) return false;
        if (!it.isInline()) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (!($receiver instanceof FunctionDescriptor)) break block4;
                if (AnnotationUtilKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver)) break block5;
                CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
                if (AnnotationUtilKt.hasInlineOnlyAnnotation(callableMemberDescriptor)) break block5;
            }
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }
}

