/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.UserAttributeSubpacketTags;
import org.bouncycastle.bcpg.attr.ImageAttribute;

public class UserAttributeSubpacketInputStream
extends InputStream
implements UserAttributeSubpacketTags {
    InputStream in;

    public UserAttributeSubpacketInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > 0) {
            n3 = this.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            byArray[n] = (byte)n3;
            ++n;
            --n2;
        }
        while (n2 > 0) {
            n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public UserAttributeSubpacket readPacket() throws IOException {
        int n = this.read();
        int n2 = 0;
        boolean bl = false;
        if (n < 0) {
            return null;
        }
        if (n < 192) {
            n2 = n;
        } else if (n <= 223) {
            n2 = (n - 192 << 8) + this.in.read() + 192;
        } else if (n == 255) {
            n2 = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
            bl = true;
        } else {
            throw new IOException("unrecognised length reading user attribute sub packet");
        }
        int n3 = this.in.read();
        if (n3 < 0) {
            throw new EOFException("unexpected EOF reading user attribute sub packet");
        }
        byte[] byArray = new byte[n2 - 1];
        this.readFully(byArray, 0, byArray.length);
        int n4 = n3;
        switch (n4) {
            case 1: {
                return new ImageAttribute(bl, byArray);
            }
        }
        return new UserAttributeSubpacket(n4, bl, byArray);
    }
}

