/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Whitelist {
    public final ClassLoader javaClassLoader;
    public final List<Struct> whitelistStructs;

    public Whitelist(ClassLoader javaClassLoader, List<Struct> whitelistStructs) {
        this.javaClassLoader = Objects.requireNonNull(javaClassLoader);
        this.whitelistStructs = Collections.unmodifiableList(Objects.requireNonNull(whitelistStructs));
    }

    public static class Field {
        public final String origin;
        public final String javaFieldName;
        public final String painlessFieldTypeName;

        public Field(String origin, String javaFieldName, String painlessFieldTypeName) {
            this.origin = Objects.requireNonNull(origin);
            this.javaFieldName = Objects.requireNonNull(javaFieldName);
            this.painlessFieldTypeName = Objects.requireNonNull(painlessFieldTypeName);
        }
    }

    public static class Method {
        public final String origin;
        public final String javaAugmentedClassName;
        public final String javaMethodName;
        public final String painlessReturnTypeName;
        public final List<String> painlessParameterTypeNames;

        public Method(String origin, String javaAugmentedClassName, String javaMethodName, String painlessReturnTypeName, List<String> painlessParameterTypeNames) {
            this.origin = Objects.requireNonNull(origin);
            this.javaAugmentedClassName = javaAugmentedClassName;
            this.javaMethodName = javaMethodName;
            this.painlessReturnTypeName = Objects.requireNonNull(painlessReturnTypeName);
            this.painlessParameterTypeNames = Collections.unmodifiableList(Objects.requireNonNull(painlessParameterTypeNames));
        }
    }

    public static final class Constructor {
        public final String origin;
        public final List<String> painlessParameterTypeNames;

        public Constructor(String origin, List<String> painlessParameterTypeNames) {
            this.origin = Objects.requireNonNull(origin);
            this.painlessParameterTypeNames = Collections.unmodifiableList(Objects.requireNonNull(painlessParameterTypeNames));
        }
    }

    public static final class Struct {
        public final String origin;
        public final String painlessTypeName;
        public final String javaClassName;
        public final List<Constructor> whitelistConstructors;
        public final List<Method> whitelistMethods;
        public final List<Field> whitelistFields;

        public Struct(String origin, String painlessTypeName, String javaClassName, List<Constructor> whitelistConstructors, List<Method> whitelistMethods, List<Field> whitelistFields) {
            this.origin = Objects.requireNonNull(origin);
            this.painlessTypeName = Objects.requireNonNull(painlessTypeName);
            this.javaClassName = Objects.requireNonNull(javaClassName);
            this.whitelistConstructors = Collections.unmodifiableList(Objects.requireNonNull(whitelistConstructors));
            this.whitelistMethods = Collections.unmodifiableList(Objects.requireNonNull(whitelistMethods));
            this.whitelistFields = Collections.unmodifiableList(Objects.requireNonNull(whitelistFields));
        }
    }
}

