/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class DiversifiedAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource, DiversifiedAggregationBuilder> {
    public static final String NAME = "diversified_sampler";
    public static final int MAX_DOCS_PER_VALUE_DEFAULT = 1;
    private static final ObjectParser<DiversifiedAggregationBuilder, Void> PARSER = new ObjectParser("diversified_sampler");
    private int shardSize = 100;
    private int maxDocsPerValue = 1;
    private String executionHint = null;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new DiversifiedAggregationBuilder(aggregationName), null);
    }

    public DiversifiedAggregationBuilder(String name) {
        super(name, ValuesSourceType.ANY, null);
    }

    public DiversifiedAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.ANY, null);
        this.shardSize = in.readVInt();
        this.maxDocsPerValue = in.readVInt();
        this.executionHint = in.readOptionalString();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardSize);
        out.writeVInt(this.maxDocsPerValue);
        out.writeOptionalString(this.executionHint);
    }

    public DiversifiedAggregationBuilder shardSize(int shardSize) {
        if (shardSize < 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than or equal to 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    public DiversifiedAggregationBuilder maxDocsPerValue(int maxDocsPerValue) {
        if (maxDocsPerValue < 0) {
            throw new IllegalArgumentException("[maxDocsPerValue] must be greater than or equal to 0. Found [" + maxDocsPerValue + "] in [" + this.name + "]");
        }
        this.maxDocsPerValue = maxDocsPerValue;
        return this;
    }

    public int maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    public DiversifiedAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public String executionHint() {
        return this.executionHint;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new DiversifiedAggregatorFactory(this.name, config, this.shardSize, this.maxDocsPerValue, this.executionHint, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SamplerAggregator.SHARD_SIZE_FIELD.getPreferredName(), this.shardSize);
        builder.field(SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD.getPreferredName(), this.maxDocsPerValue);
        if (this.executionHint != null) {
            builder.field(SamplerAggregator.EXECUTION_HINT_FIELD.getPreferredName(), this.executionHint);
        }
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.shardSize, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        DiversifiedAggregationBuilder other = (DiversifiedAggregationBuilder)obj;
        return Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.maxDocsPerValue, other.maxDocsPerValue) && Objects.equals(this.executionHint, other.executionHint);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, true, false);
        PARSER.declareInt(DiversifiedAggregationBuilder::shardSize, SamplerAggregator.SHARD_SIZE_FIELD);
        PARSER.declareInt(DiversifiedAggregationBuilder::maxDocsPerValue, SamplerAggregator.MAX_DOCS_PER_VALUE_FIELD);
        PARSER.declareString(DiversifiedAggregationBuilder::executionHint, SamplerAggregator.EXECUTION_HINT_FIELD);
    }
}

