/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.modules.output.graphics.GraphicsContentInterceptor;
import org.jfree.layouting.modules.output.graphics.GraphicsOutputProcessorMetaData;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.output.AbstractOutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.PaginatingRenderer;
import org.jfree.layouting.renderer.PrototypeBuildingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class FlowGraphicsOutputProcessor
extends AbstractOutputProcessor {
    private OutputProcessorMetaData metaData;
    private GraphicsContentInterceptor interceptor;
    private PrototypeBuildingRenderer prototypeBuilder;

    public FlowGraphicsOutputProcessor(Configuration configuration) {
        super(configuration);
        DefaultFontStorage defaultFontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData((FontStorage)defaultFontStorage, true);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicsContentInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(GraphicsContentInterceptor graphicsContentInterceptor) {
        this.interceptor = graphicsContentInterceptor;
    }

    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox) {
        if (this.interceptor != null) {
            LogicalPageDrawable logicalPageDrawable = new LogicalPageDrawable(logicalPageBox);
            this.interceptor.processLogicalPage(logicalPageKey, logicalPageDrawable);
        }
    }

    public PrototypeBuildingRenderer getPrototypeBuilder() {
        return this.prototypeBuilder;
    }

    public Renderer createRenderer(LayoutProcess layoutProcess) {
        if (!this.isGlobalStateComputed()) {
            this.prototypeBuilder = new PrototypeBuildingRenderer(layoutProcess);
            return this.prototypeBuilder;
        }
        return new PaginatingRenderer(layoutProcess);
    }
}

