/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.grails.io.support.AbstractFileResolvingResource;
import org.grails.io.support.DefaultResourceLoader;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        String pathToUse = GrailsResourceUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader == null ? DefaultResourceLoader.getDefaultClassLoader() : classLoader;
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this.path = GrailsResourceUtils.cleanPath(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        this.path = GrailsResourceUtils.cleanPath(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader == null ? this.clazz.getClassLoader() : this.classLoader;
    }

    @Override
    public boolean exists() {
        URL url = this.clazz == null ? this.classLoader.getResource(this.path) : this.clazz.getResource(this.path);
        return url != null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz == null ? this.classLoader.getResourceAsStream(this.path) : this.clazz.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.clazz == null ? this.classLoader.getResource(this.path) : this.clazz.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public URI getURI() throws IOException {
        return this.getFile().toURI();
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = GrailsResourceUtils.applyRelativePath(this.path, relativePath);
        return new ClassPathResource(pathToUse, this.classLoader, this.clazz);
    }

    @Override
    public String getFilename() {
        return GrailsResourceUtils.getFilename(this.path);
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder("class path resource [");
        if (this.clazz != null) {
            builder.append(GrailsResourceUtils.classPackageAsResourcePath(this.clazz));
            builder.append('/');
        }
        builder.append(this.path);
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassPathResource) {
            ClassPathResource otherRes = (ClassPathResource)obj;
            return this.path.equals(otherRes.path) && ClassPathResource.nullSafeEquals(this.classLoader, otherRes.classLoader) && ClassPathResource.nullSafeEquals(this.clazz, otherRes.clazz);
        }
        return false;
    }

    private static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                return Arrays.equals((Object[])o1, (Object[])o2);
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

