<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'Captcha' => [ 'Captcha' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'Captcha' => [ 'كابتشا' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'Captcha' => [ 'كابتشا' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'Captcha' => [ 'گپچا' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'Captcha' => [ '驗證碼' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'Captcha' => [ 'Kodêİtımadi' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'Captcha' => [ 'Kontraŭspamilo' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'Captcha' => [ 'Robotilõks' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'Captcha' => [ 'کپچا' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'Captcha' => [ 'Ihmiskäyttäjävarmistus' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Captcha' => [ 'Captcha' ],
];

/** Hawaiian (Hawai`i) */
$specialPageAliases['haw'] = [
	'Captcha' => [ 'Kapakā', 'Kapaka' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'Captcha' => [ 'कैप्चा', 'कैपचा' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'Captcha' => [ '画像認証' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'Captcha' => [ '캡차' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'Captcha' => [ 'Kaptscha' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'Captcha' => [ 'Captcha' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'Captcha' => [ 'رازینە_کأپچا' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'Captcha' => [ 'Captcha' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'Captcha' => [ 'ക്യാപ്ച' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = [
	'Captcha' => [ 'ПотврдниКод', 'Потврдни_код' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'Captcha' => [ 'GüvenlikKodu' ],
];

/** Cantonese (粵語) */
$specialPageAliases['yue'] = [
	'Captcha' => [ '驗證碼' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'Captcha' => [ '验证码' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'Captcha' => [ '驗證碼', '認證碼' ],
];
