// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * The metrics administrative facet interface. This interface allows
 * remote administrative clients to access metrics of an application
 * that enabled the Ice administrative facility and configured some
 * metrics views.
 *
 **/
public interface MetricsAdminPrx extends Ice.ObjectPrx
{
    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param disabledViews The names of the disabled views.
     *
     * @return The name of the enabled views.
     *
     **/
    public String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param disabledViews The names of the disabled views.
     *
     * @param context The Context map to send with the invocation.
     * @return The name of the enabled views.
     *
     **/
    public String[] getMetricsViewNames(Ice.StringSeqHolder disabledViews, java.util.Map<String, String> context);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames();

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> context);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(Ice.Callback cb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(Callback_MetricsAdmin_getMetricsViewNames cb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> context, Callback_MetricsAdmin_getMetricsViewNames cb);

    public interface FunctionalCallback_MetricsAdmin_getMetricsViewNames_Response
    {
        void apply(String[] ret, String[] disabledViews);
    }

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(FunctionalCallback_MetricsAdmin_getMetricsViewNames_Response responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(FunctionalCallback_MetricsAdmin_getMetricsViewNames_Response responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> context,
                                                     FunctionalCallback_MetricsAdmin_getMetricsViewNames_Response responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsViewNames(java.util.Map<String, String> context,
                                                     FunctionalCallback_MetricsAdmin_getMetricsViewNames_Response responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the names of enabled and disabled metrics.
     *
     * @param disabledViews The names of the disabled views.
     *
     * @param result The asynchronous result object.
     * @return The name of the enabled views.
     *
     **/
    public String[] end_getMetricsViewNames(Ice.StringSeqHolder disabledViews, Ice.AsyncResult result);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public void enableMetricsView(String name)
        throws UnknownMetricsView;

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void enableMetricsView(String name, java.util.Map<String, String> context)
        throws UnknownMetricsView;

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> context);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, Ice.Callback cb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, Callback_MetricsAdmin_enableMetricsView cb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name, java.util.Map<String, String> context, Callback_MetricsAdmin_enableMetricsView cb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Enables a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableMetricsView(String name,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Enables a metrics view.
     *
     * @param result The asynchronous result object.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public void end_enableMetricsView(Ice.AsyncResult result)
        throws UnknownMetricsView;

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public void disableMetricsView(String name)
        throws UnknownMetricsView;

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void disableMetricsView(String name, java.util.Map<String, String> context)
        throws UnknownMetricsView;

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> context);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, Ice.Callback cb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, Callback_MetricsAdmin_disableMetricsView cb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name, java.util.Map<String, String> context, Callback_MetricsAdmin_disableMetricsView cb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Disable a metrics view.
     *
     * @param name The metrics view name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_disableMetricsView(String name,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_VoidCallback responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Disable a metrics view.
     *
     * @param result The asynchronous result object.
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public void end_disableMetricsView(Ice.AsyncResult result)
        throws UnknownMetricsView;

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     *
     * @return The metrics view data.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp)
        throws UnknownMetricsView;

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     *
     * @param context The Context map to send with the invocation.
     * @return The metrics view data.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public java.util.Map<java.lang.String, Metrics[]> getMetricsView(String view, Ice.LongHolder timestamp, java.util.Map<String, String> context)
        throws UnknownMetricsView;

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> context);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, Ice.Callback cb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, Callback_MetricsAdmin_getMetricsView cb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view, java.util.Map<String, String> context, Callback_MetricsAdmin_getMetricsView cb);

    public interface FunctionalCallback_MetricsAdmin_getMetricsView_Response
    {
        void apply(java.util.Map<java.lang.String, Metrics[]> ret, long timestamp);
    }

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view,
                                                FunctionalCallback_MetricsAdmin_getMetricsView_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view,
                                                FunctionalCallback_MetricsAdmin_getMetricsView_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view,
                                                java.util.Map<String, String> context,
                                                FunctionalCallback_MetricsAdmin_getMetricsView_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param view The name of the metrics view.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsView(String view,
                                                java.util.Map<String, String> context,
                                                FunctionalCallback_MetricsAdmin_getMetricsView_Response responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics objects for the given metrics view. This
     * returns a dictionnary of metric maps for each metrics class
     * configured with the view. The timestamp allows the client to
     * compute averages which are not dependent of the invocation
     * latency for this operation.
     *
     * @param timestamp The local time of the process when the metrics
     * object were retrieved.
     *
     * @param result The asynchronous result object.
     * @return The metrics view data.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public java.util.Map<java.lang.String, Metrics[]> end_getMetricsView(Ice.LongHolder timestamp, Ice.AsyncResult result)
        throws UnknownMetricsView;

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @return The metrics failures associated with the map.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures[] getMapMetricsFailures(String view, String map)
        throws UnknownMetricsView;

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the map.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures[] getMapMetricsFailures(String view, String map, java.util.Map<String, String> context)
        throws UnknownMetricsView;

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> context);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, Ice.Callback cb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, Callback_MetricsAdmin_getMapMetricsFailures cb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view, String map, java.util.Map<String, String> context, Callback_MetricsAdmin_getMapMetricsFailures cb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view,
                                                       String map,
                                                       IceInternal.Functional_GenericCallback1<MetricsFailures[]> responseCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view,
                                                       String map,
                                                       IceInternal.Functional_GenericCallback1<MetricsFailures[]> responseCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view,
                                                       String map,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_GenericCallback1<MetricsFailures[]> responseCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMapMetricsFailures(String view,
                                                       String map,
                                                       java.util.Map<String, String> context,
                                                       IceInternal.Functional_GenericCallback1<MetricsFailures[]> responseCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                       IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                       IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics failures associated with the given view and map.
     *
     * @param result The asynchronous result object.
     * @return The metrics failures associated with the map.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures[] end_getMapMetricsFailures(Ice.AsyncResult result)
        throws UnknownMetricsView;

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @return The metrics failures associated with the metrics.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures getMetricsFailures(String view, String map, String id)
        throws UnknownMetricsView;

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @return The metrics failures associated with the metrics.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures getMetricsFailures(String view, String map, String id, java.util.Map<String, String> context)
        throws UnknownMetricsView;

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> context);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, Ice.Callback cb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, Callback_MetricsAdmin_getMetricsFailures cb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view, String map, String id, java.util.Map<String, String> context, Callback_MetricsAdmin_getMetricsFailures cb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view,
                                                    String map,
                                                    String id,
                                                    IceInternal.Functional_GenericCallback1<MetricsFailures> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view,
                                                    String map,
                                                    String id,
                                                    IceInternal.Functional_GenericCallback1<MetricsFailures> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view,
                                                    String map,
                                                    String id,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<MetricsFailures> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param view The name of the metrics view.
     *
     * @param map The name of the metrics map.
     *
     * @param id The ID of the metrics.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getMetricsFailures(String view,
                                                    String map,
                                                    String id,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<MetricsFailures> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the metrics failure associated for the given metrics.
     *
     * @param result The asynchronous result object.
     * @return The metrics failures associated with the metrics.
     *
     * @throws UnknownMetricsView Raised if the metrics view cannot be
     * found.
     *
     **/
    public MetricsFailures end_getMetricsFailures(Ice.AsyncResult result)
        throws UnknownMetricsView;
}
