/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.KCallableNamePropertyLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalFunctionsLowering;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ConstAndJvmFieldPropertiesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InnerClassConstructorCallsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InnerClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceDelegationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ObjectClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.PropertiesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SingletonReferencesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.ir.declarations.IrFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmLower;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend"})
public final class JvmLower {
    @NotNull
    private final JvmBackendContext context;

    public final void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        new FileClassLowering(this.context).lower(irFile);
        new KCallableNamePropertyLowering(this.context).lower(irFile);
        new ConstAndJvmFieldPropertiesLowering().lower(irFile);
        new PropertiesLowering().lower(irFile);
        LowerKt.runOnFilePostfix(new InterfaceLowering(this.context.getState()), irFile);
        LowerKt.runOnFilePostfix(new InterfaceDelegationLowering(this.context.getState()), irFile);
        LowerKt.runOnFilePostfix(new SharedVariablesLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new InnerClassesLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new InnerClassConstructorCallsLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new LocalFunctionsLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new EnumClassLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new ObjectClassLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new InitializersLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new SingletonReferencesLowering(this.context), irFile);
        new SyntheticAccessorLowering(this.context.getState()).lower(irFile);
        LowerKt.runOnFilePostfix(new BridgeLowering(this.context.getState()), irFile);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmLower(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }
}

