/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.services.s3.transfer.exception.FileLockException;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public enum FileLocks {

    private static final boolean EXTERNAL_LOCK = false;
    private static final Log log = LogFactory.getLog(FileLocks.class);
    private static final Map<File, RandomAccessFile> lockedFiles = new TreeMap<File, RandomAccessFile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(File file2) {
        boolean locked;
        Map<File, RandomAccessFile> map2 = lockedFiles;
        synchronized (map2) {
            if (lockedFiles.containsKey(file2)) {
                return false;
            }
        }
        Object lock = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file2, "rw");
            FileChannel fileChannel = raf.getChannel();
        }
        catch (Exception e2) {
            IOUtils.closeQuietly(raf, log);
            throw new FileLockException(e2);
        }
        Map<File, RandomAccessFile> map3 = lockedFiles;
        synchronized (map3) {
            RandomAccessFile prev2 = lockedFiles.put(file2, raf);
            if (prev2 == null) {
                locked = true;
            } else {
                locked = false;
                lockedFiles.put(file2, prev2);
            }
        }
        if (locked) {
            if (log.isDebugEnabled()) {
                log.debug("Locked file " + file2 + " with " + lock);
            }
        } else {
            IOUtils.closeQuietly(raf, log);
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileLocked(File file2) {
        Map<File, RandomAccessFile> map2 = lockedFiles;
        synchronized (map2) {
            return lockedFiles.containsKey(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unlock(File file2) {
        Map<File, RandomAccessFile> map2 = lockedFiles;
        synchronized (map2) {
            RandomAccessFile raf = lockedFiles.get(file2);
            if (raf == null) {
                return false;
            }
            IOUtils.closeQuietly(raf, log);
            lockedFiles.remove(file2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Unlocked file " + file2);
        }
        return true;
    }
}

