#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-builder
version: 0.3.4.1
id: vector-builder-0.3.4.1-IUuvT1reBBx7M25UlpFwJm
key: vector-builder-0.3.4.1-IUuvT1reBBx7M25UlpFwJm
license: MIT
copyright: (c) 2016, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/vector-builder
synopsis: Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.
    .
    [Usage]
    .
    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.
    .
    [Example]
    .
    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:
    .
    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      foldMap B.singleton list <>
    >      B.singleton element
category: Vector
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
indefinite: False
exposed-modules:
    VectorBuilder.Builder VectorBuilder.MVector VectorBuilder.MonadPlus
    VectorBuilder.Vector
hidden-modules: VectorBuilder.Prelude VectorBuilder.Core.Update
                VectorBuilder.Core.Builder
abi: ce108f3705463f141a538b5c8f0639cb
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/vector-builder-0.3.4.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/vector-builder-0.3.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/vector-builder-0.3.4.1
hs-libraries: HSvector-builder-0.3.4.1-IUuvT1reBBx7M25UlpFwJm
depends:
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7
    base-prelude-1.2.0.1-Jp4fn0lH8rP2DHoIPVF2qm base-4.10.1.0
abi-depends: vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7=d64b81e3ed8022aca04423ee7b330679
             base-prelude-1.2.0.1-Jp4fn0lH8rP2DHoIPVF2qm=3e78347d5a15e89f4fb1084b18368182
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
haddock-interfaces: /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock
haddock-html: /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

