/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.psych;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.psych.PsychLibrary;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

public class PsychParser
extends RubyObject {
    private static final Logger LOG = LoggerFactory.getLogger(PsychParser.class);
    private Parser parser;
    private Event event;

    public static void initPsychParser(Ruby ruby, RubyModule rubyModule) {
        RubyClass rubyClass = ruby.defineClassUnder("Parser", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new PsychParser(ruby, rubyClass);
            }
        }, rubyModule);
        RubyKernel.require((IRubyObject)ruby.getNil(), (IRubyObject)ruby.newString("psych/syntax_error"), (Block)Block.NULL_BLOCK);
        rubyClass.defineConstant("ANY", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_ANY_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF8", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF8_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF16LE", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF16LE_ENCODING.ordinal()));
        rubyClass.defineConstant("UTF16BE", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_UTF16BE_ENCODING.ordinal()));
        rubyClass.defineAnnotatedMethods(PsychParser.class);
    }

    public PsychParser(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        return this.parse(threadContext, iRubyObject, ruby.getNil());
    }

    private IRubyObject stringOrNilFor(Ruby ruby, String string, boolean bl) {
        if (string == null) {
            return ruby.getNil();
        }
        return this.stringFor(ruby, string, bl);
    }

    private RubyString stringFor(Ruby ruby, String string, boolean bl) {
        Encoding encoding = ruby.getDefaultInternalEncoding();
        if (encoding == null) {
            encoding = UTF8Encoding.INSTANCE;
        }
        Charset charset = RubyEncoding.UTF8;
        if (encoding.getCharset() != null) {
            charset = encoding.getCharset();
        }
        ByteList byteList = new ByteList(string.getBytes(charset), encoding);
        RubyString rubyString = RubyString.newString((Ruby)ruby, (ByteList)byteList);
        rubyString.setTaint(bl);
        return rubyString;
    }

    private StreamReader readerFor(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (iRubyObject instanceof RubyString) {
            ByteList byteList = ((RubyString)iRubyObject).getByteList();
            Encoding encoding = byteList.getEncoding();
            if (!(encoding instanceof UnicodeEncoding)) {
                byteList = EncodingUtils.strConvEnc((ThreadContext)threadContext, (ByteList)byteList, (Encoding)encoding, (Encoding)UTF8Encoding.INSTANCE);
                encoding = UTF8Encoding.INSTANCE;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            Charset charset = encoding.getCharset();
            assert (charset != null) : "charset for encoding " + encoding + " should not be null";
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, charset);
            return new StreamReader((Reader)inputStreamReader);
        }
        if (iRubyObject.respondsTo("read")) {
            UTF8Encoding uTF8Encoding = iRubyObject instanceof RubyIO ? ((RubyIO)iRubyObject).getReadEncoding() : UTF8Encoding.INSTANCE;
            Charset charset = uTF8Encoding.getCharset();
            return new StreamReader((Reader)new InputStreamReader((InputStream)new IOInputStream(iRubyObject), charset));
        }
        throw ruby.newTypeError(iRubyObject, ruby.getIO());
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        boolean bl = iRubyObject.isTaint() || iRubyObject instanceof RubyIO;
        try {
            this.parser = new ParserImpl(this.readerFor(threadContext, iRubyObject));
            if (iRubyObject2.isNil() && iRubyObject.respondsTo("path")) {
                iRubyObject2 = iRubyObject.callMethod(threadContext, "path");
            }
            IRubyObject iRubyObject3 = this.getInstanceVariable("@handler");
            while (true) {
                RubyBoolean rubyBoolean;
                this.event = this.parser.getEvent();
                if (this.event.is(Event.ID.StreamStart)) {
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"start_stream", (IRubyObject)ruby.newFixnum(PsychLibrary.YAMLEncoding.YAML_ANY_ENCODING.ordinal()));
                    continue;
                }
                if (this.event.is(Event.ID.DocumentStart)) {
                    this.handleDocumentStart(threadContext, (DocumentStartEvent)this.event, bl, iRubyObject3);
                    continue;
                }
                if (this.event.is(Event.ID.DocumentEnd)) {
                    rubyBoolean = ruby.newBoolean(!((DocumentEndEvent)this.event).getExplicit());
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"end_document", (IRubyObject)rubyBoolean);
                    continue;
                }
                if (this.event.is(Event.ID.Alias)) {
                    rubyBoolean = this.stringOrNilFor(ruby, ((AliasEvent)this.event).getAnchor(), bl);
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"alias", (IRubyObject)rubyBoolean);
                    continue;
                }
                if (this.event.is(Event.ID.Scalar)) {
                    this.handleScalar(threadContext, (ScalarEvent)this.event, bl, iRubyObject3);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceStart)) {
                    this.handleSequenceStart(threadContext, (SequenceStartEvent)this.event, bl, iRubyObject3);
                    continue;
                }
                if (this.event.is(Event.ID.SequenceEnd)) {
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"end_sequence");
                    continue;
                }
                if (this.event.is(Event.ID.MappingStart)) {
                    this.handleMappingStart(threadContext, (MappingStartEvent)this.event, bl, iRubyObject3);
                    continue;
                }
                if (this.event.is(Event.ID.MappingEnd)) {
                    Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"end_mapping");
                    continue;
                }
                if (this.event.is(Event.ID.StreamEnd)) break;
            }
            Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject3, (String)"end_stream");
        }
        catch (ParserException parserException) {
            this.parser = null;
            PsychParser.raiseParserException(threadContext, iRubyObject, (MarkedYAMLException)parserException, iRubyObject2);
        }
        catch (ScannerException scannerException) {
            this.parser = null;
            StringBuilder stringBuilder = new StringBuilder("syntax error");
            if (scannerException.getProblemMark() != null) {
                stringBuilder.append(scannerException.getProblemMark().toString());
            }
            PsychParser.raiseParserException(threadContext, iRubyObject, (MarkedYAMLException)scannerException, iRubyObject2);
        }
        catch (ReaderException readerException) {
            this.parser = null;
            PsychParser.raiseParserException(threadContext, iRubyObject, readerException, iRubyObject2);
        }
        catch (Throwable throwable) {
            Helpers.throwException((Throwable)throwable);
            return this;
        }
        return this;
    }

    private void handleDocumentStart(ThreadContext threadContext, DocumentStartEvent documentStartEvent, boolean bl, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        DumperOptions.Version version = documentStartEvent.getVersion();
        RubyArray rubyArray = version == null ? RubyArray.newArray((Ruby)ruby) : RubyArray.newArray((Ruby)ruby, (IRubyObject)ruby.newFixnum(version.major()), (IRubyObject)ruby.newFixnum(version.minor()));
        Map map = documentStartEvent.getTags();
        RubyArray rubyArray2 = RubyArray.newArray((Ruby)ruby);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                RubyString rubyString = this.stringFor(ruby, (String)entry.getKey(), bl);
                RubyString rubyString2 = this.stringFor(ruby, (String)entry.getValue(), bl);
                rubyArray2.append((IRubyObject)RubyArray.newArray((Ruby)ruby, (IRubyObject)rubyString, (IRubyObject)rubyString2));
            }
        }
        RubyBoolean rubyBoolean = ruby.newBoolean(!documentStartEvent.getExplicit());
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"start_document", (IRubyObject)rubyArray, (IRubyObject)rubyArray2, (IRubyObject)rubyBoolean);
    }

    private void handleMappingStart(ThreadContext threadContext, MappingStartEvent mappingStartEvent, boolean bl, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilFor(ruby, mappingStartEvent.getAnchor(), bl);
        IRubyObject iRubyObject3 = this.stringOrNilFor(ruby, mappingStartEvent.getTag(), bl);
        RubyBoolean rubyBoolean = ruby.newBoolean(mappingStartEvent.getImplicit());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateFlowStyle(mappingStartEvent.getFlowStyle()));
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"start_mapping", (IRubyObject[])new IRubyObject[]{iRubyObject2, iRubyObject3, rubyBoolean, rubyFixnum});
    }

    private void handleScalar(ThreadContext threadContext, ScalarEvent scalarEvent, boolean bl, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilFor(ruby, scalarEvent.getAnchor(), bl);
        IRubyObject iRubyObject3 = this.stringOrNilFor(ruby, scalarEvent.getTag(), bl);
        RubyBoolean rubyBoolean = ruby.newBoolean(scalarEvent.getImplicit().canOmitTagInPlainScalar());
        RubyBoolean rubyBoolean2 = ruby.newBoolean(scalarEvent.getImplicit().canOmitTagInNonPlainScalar());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateStyle(scalarEvent.getStyle()));
        RubyString rubyString = this.stringFor(ruby, scalarEvent.getValue(), bl);
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"scalar", (IRubyObject[])new IRubyObject[]{rubyString, iRubyObject2, iRubyObject3, rubyBoolean, rubyBoolean2, rubyFixnum});
    }

    private void handleSequenceStart(ThreadContext threadContext, SequenceStartEvent sequenceStartEvent, boolean bl, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = this.stringOrNilFor(ruby, sequenceStartEvent.getAnchor(), bl);
        IRubyObject iRubyObject3 = this.stringOrNilFor(ruby, sequenceStartEvent.getTag(), bl);
        RubyBoolean rubyBoolean = ruby.newBoolean(sequenceStartEvent.getImplicit());
        RubyFixnum rubyFixnum = ruby.newFixnum(PsychParser.translateFlowStyle(sequenceStartEvent.getFlowStyle()));
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"start_sequence", (IRubyObject[])new IRubyObject[]{iRubyObject2, iRubyObject3, rubyBoolean, rubyFixnum});
    }

    private static void raiseParserException(ThreadContext threadContext, IRubyObject iRubyObject, ReaderException readerException, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)ruby.getModule("Psych").getConstant("SyntaxError");
        IRubyObject iRubyObject3 = rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2, ruby.newFixnum(0), ruby.newFixnum(0), ruby.newFixnum(readerException.getPosition()), null == readerException.getName() ? ruby.getNil() : ruby.newString(readerException.getName()), null == readerException.toString() ? ruby.getNil() : ruby.newString(readerException.toString())}, Block.NULL_BLOCK);
        RubyKernel.raise((ThreadContext)threadContext, (IRubyObject)ruby.getKernel(), (IRubyObject[])new IRubyObject[]{iRubyObject3}, (Block)Block.NULL_BLOCK);
    }

    private static void raiseParserException(ThreadContext threadContext, IRubyObject iRubyObject, MarkedYAMLException markedYAMLException, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.runtime;
        RubyClass rubyClass = (RubyClass)ruby.getModule("Psych").getConstant("SyntaxError");
        Mark mark = markedYAMLException.getProblemMark();
        IRubyObject iRubyObject3 = rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2, ruby.newFixnum(mark.getLine() + 1), ruby.newFixnum(mark.getColumn() + 1), ruby.newFixnum(mark.getIndex()), null == markedYAMLException.getProblem() ? ruby.getNil() : ruby.newString(markedYAMLException.getProblem()), null == markedYAMLException.getContext() ? ruby.getNil() : ruby.newString(markedYAMLException.getContext())}, Block.NULL_BLOCK);
        RubyKernel.raise((ThreadContext)threadContext, (IRubyObject)ruby.getKernel(), (IRubyObject[])new IRubyObject[]{iRubyObject3}, (Block)Block.NULL_BLOCK);
    }

    private static int translateStyle(Character c) {
        if (c == null) {
            return 0;
        }
        switch (c.charValue()) {
            case '\u0000': {
                return 1;
            }
            case '\'': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '|': {
                return 4;
            }
            case '>': {
                return 5;
            }
        }
        return 0;
    }

    private static int translateFlowStyle(Boolean bl) {
        if (bl == null) {
            return 0;
        }
        if (bl.booleanValue()) {
            return 2;
        }
        return 1;
    }

    @JRubyMethod
    public IRubyObject mark(ThreadContext threadContext) {
        Ruby ruby = threadContext.runtime;
        Event event = null;
        if (this.parser != null && (event = this.parser.peekEvent()) == null) {
            event = this.event;
        }
        if (event == null) {
            return ((RubyClass)threadContext.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(threadContext, (IRubyObject)ruby.newFixnum(0), (IRubyObject)ruby.newFixnum(0), (IRubyObject)ruby.newFixnum(0), Block.NULL_BLOCK);
        }
        Mark mark = event.getStartMark();
        return ((RubyClass)threadContext.runtime.getClassFromPath("Psych::Parser::Mark")).newInstance(threadContext, (IRubyObject)ruby.newFixnum(mark.getIndex()), (IRubyObject)ruby.newFixnum(mark.getLine()), (IRubyObject)ruby.newFixnum(mark.getColumn()), Block.NULL_BLOCK);
    }
}

