/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.errors.CorruptPackIndexException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.fsck.FsckError;
import org.eclipse.jgit.internal.fsck.FsckPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;

public class DfsFsck {
    private final DfsRepository repo;
    private final DfsObjDatabase objdb;
    private ObjectChecker objChecker = new ObjectChecker();

    public DfsFsck(DfsRepository repository) {
        this.repo = repository;
        this.objdb = this.repo.getObjectDatabase();
    }

    public FsckError check(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        FsckError errors = new FsckError();
        this.checkPacks(pm, errors);
        this.checkConnectivity(pm, errors);
        return errors;
    }

    private void checkPacks(ProgressMonitor pm, FsckError errors) throws IOException, FileNotFoundException {
        try (DfsReader ctx = this.objdb.newReader();){
            for (DfsPackFile pack : this.objdb.getPacks()) {
                DfsPackDescription packDesc = pack.getPackDescription();
                try (ReadableChannel rc = this.objdb.openFile(packDesc, PackExt.PACK);){
                    this.verifyPack(pm, errors, ctx, pack, rc);
                }
                catch (MissingObjectException e2) {
                    errors.getMissingObjects().add(e2.getObjectId());
                }
                catch (CorruptPackIndexException e3) {
                    errors.getCorruptIndices().add(new FsckError.CorruptIndex(pack.getPackDescription().getFileName(PackExt.INDEX), e3.getErrorType()));
                }
            }
        }
    }

    private void verifyPack(ProgressMonitor pm, FsckError errors, DfsReader ctx, DfsPackFile pack, ReadableChannel ch) throws IOException, CorruptPackIndexException {
        FsckPackParser fpp = new FsckPackParser((ObjectDatabase)this.objdb, ch);
        fpp.setObjectChecker(this.objChecker);
        fpp.overwriteObjectCount(pack.getPackDescription().getObjectCount());
        fpp.parse(pm);
        errors.getCorruptObjects().addAll(fpp.getCorruptObjects());
        fpp.verifyIndex(pack.getPackIndex(ctx));
    }

    private void checkConnectivity(ProgressMonitor pm, FsckError errors) throws IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        try (ObjectWalk ow = new ObjectWalk(this.repo);){
            for (Ref r : this.repo.getAllRefs().values()) {
                RevObject tip;
                block10: {
                    try {
                        tip = ow.parseAny(r.getObjectId());
                        if (!r.getLeaf().getName().startsWith("refs/heads/") || tip.getType() == 1) break block10;
                        errors.getNonCommitHeads().add(r.getLeaf().getName());
                    }
                    catch (MissingObjectException e2) {
                        errors.getMissingObjects().add(e2.getObjectId());
                        continue;
                    }
                }
                ow.markStart(tip);
            }
            try {
                ow.checkConnectivity();
            }
            catch (MissingObjectException e3) {
                errors.getMissingObjects().add(e3.getObjectId());
            }
        }
        pm.endTask();
    }

    public void setObjectChecker(ObjectChecker objChecker) {
        this.objChecker = objChecker;
    }
}

