/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgpp;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;

public class Main {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.apps.svgpp.resources.Messages";
    protected static LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.apps.svgpp.resources.Messages", Main.class.getClassLoader());
    protected String[] arguments;
    protected int index;
    protected Map handlers = new HashMap();
    protected Transcoder transcoder;

    public static void main(String[] args) {
        new Main(args).run();
    }

    public Main(String[] args) {
        this.handlers.put("-doctype", new DoctypeHandler());
        this.handlers.put("-doc-width", new DocWidthHandler());
        this.handlers.put("-newline", new NewlineHandler());
        this.handlers.put("-public-id", new PublicIdHandler());
        this.handlers.put("-no-format", new NoFormatHandler());
        this.handlers.put("-system-id", new SystemIdHandler());
        this.handlers.put("-tab-width", new TabWidthHandler());
        this.handlers.put("-xml-decl", new XMLDeclHandler());
        this.transcoder = new SVGTranscoder();
        this.arguments = args;
    }

    public void run() {
        if (this.arguments.length == 0) {
            this.printUsage();
            return;
        }
        try {
            OptionHandler oh;
            while ((oh = (OptionHandler)this.handlers.get(this.arguments[this.index])) != null) {
                oh.handleOption();
            }
            TranscoderInput in = new TranscoderInput(new FileReader(this.arguments[this.index++]));
            TranscoderOutput out = this.index < this.arguments.length ? new TranscoderOutput(new FileWriter(this.arguments[this.index])) : new TranscoderOutput(new OutputStreamWriter(System.out));
            this.transcoder.transcode(in, out);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        this.printHeader();
        System.out.println(localizableSupport.formatMessage("syntax", null));
        System.out.println();
        System.out.println(localizableSupport.formatMessage("options", null));
        for (String s : this.handlers.keySet()) {
            System.out.println(((OptionHandler)this.handlers.get(s)).getDescription());
        }
    }

    protected void printHeader() {
        System.out.println(localizableSupport.formatMessage("header", null));
    }

    protected class DocWidthHandler
    implements OptionHandler {
        protected DocWidthHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCUMENT_WIDTH, new Integer(Main.this.arguments[Main.this.index++]));
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("doc-width.description", null);
        }
    }

    protected class TabWidthHandler
    implements OptionHandler {
        protected TabWidthHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_TABULATION_WIDTH, new Integer(Main.this.arguments[Main.this.index++]));
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("tab-width.description", null);
        }
    }

    protected class XMLDeclHandler
    implements OptionHandler {
        protected XMLDeclHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String s = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_XML_DECLARATION, s);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("xml-decl.description", null);
        }
    }

    protected class SystemIdHandler
    implements OptionHandler {
        protected SystemIdHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String s = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_SYSTEM_ID, s);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("system-id.description", null);
        }
    }

    protected class PublicIdHandler
    implements OptionHandler {
        protected PublicIdHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            String s = Main.this.arguments[Main.this.index++];
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_PUBLIC_ID, s);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("public-id.description", null);
        }
    }

    protected class NoFormatHandler
    implements OptionHandler {
        protected NoFormatHandler() {
        }

        @Override
        public void handleOption() {
            ++Main.this.index;
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_FORMAT, Boolean.FALSE);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("no-format.description", null);
        }
    }

    protected class NewlineHandler
    implements OptionHandler {
        protected final Map values = new HashMap(6);

        protected NewlineHandler() {
            this.values.put("cr", SVGTranscoder.VALUE_NEWLINE_CR);
            this.values.put("cr-lf", SVGTranscoder.VALUE_NEWLINE_CR_LF);
            this.values.put("lf", SVGTranscoder.VALUE_NEWLINE_LF);
        }

        @Override
        public void handleOption() {
            Object val;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((val = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_NEWLINE, val);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("newline.description", null);
        }
    }

    protected class DoctypeHandler
    implements OptionHandler {
        protected final Map values = new HashMap(6);

        protected DoctypeHandler() {
            this.values.put("remove", SVGTranscoder.VALUE_DOCTYPE_REMOVE);
            this.values.put("change", SVGTranscoder.VALUE_DOCTYPE_CHANGE);
        }

        @Override
        public void handleOption() {
            Object val;
            ++Main.this.index;
            if (Main.this.index >= Main.this.arguments.length) {
                throw new IllegalArgumentException();
            }
            if ((val = this.values.get(Main.this.arguments[Main.this.index++])) == null) {
                throw new IllegalArgumentException();
            }
            Main.this.transcoder.addTranscodingHint(SVGTranscoder.KEY_DOCTYPE, val);
        }

        @Override
        public String getDescription() {
            return localizableSupport.formatMessage("doctype.description", null);
        }
    }

    protected static interface OptionHandler {
        public void handleOption();

        public String getDescription();
    }
}

