/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.metrics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.OWLAxiomTypeFramePanel;
import org.protege.editor.owl.ui.metrics.MetricsTableModel;
import org.protege.editor.owl.ui.metrics.ReferencedAnnotationPropertyCount;
import org.semanticweb.owlapi.metrics.AxiomCount;
import org.semanticweb.owlapi.metrics.AxiomCountMetric;
import org.semanticweb.owlapi.metrics.AxiomTypeMetric;
import org.semanticweb.owlapi.metrics.DLExpressivity;
import org.semanticweb.owlapi.metrics.GCICount;
import org.semanticweb.owlapi.metrics.HiddenGCICount;
import org.semanticweb.owlapi.metrics.LogicalAxiomCount;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.metrics.OWLMetricManager;
import org.semanticweb.owlapi.metrics.ReferencedClassCount;
import org.semanticweb.owlapi.metrics.ReferencedDataPropertyCount;
import org.semanticweb.owlapi.metrics.ReferencedIndividualCount;
import org.semanticweb.owlapi.metrics.ReferencedObjectPropertyCount;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class MetricsPanel
extends JPanel {
    private final Map<String, OWLMetricManager> metricManagerMap = new LinkedHashMap<String, OWLMetricManager>();
    private final Map<OWLMetricManager, MetricsTableModel> tableModelMap = new HashMap<OWLMetricManager, MetricsTableModel>();
    private OWLEditorKit owlEditorKit;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private AxiomCountMetric lastMetric;

    public MetricsPanel(OWLEditorKit editorKit) {
        this.owlEditorKit = editorKit;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.initialiseOWLView();
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        JMenuItem showAxioms = new JMenuItem("Show axioms");
        this.popupMenu.add(showAxioms);
        showAxioms.addActionListener(e -> this.showAxiomTypeDialog());
    }

    private void showAxiomTypeDialog() {
        Set axioms = this.lastMetric.getAxioms();
        final OWLAxiomTypeFramePanel panel = new OWLAxiomTypeFramePanel(this.owlEditorKit);
        HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>(axioms);
        panel.setRoot(axs);
        panel.setPreferredSize(new Dimension(800, 300));
        JOptionPane op = new JOptionPane(panel, -1, 2);
        JDialog dlg = op.createDialog(this, this.lastMetric.getName());
        dlg.setResizable(true);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                panel.dispose();
            }
        });
        dlg.setModal(false);
        dlg.setVisible(true);
    }

    protected void initialiseOWLView() {
        this.createBasicMetrics();
        this.createClassAxiomMetrics();
        this.createObjectPropertyAxiomMetrics();
        this.createDataPropertyAxiomMetrics();
        this.createIndividualAxiomMetrics();
        this.createAnnotationAxiomMetrics();
        this.createUI();
        this.updateView(this.owlEditorKit.getModelManager().getActiveOntology());
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            for (OWLMetric m : man.getMetrics()) {
                m.setImportsClosureUsed(true);
                m.setOntology(this.owlEditorKit.getModelManager().getActiveOntology());
            }
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        Box box = new Box(1);
        box.setBackground(Color.WHITE);
        for (String metricsSet : this.metricManagerMap.keySet()) {
            MetricsTableModel tableModel = new MetricsTableModel(this.metricManagerMap.get(metricsSet));
            this.tableModelMap.put(this.metricManagerMap.get(metricsSet), tableModel);
            final JTable table = new JTable(tableModel);
            table.setGridColor(new Color(240, 240, 240));
            FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
            table.setRowHeight(fontMetrics.getLeading() * 2 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 4);
            table.setShowGrid(true);
            table.getColumnModel().getColumn(1).setMaxWidth(150);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.handleTablePopupRequest(table, e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.handleTablePopupRequest(table, e);
                    }
                }

                private void handleTablePopupRequest(JTable table2, MouseEvent e) {
                    int row = table2.rowAtPoint(e.getPoint());
                    int col = table2.columnAtPoint(e.getPoint());
                    if (row == -1 || col == -1) {
                        return;
                    }
                    MetricsTableModel model = (MetricsTableModel)table2.getModel();
                    for (OWLMetricManager man : MetricsPanel.this.tableModelMap.keySet()) {
                        if (!((MetricsTableModel)MetricsPanel.this.tableModelMap.get(man)).equals(model)) continue;
                        OWLMetric metric = (OWLMetric)man.getMetrics().get(row);
                        if (!(metric instanceof AxiomCountMetric)) break;
                        MetricsPanel.this.lastMetric = (AxiomCountMetric)metric;
                        MetricsPanel.this.popupMenu.show(table2, e.getX(), e.getY());
                        break;
                    }
                }
            });
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    label.setBorder(null);
                    Object metricValue = table.getModel().getValueAt(row, 1);
                    if (metricValue instanceof Integer) {
                        Integer number = (Integer)metricValue;
                        if (number > 0) {
                            if (column == 1) {
                                label.setFont(label.getFont().deriveFont(1));
                            } else {
                                label.setFont(label.getFont().deriveFont(0));
                            }
                            if (!isSelected) {
                                label.setForeground(Color.BLACK);
                            }
                        } else {
                            label.setFont(label.getFont().deriveFont(0));
                            label.setForeground(Color.LIGHT_GRAY);
                        }
                    } else if (!isSelected) {
                        label.setForeground(Color.BLACK);
                    }
                    return label;
                }
            };
            table.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            table.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
            final JPanel tablePanel = new JPanel(new BorderLayout(3, 3));
            tablePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showMenu(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showMenu(e);
                    }
                }

                private void showMenu(MouseEvent e) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new AbstractAction("Copy metrics to clipboard"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MetricsPanel.this.exportCSV();
                        }
                    });
                    menu.show(tablePanel, e.getX(), e.getY());
                }
            });
            JLabel titleLabel = new JLabel(metricsSet);
            titleLabel.setOpaque(false);
            tablePanel.add((Component)titleLabel, "North");
            tablePanel.setOpaque(false);
            JPanel tableHolder = new JPanel(new BorderLayout());
            tableHolder.setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 0));
            tableHolder.add(table);
            tableHolder.setOpaque(false);
            tablePanel.add(tableHolder);
            table.setShowVerticalLines(false);
            table.setShowHorizontalLines(true);
            table.setBackground(Color.WHITE);
            tablePanel.setBorder(BorderFactory.createEmptyBorder(2, 7, 14, 7));
            tablePanel.setOpaque(false);
            box.add(tablePanel);
            box.setOpaque(false);
        }
        JScrollPane sp = new JScrollPane(box);
        sp.getViewport().setOpaque(true);
        sp.getViewport().setBackground(Color.WHITE);
        JScrollBar verticalScrollBar = sp.getVerticalScrollBar();
        verticalScrollBar.setBlockIncrement(50);
        verticalScrollBar.setUnitIncrement(50);
        this.add(sp);
    }

    private OWLOntology getOntology() {
        return this.owlEditorKit.getModelManager().getActiveOntology();
    }

    private void createBasicMetrics() {
        ArrayList<Object> metrics = new ArrayList<Object>();
        metrics.add(new AxiomCount(this.getOntology()));
        metrics.add(new LogicalAxiomCount(this.getOntology()));
        metrics.add(new AxiomTypeMetric(this.getOntology(), AxiomType.DECLARATION));
        metrics.add(new ReferencedClassCount(this.getOntology()));
        metrics.add(new ReferencedObjectPropertyCount(this.getOntology()));
        metrics.add(new ReferencedDataPropertyCount(this.getOntology()));
        metrics.add(new ReferencedIndividualCount(this.getOntology()));
        metrics.add((Object)new ReferencedAnnotationPropertyCount(this.getOntology()));
        metrics.add(new DLExpressivity(this.getOntology()));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Metrics", metricManager);
    }

    private void createClassAxiomMetrics() {
        ArrayList<AxiomTypeMetricWrapper> metrics = new ArrayList<AxiomTypeMetricWrapper>();
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SUBCLASS_OF));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.EQUIVALENT_CLASSES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DISJOINT_CLASSES));
        metrics.add((AxiomTypeMetricWrapper)new GCICount(this.getOntology()));
        metrics.add((AxiomTypeMetricWrapper)new HiddenGCICount(this.getOntology()));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Class axioms", metricManager);
    }

    private void createObjectPropertyAxiomMetrics() {
        ArrayList<AxiomTypeMetricWrapper> metrics = new ArrayList<AxiomTypeMetricWrapper>();
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SUB_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.EQUIVALENT_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.INVERSE_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DISJOINT_OBJECT_PROPERTIES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.FUNCTIONAL_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.TRANSITIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SYMMETRIC_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.ASYMMETRIC_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.REFLEXIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.IRREFLEXIVE_OBJECT_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.OBJECT_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.OBJECT_PROPERTY_RANGE));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SUB_PROPERTY_CHAIN_OF));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Object property axioms", metricManager);
    }

    private void createDataPropertyAxiomMetrics() {
        ArrayList<AxiomTypeMetricWrapper> metrics = new ArrayList<AxiomTypeMetricWrapper>();
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SUB_DATA_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.EQUIVALENT_DATA_PROPERTIES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DISJOINT_DATA_PROPERTIES));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.FUNCTIONAL_DATA_PROPERTY));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DATA_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DATA_PROPERTY_RANGE));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Data property axioms", metricManager);
    }

    private void createIndividualAxiomMetrics() {
        ArrayList<AxiomTypeMetricWrapper> metrics = new ArrayList<AxiomTypeMetricWrapper>();
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.CLASS_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.OBJECT_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DATA_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.SAME_INDIVIDUAL));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.DIFFERENT_INDIVIDUALS));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Individual axioms", metricManager);
    }

    private void createAnnotationAxiomMetrics() {
        ArrayList<AxiomTypeMetricWrapper> metrics = new ArrayList<AxiomTypeMetricWrapper>();
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.ANNOTATION_ASSERTION));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.ANNOTATION_PROPERTY_DOMAIN));
        metrics.add(new AxiomTypeMetricWrapper(this.getOntology(), AxiomType.ANNOTATION_PROPERTY_RANGE));
        OWLMetricManager metricManager = new OWLMetricManager(metrics);
        this.metricManagerMap.put("Annotation axioms", metricManager);
    }

    public void updateView(OWLOntology activeOntology) {
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            man.setOntology(activeOntology);
        }
        this.repaint();
    }

    private OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    private void exportCSV() {
        StringBuilder sb = new StringBuilder();
        for (OWLMetricManager man : this.metricManagerMap.values()) {
            sb.append(man.toString());
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(sb.toString()), null);
    }

    private static class AxiomTypeMetricWrapper
    extends AxiomTypeMetric {
        private AxiomType<?> type;

        public AxiomTypeMetricWrapper(OWLOntology o, AxiomType<?> axiomType) {
            super(o, axiomType);
            this.type = axiomType;
        }

        @Nonnull
        public String getName() {
            return this.type.getName();
        }
    }
}

