/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function0;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SupertypeLoopChecker;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorNonRootImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.LazyScopeAdapter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.TypeIntersectionScope;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<SimpleType> defaultType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, final @NotNull Name name, @NotNull Variance variance, boolean isReified, int index, @NotNull SourceElement source, final @NotNull SupertypeLoopChecker supertypeLoopChecker) {
        super(containingDeclaration, annotations2, name, source);
        this.variance = variance;
        this.reified = isReified;
        this.index = index;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            public TypeConstructor invoke() {
                return new TypeParameterTypeConstructor(storageManager, supertypeLoopChecker);
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<SimpleType>(){

            public SimpleType invoke() {
                return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), AbstractTypeParameterDescriptor.this.getTypeConstructor(), Collections.emptyList(), false, new LazyScopeAdapter(storageManager.createLazyValue(new Function0<MemberScope>(){

                    public MemberScope invoke() {
                        return TypeIntersectionScope.create("Scope for type parameter " + name.asString(), AbstractTypeParameterDescriptor.this.getUpperBounds());
                    }
                })));
            }
        });
    }

    protected abstract void reportSupertypeLoopError(@NotNull KotlinType var1);

    @NotNull
    protected abstract List<KotlinType> resolveUpperBounds();

    @Override
    @NotNull
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isCapturedFromOuterDeclaration() {
        return false;
    }

    @Override
    @NotNull
    public List<KotlinType> getUpperBounds() {
        return ((TypeParameterTypeConstructor)this.getTypeConstructor()).getSupertypes();
    }

    @Override
    @NotNull
    public final TypeConstructor getTypeConstructor() {
        return (TypeConstructor)this.typeConstructor.invoke();
    }

    @Override
    @NotNull
    public SimpleType getDefaultType() {
        return (SimpleType)this.defaultType.invoke();
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getOriginal() {
        return (TypeParameterDescriptor)super.getOriginal();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitTypeParameterDescriptor(this, data2);
    }

    private class TypeParameterTypeConstructor
    extends AbstractTypeConstructor {
        private final SupertypeLoopChecker supertypeLoopChecker;

        public TypeParameterTypeConstructor(@NotNull StorageManager storageManager, SupertypeLoopChecker supertypeLoopChecker) {
            super(storageManager);
            this.supertypeLoopChecker = supertypeLoopChecker;
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            return AbstractTypeParameterDescriptor.this;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DescriptorUtilsKt.getBuiltIns(AbstractTypeParameterDescriptor.this);
        }

        public String toString() {
            return AbstractTypeParameterDescriptor.this.getName().toString();
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            return this.supertypeLoopChecker;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            AbstractTypeParameterDescriptor.this.reportSupertypeLoopError(type2);
        }

        @Override
        @Nullable
        protected KotlinType defaultSupertypeIfEmpty() {
            return ErrorUtils.createErrorType("Cyclic upper bounds");
        }
    }
}

