/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.CapturedTypeFromSubtyping;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.AbstractSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import org.jetbrains.kotlin.resolve.calls.model.DiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.InstantiationOfAbstractClass;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleTypeArgument;
import org.jetbrains.kotlin.resolve.calls.model.SmartCastDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import org.jetbrains.kotlin.resolve.calls.model.TypeArgument;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.resolve.calls.model.WrongCountOfTypeArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.ExpressionKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleTypeArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.TrackingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/DiagnosticReporterByTrackingStrategy;", "Lorg/jetbrains/kotlin/resolve/calls/model/DiagnosticReporter;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "psiKotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;)V", "call", "Lorg/jetbrains/kotlin/psi/Call;", "getCall", "()Lorg/jetbrains/kotlin/psi/Call;", "getConstantExpressionEvaluator", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "getContext", "()Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "getPsiKotlinCall", "()Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "trace", "Lorg/jetbrains/kotlin/resolve/calls/tower/TrackingBindingTrace;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "getTracingStrategy", "()Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "constraintError", "", "diagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "onCall", "onCallArgument", "callArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "onCallArgumentName", "onCallArgumentSpread", "onCallName", "onCallReceiver", "callReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "onExplicitReceiver", "onTypeArgument", "typeArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "onTypeArguments", "reportConstantTypeMismatch", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintError;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "reportSmartCast", "smartCastDiagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/SmartCastDiagnostic;", "reportUnstableSmartCast", "unstableSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/model/UnstableSmartCast;", "frontend"})
public final class DiagnosticReporterByTrackingStrategy
implements DiagnosticReporter {
    private final TrackingBindingTrace trace;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final BasicCallResolutionContext context;
    @NotNull
    private final PSIKotlinCall psiKotlinCall;

    private final TracingStrategy getTracingStrategy() {
        return this.psiKotlinCall.getTracingStrategy();
    }

    private final Call getCall() {
        return this.psiKotlinCall.getPsiCall();
    }

    @Override
    public void onExplicitReceiver(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
    }

    @Override
    public void onCall(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, VisibilityError.class)) {
            this.getTracingStrategy().invisibleMember(this.trace, ((VisibilityError)diagnostic).getInvisibleMember());
        } else if (Intrinsics.areEqual(clazz, NoValueForParameter.class)) {
            this.getTracingStrategy().noValueForParameter(this.trace, ((NoValueForParameter)diagnostic).getParameterDescriptor());
        } else if (Intrinsics.areEqual(clazz, InstantiationOfAbstractClass.class)) {
            this.getTracingStrategy().instantiationOfAbstractClass(this.trace);
        } else if (Intrinsics.areEqual(clazz, AbstractSuperCall.class)) {
            this.getTracingStrategy().abstractSuperCall(this.trace);
        }
    }

    @Override
    public void onTypeArguments(@NotNull KotlinCallDiagnostic diagnostic) {
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        KtElement psiCallElement = this.psiKotlinCall.getPsiCall().getCallElement();
        if (psiCallElement instanceof KtCallExpression) {
            KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)psiCallElement).getTypeArgumentList();
            ktElement = ktTypeArgumentList != null ? (KtElement)ktTypeArgumentList : (KtElement)((KtCallExpression)psiCallElement).getCalleeExpression();
            if (ktElement == null) {
                ktElement = psiCallElement;
            }
        } else {
            KtElement ktElement2 = psiCallElement;
            ktElement = ktElement2;
            Intrinsics.checkExpressionValueIsNotNull(ktElement2, "psiCallElement");
        }
        KtElement reportElement = ktElement;
        KotlinCallDiagnostic kotlinCallDiagnostic = diagnostic;
        if (kotlinCallDiagnostic instanceof WrongCountOfTypeArguments) {
            int expectedTypeArgumentsCount = ((WrongCountOfTypeArguments)diagnostic).getDescriptor().getTypeParameters().size();
            ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)reportElement), expectedTypeArgumentsCount, ((WrongCountOfTypeArguments)diagnostic).getDescriptor());
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "WRONG_NUMBER_OF_TYPE_ARG\u2026t, diagnostic.descriptor)");
            this.trace.report(parametrizedDiagnostic);
        }
    }

    @Override
    public void onCallName(@NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
    }

    @Override
    public void onTypeArgument(@NotNull TypeArgument typeArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(typeArgument, "typeArgument");
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
    }

    @Override
    public void onCallReceiver(@NotNull SimpleKotlinCallArgument callReceiver, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(callReceiver, "callReceiver");
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, UnsafeCallError.class)) {
            SimpleKotlinCallArgument simpleKotlinCallArgument = callReceiver;
            if (!(simpleKotlinCallArgument instanceof ReceiverExpressionKotlinCallArgument)) {
                simpleKotlinCallArgument = null;
            }
            ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument = (ReceiverExpressionKotlinCallArgument)simpleKotlinCallArgument;
            boolean implicitInvokeCheck = receiverExpressionKotlinCallArgument != null ? receiverExpressionKotlinCallArgument.isVariableReceiverForInvoke() : false;
            this.getTracingStrategy().unsafeCall(this.trace, callReceiver.getReceiver().getReceiverValue().getType(), implicitInvokeCheck);
        }
    }

    @Override
    public void onCallArgument(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(callArgument, "callArgument");
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, SmartCastDiagnostic.class)) {
            this.reportSmartCast((SmartCastDiagnostic)diagnostic);
        } else if (Intrinsics.areEqual(clazz, UnstableSmartCast.class)) {
            this.reportUnstableSmartCast((UnstableSmartCast)diagnostic);
        } else if (Intrinsics.areEqual(clazz, TooManyArguments.class)) {
            KtExpression psiExpression = NewCallArgumentsKt.getPsiExpression(callArgument);
            if (psiExpression != null) {
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.TOO_MANY_ARGUMENTS.on(psiExpression, ((TooManyArguments)diagnostic).getDescriptor());
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "TOO_MANY_ARGUMENTS.on(ps\u2026anyArguments).descriptor)");
                this.trace.report(parametrizedDiagnostic);
            }
            this.trace.markAsReported();
        } else if (Intrinsics.areEqual(clazz, VarargArgumentOutsideParentheses.class)) {
            KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression(callArgument);
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            SimpleDiagnostic<KtExpression> simpleDiagnostic = Errors.VARARG_OUTSIDE_PARENTHESES.on((KtExpression)((PsiElement)ktExpression));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, "VARARG_OUTSIDE_PARENTHES\u2026Argument.psiExpression!!)");
            this.trace.report(simpleDiagnostic);
        }
    }

    @Override
    public void onCallArgumentName(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(callArgument, "callArgument");
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Object object = NewCallArgumentsKt.getPsiCallArgument(callArgument).getValueArgument().getArgumentName();
        if (object == null || (object = object.getReferenceExpression()) == null) {
            String string = "Argument name should be not null for argument: " + callArgument;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object nameReference = object;
        Class<?> clazz = diagnostic.getClass();
        if (Intrinsics.areEqual(clazz, NamedArgumentReference.class)) {
            this.trace.record(BindingContext.REFERENCE_TARGET, nameReference, ((NamedArgumentReference)diagnostic).getParameterDescriptor());
            this.trace.markAsReported();
        } else if (Intrinsics.areEqual(clazz, NameForAmbiguousParameter.class)) {
            SimpleDiagnostic<KtReferenceExpression> simpleDiagnostic = Errors.NAME_FOR_AMBIGUOUS_PARAMETER.on((KtReferenceExpression)((PsiElement)nameReference));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, "NAME_FOR_AMBIGUOUS_PARAMETER.on(nameReference)");
            this.trace.report(simpleDiagnostic);
        } else if (Intrinsics.areEqual(clazz, NameNotFound.class)) {
            ParametrizedDiagnostic<KtReferenceExpression> parametrizedDiagnostic = Errors.NAMED_PARAMETER_NOT_FOUND.on((KtReferenceExpression)((PsiElement)nameReference), (KtReferenceExpression)nameReference);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "NAMED_PARAMETER_NOT_FOUN\u2026Reference, nameReference)");
            this.trace.report(parametrizedDiagnostic);
        } else if (Intrinsics.areEqual(clazz, NamedArgumentNotAllowed.class)) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.NAMED_ARGUMENTS_NOT_ALLOWED.on((PsiElement)nameReference, ((NamedArgumentNotAllowed)diagnostic).getDescriptor() instanceof FunctionInvokeDescriptor ? Errors.BadNamedArgumentsTarget.INVOKE_ON_FUNCTION_TYPE : Errors.BadNamedArgumentsTarget.NON_KOTLIN_FUNCTION);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "NAMED_ARGUMENTS_NOT_ALLO\u2026IN_FUNCTION\n            )");
            this.trace.report(parametrizedDiagnostic);
        } else if (Intrinsics.areEqual(clazz, ArgumentPassedTwice.class)) {
            SimpleDiagnostic<KtReferenceExpression> simpleDiagnostic = Errors.ARGUMENT_PASSED_TWICE.on((KtReferenceExpression)((PsiElement)nameReference));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, "ARGUMENT_PASSED_TWICE.on(nameReference)");
            this.trace.report(simpleDiagnostic);
        }
    }

    @Override
    public void onCallArgumentSpread(@NotNull KotlinCallArgument callArgument, @NotNull KotlinCallDiagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull(callArgument, "callArgument");
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
    }

    private final void reportSmartCast(SmartCastDiagnostic smartCastDiagnostic) {
        NewResolvedCallImpl resolvedCall2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3;
        ResolvedCall<? extends CallableDescriptor> resolvedCall4;
        Object object;
        SmartCastResult smartCastResult2;
        SmartCastResult smartCastResult3;
        ExpressionKotlinCallArgument expressionArgument = smartCastDiagnostic.getArgument();
        ExpressionKotlinCallArgument expressionKotlinCallArgument = expressionArgument;
        if (expressionKotlinCallArgument instanceof ExpressionKotlinCallArgumentImpl) {
            this.trace.markAsReported();
            BasicCallResolutionContext context = (BasicCallResolutionContext)this.context.replaceDataFlowInfo(((ExpressionKotlinCallArgumentImpl)expressionArgument).getDataFlowInfoBeforeThisArgument());
            KtExpression argumentExpression = KtPsiUtil.getLastElementDeparenthesized(((ExpressionKotlinCallArgumentImpl)expressionArgument).getValueArgument().getArgumentExpression(), context.statementFilter);
            ReceiverValue receiverValue = expressionArgument.getReceiver().getReceiverValue();
            BasicCallResolutionContext basicCallResolutionContext = context;
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context");
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverValue, basicCallResolutionContext);
            smartCastResult3 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue, smartCastDiagnostic.getSmartCastType(), argumentExpression, context, this.getCall(), true);
        } else if (expressionKotlinCallArgument instanceof ReceiverExpressionKotlinCallArgument) {
            this.trace.markAsReported();
            ReceiverValue receiverValue = expressionArgument.getReceiver().getReceiverValue();
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverValue, this.context);
            KotlinType kotlinType = smartCastDiagnostic.getSmartCastType();
            ReceiverValue receiverValue2 = receiverValue;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
            smartCastResult3 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue, kotlinType, expressionReceiver != null ? expressionReceiver.getExpression() : null, this.context, this.getCall(), true);
        } else {
            smartCastResult3 = smartCastResult2 = null;
        }
        if ((object = smartCastDiagnostic.getKotlinCall()) != null && (object = PSIKotlinCallsKt.getPsiKotlinCall((KotlinCall)object)) != null && (object = ((PSIKotlinCall)object).getPsiCall()) != null) {
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            resolvedCall4 = CallUtilKt.getResolvedCall((Call)object, bindingContext);
        } else {
            resolvedCall4 = resolvedCall3 = null;
        }
        if (!(resolvedCall4 instanceof NewResolvedCallImpl)) {
            resolvedCall3 = null;
        }
        if ((resolvedCall2 = (NewResolvedCallImpl)resolvedCall3) != null && smartCastResult2 != null) {
            if (Intrinsics.areEqual(resolvedCall2.getExtensionReceiver(), expressionArgument.getReceiver().getReceiverValue())) {
                resolvedCall2.updateExtensionReceiverWithSmartCastIfNeeded(smartCastResult2.getResultType());
            }
            if (Intrinsics.areEqual(resolvedCall2.getDispatchReceiver(), expressionArgument.getReceiver().getReceiverValue())) {
                resolvedCall2.setSmartCastDispatchReceiverType(smartCastResult2.getResultType());
            }
        }
    }

    private final void reportUnstableSmartCast(UnstableSmartCast unstableSmartCast) {
        this.reportSmartCast(new SmartCastDiagnostic(unstableSmartCast.getArgument(), unstableSmartCast.getTargetType(), null));
    }

    @Override
    public void constraintError(@NotNull KotlinCallDiagnostic diagnostic) {
        block12: {
            Class<?> clazz;
            block11: {
                ConstraintPosition constraintPosition;
                Object it;
                Object object;
                Object argument;
                Object object2;
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                clazz = diagnostic.getClass();
                if (!Intrinsics.areEqual(clazz, NewConstraintError.class)) break block11;
                NewConstraintError constraintError = (NewConstraintError)diagnostic;
                ConstraintPosition position = constraintError.getPosition().getFrom();
                ConstraintPosition constraintPosition2 = position;
                if (!(constraintPosition2 instanceof ArgumentConstraintPosition)) {
                    constraintPosition2 = null;
                }
                if ((object2 = (ArgumentConstraintPosition)constraintPosition2) == null || (object2 = ((ArgumentConstraintPosition)object2).getArgument()) == null) {
                    ConstraintPosition constraintPosition3 = position;
                    if (!(constraintPosition3 instanceof ReceiverConstraintPosition)) {
                        constraintPosition3 = null;
                    }
                    ReceiverConstraintPosition receiverConstraintPosition = (ReceiverConstraintPosition)constraintPosition3;
                    object2 = receiverConstraintPosition != null ? receiverConstraintPosition.getArgument() : null;
                }
                Object object3 = argument = object2;
                if (object3 != null) {
                    KtExpression deparenthesized;
                    it = object = object3;
                    KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression((KotlinCallArgument)it);
                    if (ktExpression == null) {
                        return;
                    }
                    KtExpression expression2 = ktExpression;
                    KtExpression ktExpression2 = deparenthesized = KtPsiUtil.safeDeparenthesize(expression2);
                    Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "deparenthesized");
                    if (this.reportConstantTypeMismatch(constraintError, ktExpression2)) {
                        return;
                    }
                    ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)deparenthesized), constraintError.getUpperType(), constraintError.getLowerType());
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "Errors.TYPE_MISMATCH.on(\u2026onstraintError.lowerType)");
                    this.trace.report(parametrizedDiagnostic);
                }
                if (!((constraintPosition = position) instanceof ExplicitTypeParameterConstraintPosition)) {
                    constraintPosition = null;
                }
                ExplicitTypeParameterConstraintPosition explicitTypeParameterConstraintPosition = (ExplicitTypeParameterConstraintPosition)constraintPosition;
                if (explicitTypeParameterConstraintPosition == null) break block12;
                it = object = explicitTypeParameterConstraintPosition;
                SimpleTypeArgument simpleTypeArgument = ((ExplicitTypeParameterConstraintPosition)it).getTypeArgument();
                if (simpleTypeArgument == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.SimpleTypeArgumentImpl");
                }
                KtTypeReference typeArgumentReference = ((SimpleTypeArgumentImpl)simpleTypeArgument).getTypeReference();
                ParametrizedDiagnostic<KtTypeReference> parametrizedDiagnostic = Errors.UPPER_BOUND_VIOLATED.on((KtTypeReference)((PsiElement)typeArgumentReference), constraintError.getUpperType(), constraintError.getLowerType());
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "UPPER_BOUND_VIOLATED.on(\u2026onstraintError.lowerType)");
                this.trace.report(parametrizedDiagnostic);
                break block12;
            }
            if (!Intrinsics.areEqual(clazz, CapturedTypeFromSubtyping.class)) break block12;
            CapturedTypeFromSubtyping capturedError = (CapturedTypeFromSubtyping)diagnostic;
            ConstraintPosition constraintPosition = capturedError.getPosition();
            if (!(constraintPosition instanceof ArgumentConstraintPosition)) {
                constraintPosition = null;
            }
            ArgumentConstraintPosition argumentConstraintPosition = (ArgumentConstraintPosition)constraintPosition;
            if (argumentConstraintPosition != null) {
                ArgumentConstraintPosition argumentConstraintPosition2;
                ArgumentConstraintPosition it = argumentConstraintPosition2 = argumentConstraintPosition;
                KtExpression ktExpression = NewCallArgumentsKt.getPsiExpression(it.getArgument());
                if (ktExpression == null) {
                    return;
                }
                KtExpression expression3 = ktExpression;
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.NEW_INFERENCE_ERROR.on(expression3, "Capture type from subtyping " + capturedError.getConstraintType() + " for variable " + capturedError.getTypeVariable());
                Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, "NEW_INFERENCE_ERROR.on(e\u2026uredError.typeVariable}\")");
                this.trace.report(parametrizedDiagnostic);
            }
        }
    }

    private final boolean reportConstantTypeMismatch(NewConstraintError constraintError, KtExpression expression2) {
        if (expression2 instanceof KtConstantExpression) {
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(this.context.scope.getOwnerDescriptor());
            BindingTrace bindingTrace = this.trace;
            KotlinType kotlinType = this.context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression2, bindingTrace, kotlinType);
            boolean hasConstantTypeError = new CompileTimeConstantChecker(this.context, builtIns, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression2, constraintError.getUpperType());
            if (hasConstantTypeError) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final ConstantExpressionEvaluator getConstantExpressionEvaluator() {
        return this.constantExpressionEvaluator;
    }

    @NotNull
    public final BasicCallResolutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final PSIKotlinCall getPsiKotlinCall() {
        return this.psiKotlinCall;
    }

    public DiagnosticReporterByTrackingStrategy(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BasicCallResolutionContext context, @NotNull PSIKotlinCall psiKotlinCall) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(psiKotlinCall, "psiKotlinCall");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.context = context;
        this.psiKotlinCall = psiKotlinCall;
        BindingTrace bindingTrace = this.context.trace;
        if (bindingTrace == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.TrackingBindingTrace");
        }
        this.trace = (TrackingBindingTrace)bindingTrace;
    }
}

