/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.events;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.events.AChart2DAction;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JColorChooser;

public final class Chart2DActionSetCustomGridColorSingleton
extends AChart2DAction {
    private static Map<String, Chart2DActionSetCustomGridColorSingleton> instances = new HashMap<String, Chart2DActionSetCustomGridColorSingleton>();
    private Color m_lastChosenColor;

    private static String key(Chart2D chart) {
        return chart.getClass().getName() + chart.hashCode();
    }

    public static Chart2DActionSetCustomGridColorSingleton getInstance(Chart2D chart, String colorName) {
        Chart2DActionSetCustomGridColorSingleton result = instances.get(Chart2DActionSetCustomGridColorSingleton.key(chart));
        if (result == null) {
            result = new Chart2DActionSetCustomGridColorSingleton(chart, colorName);
            instances.put(Chart2DActionSetCustomGridColorSingleton.key(chart), result);
        }
        return result;
    }

    private Chart2DActionSetCustomGridColorSingleton(Chart2D chart, String colorName) {
        super(chart, colorName);
        chart.addPropertyChangeListener("Chart2D.PROPERTY_GRID_COLOR", this);
    }

    public void actionPerformed(ActionEvent e) {
        Color chosen;
        this.m_lastChosenColor = chosen = JColorChooser.showDialog(this.m_chart, "choose color for " + this.m_chart.getName(), this.m_chart.getGridColor());
        this.m_chart.setGridColor(chosen);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("Chart2D.PROPERTY_GRID_COLOR")) {
            Color newColor = (Color)evt.getNewValue();
            if (newColor.equals(this.m_lastChosenColor)) {
                this.firePropertyChange("", new Boolean(false), new Boolean(true));
            } else {
                this.firePropertyChange("", new Boolean(true), new Boolean(false));
            }
        }
    }
}

