// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 **/
public interface LocatorRegistry extends com.zeroc.Ice.Object
{
    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     **/
    java.util.concurrent.CompletionStage<Void> setAdapterDirectProxyAsync(String id, com.zeroc.Ice.ObjectPrx proxy, com.zeroc.Ice.Current current)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException;

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     **/
    java.util.concurrent.CompletionStage<Void> setReplicatedAdapterDirectProxyAsync(String adapterId, String replicaGroupId, com.zeroc.Ice.ObjectPrx p, com.zeroc.Ice.Current current)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException,
               InvalidReplicaGroupIdException;

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws ServerNotFoundException Raised if the server cannot
     * be found.
     **/
    java.util.concurrent.CompletionStage<Void> setServerProcessProxyAsync(String id, ProcessPrx proxy, com.zeroc.Ice.Current current)
        throws ServerNotFoundException;

    static final String[] _iceIds =
    {
        "::Ice::LocatorRegistry",
        "::Ice::Object"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::Ice::LocatorRegistry";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setAdapterDirectProxy(LocatorRegistry obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        com.zeroc.Ice.ObjectPrx iceP_proxy;
        iceP_id = istr.readString();
        iceP_proxy = istr.readProxy();
        inS.endReadParams();
        return inS.setResultFuture(obj.setAdapterDirectProxyAsync(iceP_id, iceP_proxy, current));
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setReplicatedAdapterDirectProxy(LocatorRegistry obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_adapterId;
        String iceP_replicaGroupId;
        com.zeroc.Ice.ObjectPrx iceP_p;
        iceP_adapterId = istr.readString();
        iceP_replicaGroupId = istr.readString();
        iceP_p = istr.readProxy();
        inS.endReadParams();
        return inS.setResultFuture(obj.setReplicatedAdapterDirectProxyAsync(iceP_adapterId, iceP_replicaGroupId, iceP_p, current));
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_setServerProcessProxy(LocatorRegistry obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        ProcessPrx iceP_proxy;
        iceP_id = istr.readString();
        iceP_proxy = ProcessPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        return inS.setResultFuture(obj.setServerProcessProxyAsync(iceP_id, iceP_proxy, current));
    }

    final static String[] _iceOps =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "setAdapterDirectProxy",
        "setReplicatedAdapterDirectProxy",
        "setServerProcessProxy"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 1:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 4:
            {
                return _iceD_setAdapterDirectProxy(this, in, current);
            }
            case 5:
            {
                return _iceD_setReplicatedAdapterDirectProxy(this, in, current);
            }
            case 6:
            {
                return _iceD_setServerProcessProxy(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
