/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.ManifestParser;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;

public class RepoCommand
extends GitCommand<RevCommit> {
    private String manifestPath;
    private String baseUri;
    private URI targetUri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private boolean recordRemoteBranch = false;
    private boolean recordSubmoduleLabels = false;
    private boolean recordShallowSubmodules = false;
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private boolean ignoreRemoteFailures = false;
    private List<RepoProject> bareProjects;
    private Git git;
    private ProgressMonitor monitor;
    private static final String SLASH = "/";

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path2) {
        this.manifestPath = path2;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.baseUri = uri;
        return this;
    }

    public RepoCommand setTargetURI(String uri) {
        this.targetUri = URI.create(uri + SLASH);
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groupsParam = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setTargetBranch(String branch) {
        this.targetBranch = "refs/heads/" + branch;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean enable) {
        this.recordRemoteBranch = enable;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean enable) {
        this.recordSubmoduleLabels = enable;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean enable) {
        this.recordShallowSubmodules = enable;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean ignore) {
        this.ignoreRemoteFailures = ignore;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader reader2) {
        this.includedReader = reader2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevCommit call() throws GitAPIException {
        try {
            this.checkCallable();
            if (this.baseUri == null) {
                this.baseUri = "";
            }
            if (this.inputStream == null) {
                if (this.manifestPath == null || this.manifestPath.length() == 0) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
                try {
                    this.inputStream = new FileInputStream(this.manifestPath);
                }
                catch (IOException e2) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
            }
            if (this.repo.isBare()) {
                this.bareProjects = new ArrayList<RepoProject>();
                if (this.author == null) {
                    this.author = new PersonIdent(this.repo);
                }
                if (this.callback == null) {
                    this.callback = new DefaultRemoteReader();
                }
            } else {
                this.git = new Git(this.repo);
            }
            ManifestParser parser = new ManifestParser(this.includedReader, this.manifestPath, this.branch, this.baseUri, this.groupsParam, this.repo);
            try {
                parser.read(this.inputStream);
                for (RepoProject proj : parser.getFilteredProjects()) {
                    this.addSubmodule(proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getLinkFiles(), proj.getGroups(), proj.getRecommendShallow());
                }
            }
            catch (IOException | GitAPIException e3) {
                throw new ManifestErrorException(e3);
            }
        }
        finally {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException parser) {}
        }
        if (this.repo.isBare()) {
            RevCommit revCommit;
            DirCache index2 = DirCache.newInCore();
            DirCacheBuilder builder = index2.builder();
            ObjectInserter inserter = this.repo.newObjectInserter();
            RevWalk rw = new RevWalk(this.repo);
            Throwable throwable = null;
            try {
                Config cfg = new Config();
                StringBuilder attributes = new StringBuilder();
                for (RepoProject proj : this.bareProjects) {
                    ObjectId objectId;
                    String path2 = proj.getPath();
                    String nameUri = proj.getName();
                    if (ObjectId.isId(proj.getRevision()) && !this.ignoreRemoteFailures) {
                        objectId = ObjectId.fromString(proj.getRevision());
                    } else {
                        objectId = this.callback.sha1(nameUri, proj.getRevision());
                        if (objectId == null) {
                            if (this.ignoreRemoteFailures) continue;
                            throw new RemoteUnavailableException(nameUri);
                        }
                        if (this.recordRemoteBranch) {
                            cfg.setString("submodule", path2, "branch", proj.getRevision());
                        }
                        if (this.recordShallowSubmodules && proj.getRecommendShallow() != null) {
                            cfg.setBoolean("submodule", path2, "shallow", true);
                        }
                    }
                    if (this.recordSubmoduleLabels) {
                        StringBuilder rec = new StringBuilder();
                        rec.append(SLASH);
                        rec.append(path2);
                        for (String string2 : proj.getGroups()) {
                            rec.append(" ");
                            rec.append(string2);
                        }
                        rec.append("\n");
                        attributes.append(rec.toString());
                    }
                    URI submodUrl = URI.create(nameUri);
                    if (this.targetUri != null) {
                        submodUrl = RepoCommand.relativize(this.targetUri, submodUrl);
                    }
                    cfg.setString("submodule", path2, "path", path2);
                    cfg.setString("submodule", path2, "url", submodUrl.toString());
                    DirCacheEntry dcEntry = new DirCacheEntry(path2);
                    dcEntry.setObjectId(objectId);
                    dcEntry.setFileMode(FileMode.GITLINK);
                    builder.add(dcEntry);
                    for (RepoProject.CopyFile copyfile : proj.getCopyFiles()) {
                        byte[] src = this.callback.readFile(nameUri, proj.getRevision(), copyfile.src);
                        objectId = inserter.insert(3, src);
                        dcEntry = new DirCacheEntry(copyfile.dest);
                        dcEntry.setObjectId(objectId);
                        dcEntry.setFileMode(FileMode.REGULAR_FILE);
                        builder.add(dcEntry);
                    }
                    for (RepoProject.LinkFile linkfile : proj.getLinkFiles()) {
                        String link = linkfile.dest.contains(SLASH) ? FileUtils.relativizeGitPath(linkfile.dest.substring(0, linkfile.dest.lastIndexOf(47)), proj.getPath() + SLASH + linkfile.src) : proj.getPath() + SLASH + linkfile.src;
                        objectId = inserter.insert(3, link.getBytes("UTF-8"));
                        dcEntry = new DirCacheEntry(linkfile.dest);
                        dcEntry.setObjectId(objectId);
                        dcEntry.setFileMode(FileMode.SYMLINK);
                        builder.add(dcEntry);
                    }
                }
                String content = cfg.toText();
                DirCacheEntry dcEntry = new DirCacheEntry(".gitmodules");
                ObjectId objectId = inserter.insert(3, content.getBytes("UTF-8"));
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                builder.add(dcEntry);
                if (this.recordSubmoduleLabels) {
                    DirCacheEntry dcEntryAttr = new DirCacheEntry(".gitattributes");
                    ObjectId attrId = inserter.insert(3, attributes.toString().getBytes("UTF-8"));
                    dcEntryAttr.setObjectId(attrId);
                    dcEntryAttr.setFileMode(FileMode.REGULAR_FILE);
                    builder.add(dcEntryAttr);
                }
                builder.finish();
                ObjectId treeId = index2.writeTree(inserter);
                ObjectId headId = this.repo.resolve(this.targetBranch + "^{commit}");
                CommitBuilder commit = new CommitBuilder();
                commit.setTreeId(treeId);
                if (headId != null) {
                    commit.setParentIds(headId);
                }
                commit.setAuthor(this.author);
                commit.setCommitter(this.author);
                commit.setMessage(RepoText.get().repoCommitMessage);
                ObjectId commitId = inserter.insert(commit);
                inserter.flush();
                RefUpdate refUpdate = this.repo.updateRef(this.targetBranch);
                refUpdate.setNewObjectId(commitId);
                refUpdate.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
                RefUpdate.Result rc = refUpdate.update(rw);
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        break;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, this.targetBranch), refUpdate.getRef(), rc);
                    }
                    default: {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, commitId.name(), rc}));
                    }
                }
                revCommit = rw.parseCommit(commitId);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        RepoCommand.$closeResource(throwable, rw);
                        throw throwable3;
                    }
                }
                catch (IOException e4) {
                    throw new ManifestErrorException(e4);
                }
            }
            RepoCommand.$closeResource(throwable, rw);
            return revCommit;
        }
        return this.git.commit().setMessage(RepoText.get().repoCommitMessage).call();
    }

    private void addSubmodule(String url, String path2, String revision, List<RepoProject.CopyFile> copyfiles, List<RepoProject.LinkFile> linkfiles, Set<String> groups, String recommendShallow) throws GitAPIException, IOException {
        if (this.repo.isBare()) {
            RepoProject proj = new RepoProject(url, path2, revision, null, groups, recommendShallow);
            proj.addCopyFiles(copyfiles);
            proj.addLinkFiles(linkfiles);
            this.bareProjects.add(proj);
        } else {
            if (!linkfiles.isEmpty()) {
                throw new UnsupportedOperationException(JGitText.get().nonBareLinkFilesNotSupported);
            }
            SubmoduleAddCommand add = this.git.submoduleAdd().setPath(path2).setURI(url);
            if (this.monitor != null) {
                add.setProgressMonitor(this.monitor);
            }
            Repository subRepo = add.call();
            if (revision != null) {
                try (Git sub = new Git(subRepo);){
                    sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
                }
                subRepo.close();
                this.git.add().addFilepattern(path2).call();
            }
            for (RepoProject.CopyFile copyfile : copyfiles) {
                copyfile.copy();
                this.git.add().addFilepattern(copyfile.dest).call();
            }
        }
    }

    static URI relativize(URI current, URI target) {
        int i;
        if (!target.toString().equals(target.getPath())) {
            return target;
        }
        if (!current.toString().equals(current.getPath())) {
            return target;
        }
        String cur = current.normalize().getPath();
        String dest = target.normalize().getPath();
        if (cur.startsWith(SLASH) != dest.startsWith(SLASH)) {
            return target;
        }
        while (cur.startsWith(SLASH)) {
            cur = cur.substring(1);
        }
        while (dest.startsWith(SLASH)) {
            dest = dest.substring(1);
        }
        if (cur.indexOf(47) == -1 || dest.indexOf(47) == -1) {
            String prefix = "prefix/";
            cur = prefix + cur;
            dest = prefix + dest;
        }
        if (!cur.endsWith(SLASH)) {
            int lastSlash = cur.lastIndexOf(47);
            cur = cur.substring(0, lastSlash);
        }
        String destFile = "";
        if (!dest.endsWith(SLASH)) {
            int lastSlash = dest.lastIndexOf(47);
            destFile = dest.substring(lastSlash + 1, dest.length());
            dest = dest.substring(0, dest.lastIndexOf(47));
        }
        String[] cs = cur.split(SLASH);
        String[] ds = dest.split(SLASH);
        for (int common = 0; common < cs.length && common < ds.length && cs[common].equals(ds[common]); ++common) {
        }
        StringJoiner j = new StringJoiner(SLASH);
        for (i = common; i < cs.length; ++i) {
            j.add("..");
        }
        for (i = common; i < ds.length; ++i) {
            j.add(ds[i]);
        }
        j.add(destFile);
        return URI.create(j.toString());
    }

    private static String findRef(String ref2, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref2) && (r = repo.exactRef("refs/remotes/origin/" + ref2)) != null) {
            return r.getName();
        }
        return ref2;
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        @Override
        public ObjectId sha1(String uri, String ref2) throws GitAPIException {
            Map<String, Ref> map2 = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map2, ref2);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * Loose catch block
         */
        @Override
        public byte[] readFile(String uri, String ref2, String path2) throws GitAPIException, IOException {
            File dir2 = FileUtils.createTempDir("jgit_", ".git", null);
            try {
                try (Git git = Git.cloneRepository().setBare(true).setDirectory(dir2).setURI(uri).call();){
                    byte[] byArray = this.readFileFromRepo(git.getRepository(), ref2, path2);
                    return byArray;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.delete(dir2, 1);
            }
        }

        protected byte[] readFileFromRepo(Repository repo, String ref2, String path2) throws GitAPIException, IOException {
            try (ObjectReader reader2 = repo.newObjectReader();){
                ObjectId oid = repo.resolve(ref2 + ":" + path2);
                byte[] byArray = reader2.open(oid).getBytes(Integer.MAX_VALUE);
                return byArray;
            }
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    public static interface RemoteReader {
        @Nullable
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        public byte[] readFile(String var1, String var2, String var3) throws GitAPIException, IOException;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }
}

