/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapWalker;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.SystemReader;

class PackWriterBitmapPreparer {
    private static final int DAY_IN_SECONDS = 86400;
    private static final Comparator<BitmapBuilderEntry> ORDER_BY_CARDINALITY = new Comparator<BitmapBuilderEntry>(){

        @Override
        public int compare(BitmapBuilderEntry a, BitmapBuilderEntry b) {
            return Integer.signum(a.getBuilder().cardinality() - b.getBuilder().cardinality());
        }
    };
    private final ObjectReader reader;
    private final ProgressMonitor pm;
    private final Set<? extends ObjectId> want;
    private final PackBitmapIndexBuilder writeBitmaps;
    private final BitmapIndexImpl commitBitmapIndex;
    private final PackBitmapIndexRemapper bitmapRemapper;
    private final BitmapIndexImpl bitmapIndex;
    private final int contiguousCommitCount;
    private final int recentCommitCount;
    private final int recentCommitSpan;
    private final int distantCommitSpan;
    private final int excessiveBranchCount;
    private final long inactiveBranchTimestamp;

    PackWriterBitmapPreparer(ObjectReader reader2, PackBitmapIndexBuilder writeBitmaps, ProgressMonitor pm, Set<? extends ObjectId> want, PackConfig config) throws IOException {
        this.reader = reader2;
        this.writeBitmaps = writeBitmaps;
        this.pm = pm;
        this.want = want;
        this.commitBitmapIndex = new BitmapIndexImpl(writeBitmaps);
        this.bitmapRemapper = PackBitmapIndexRemapper.newPackBitmapIndex(reader2.getBitmapIndex(), writeBitmaps);
        this.bitmapIndex = new BitmapIndexImpl(this.bitmapRemapper);
        this.contiguousCommitCount = config.getBitmapContiguousCommitCount();
        this.recentCommitCount = config.getBitmapRecentCommitCount();
        this.recentCommitSpan = config.getBitmapRecentCommitSpan();
        this.distantCommitSpan = config.getBitmapDistantCommitSpan();
        this.excessiveBranchCount = config.getBitmapExcessiveBranchCount();
        long now = SystemReader.getInstance().getCurrentTime();
        long ageInSeconds = config.getBitmapInactiveBranchAgeInDays() * 86400;
        this.inactiveBranchTimestamp = now / 1000L - ageInSeconds;
    }

    Collection<BitmapCommit> selectCommits(int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        this.pm.beginTask(JGitText.get().selectingCommits, 0);
        RevWalk rw = new RevWalk(this.reader);
        rw.setRetainBody(false);
        CommitSelectionHelper selectionHelper = this.setupTipCommitBitmaps(rw, expectedCommitCount, excludeFromBitmapSelection);
        this.pm.endTask();
        int totCommits = selectionHelper.getCommitCount();
        BlockList<BitmapCommit> selections = new BlockList<BitmapCommit>(totCommits / this.recentCommitSpan + 1);
        for (BitmapCommit bitmapCommit : selectionHelper.reusedCommits) {
            selections.add(bitmapCommit);
        }
        if (totCommits == 0) {
            for (AnyObjectId anyObjectId : selectionHelper.peeledWants) {
                selections.add(new BitmapCommit(anyObjectId, false, 0));
            }
            return selections;
        }
        this.pm.beginTask(JGitText.get().selectingCommits, totCommits);
        int totalWants = selectionHelper.peeledWants.size();
        for (BitmapBuilderEntry bitmapBuilderEntry : selectionHelper.tipCommitBitmaps) {
            BitmapIndex.BitmapBuilder bitmap = bitmapBuilderEntry.getBuilder();
            int cardinality = bitmap.cardinality();
            ArrayList chains = new ArrayList();
            boolean isActiveBranch = true;
            if (totalWants > this.excessiveBranchCount && !this.isRecentCommit(bitmapBuilderEntry.getCommit())) {
                isActiveBranch = false;
            }
            int index2 = -1;
            int nextIn = this.nextSpan(cardinality);
            int nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
            for (RevCommit revCommit : selectionHelper) {
                int distanceFromTip = cardinality - index2 - 1;
                if (distanceFromTip == 0) break;
                if (!bitmap.contains(revCommit)) continue;
                ++index2;
                --nextIn;
                this.pm.update(1);
                if (selectionHelper.peeledWants.remove(revCommit)) {
                    if (nextIn > 0) {
                        nextFlg = 0;
                    }
                } else {
                    boolean mustPick;
                    boolean stillInSpan = nextIn >= 0;
                    boolean isMergeCommit = revCommit.getParentCount() > 1;
                    boolean bl = mustPick = nextIn <= -this.recentCommitSpan || isActiveBranch && distanceFromTip <= this.contiguousCommitCount || distanceFromTip == 1;
                    if (!mustPick && (stillInSpan || !isMergeCommit)) continue;
                }
                int flags = nextFlg;
                nextIn = this.nextSpan(distanceFromTip);
                nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
                BitmapIndexImpl.CompressedBitmapBuilder fullBitmap = this.commitBitmapIndex.newBitmapBuilder();
                rw.reset();
                rw.markStart(revCommit);
                rw.setRevFilter(new PackWriterBitmapWalker.AddUnseenToBitmapFilter(selectionHelper.reusedCommitsBitmap, fullBitmap));
                while (rw.next() != null) {
                }
                List<BitmapCommit> longestAncestorChain = null;
                for (List list : chains) {
                    BitmapCommit mostRecentCommit = (BitmapCommit)list.get(list.size() - 1);
                    if (!fullBitmap.contains(mostRecentCommit) || longestAncestorChain != null && longestAncestorChain.size() >= list.size()) continue;
                    longestAncestorChain = list;
                }
                if (longestAncestorChain == null) {
                    longestAncestorChain = new ArrayList<BitmapCommit>();
                    chains.add(longestAncestorChain);
                }
                longestAncestorChain.add(new BitmapCommit(revCommit, !longestAncestorChain.isEmpty(), flags));
                this.writeBitmaps.addBitmap((AnyObjectId)revCommit, fullBitmap, 0);
            }
            for (List list : chains) {
                selections.addAll(list);
            }
        }
        this.writeBitmaps.clearBitmaps();
        for (AnyObjectId anyObjectId : selectionHelper.peeledWants) {
            selections.add(new BitmapCommit(anyObjectId, false, 0));
        }
        this.pm.endTask();
        return selections;
    }

    private boolean isRecentCommit(RevCommit revCommit) {
        return (long)revCommit.getCommitTime() > this.inactiveBranchTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    private CommitSelectionHelper setupTipCommitBitmaps(RevWalk rw, int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        void var9_13;
        RevCommit rc;
        BitmapIndexImpl.CompressedBitmapBuilder reuse = this.commitBitmapIndex.newBitmapBuilder();
        ArrayList<BitmapCommit> reuseCommits = new ArrayList<BitmapCommit>();
        for (PackBitmapIndexRemapper.Entry entry : this.bitmapRemapper) {
            Object ro;
            if ((entry.getFlags() & 1) != 1 || !((ro = rw.peel(rw.parseAny(entry))) instanceof RevCommit)) continue;
            RevCommit revCommit = (RevCommit)ro;
            reuseCommits.add(new BitmapCommit(revCommit, false, entry.getFlags()));
            if (reuse.contains(revCommit)) continue;
            EWAHCompressedBitmap bitmap = this.bitmapRemapper.ofObjectType(this.bitmapRemapper.getBitmap(revCommit), 1);
            reuse.or(new BitmapIndexImpl.CompressedBitmap(bitmap, this.commitBitmapIndex));
        }
        ArrayList<BitmapBuilderEntry> tipCommitBitmaps = new ArrayList<BitmapBuilderEntry>(this.want.size());
        HashSet<RevCommit> peeledWant = new HashSet<RevCommit>(this.want.size());
        for (AnyObjectId anyObjectId : this.want) {
            RevObject ro = rw.peel(rw.parseAny(anyObjectId));
            if (!(ro instanceof RevCommit) || reuse.contains(ro) || excludeFromBitmapSelection.contains(ro)) continue;
            RevCommit rc3 = (RevCommit)ro;
            peeledWant.add(rc3);
            rw.markStart(rc3);
            BitmapIndexImpl.CompressedBitmapBuilder bitmap = this.commitBitmapIndex.newBitmapBuilder();
            bitmap.addObject(rc3, 1);
            tipCommitBitmaps.add(new BitmapBuilderEntry(rc3, bitmap));
        }
        rw.setRevFilter(new NotInBitmapFilter(reuse));
        RevCommit[] commits = new RevCommit[expectedCommitCount];
        int n = commits.length;
        while ((rc = rw.next()) != null && var9_13 > 0) {
            commits[--var9_13] = rc;
            for (BitmapBuilderEntry entry : tipCommitBitmaps) {
                BitmapIndex.BitmapBuilder bitmap = entry.getBuilder();
                if (!bitmap.contains(rc)) continue;
                for (RevCommit c : rc.getParents()) {
                    if (reuse.contains(c)) continue;
                    bitmap.addObject(c, 1);
                }
            }
            this.pm.update(1);
        }
        ArrayList<BitmapBuilderEntry> orderedTipCommitBitmaps = new ArrayList<BitmapBuilderEntry>(tipCommitBitmaps.size());
        while (!tipCommitBitmaps.isEmpty()) {
            BitmapBuilderEntry largest = Collections.max(tipCommitBitmaps, ORDER_BY_CARDINALITY);
            tipCommitBitmaps.remove(largest);
            orderedTipCommitBitmaps.add(largest);
            for (int i = tipCommitBitmaps.size() - 1; i >= 0; --i) {
                ((BitmapBuilderEntry)tipCommitBitmaps.get(i)).getBuilder().andNot(largest.getBuilder());
            }
        }
        return new CommitSelectionHelper(peeledWant, commits, (int)var9_13, orderedTipCommitBitmaps, reuse, reuseCommits);
    }

    int nextSpan(int distanceFromTip) {
        if (distanceFromTip < 0) {
            throw new IllegalArgumentException();
        }
        if (distanceFromTip <= this.recentCommitCount) {
            return this.recentCommitSpan;
        }
        int next2 = Math.min(distanceFromTip - this.recentCommitCount, this.distantCommitSpan);
        return Math.max(next2, this.recentCommitSpan);
    }

    PackWriterBitmapWalker newBitmapWalker() {
        return new PackWriterBitmapWalker(new ObjectWalk(this.reader), this.bitmapIndex, null);
    }

    private static final class BitmapBuilderEntry {
        private final RevCommit commit;
        private final BitmapIndex.BitmapBuilder builder;

        BitmapBuilderEntry(RevCommit commit, BitmapIndex.BitmapBuilder builder) {
            this.commit = commit;
            this.builder = builder;
        }

        RevCommit getCommit() {
            return this.commit;
        }

        BitmapIndex.BitmapBuilder getBuilder() {
            return this.builder;
        }
    }

    static final class BitmapCommit
    extends ObjectId {
        private final boolean reuseWalker;
        private final int flags;

        BitmapCommit(AnyObjectId objectId, boolean reuseWalker, int flags) {
            super(objectId);
            this.reuseWalker = reuseWalker;
            this.flags = flags;
        }

        boolean isReuseWalker() {
            return this.reuseWalker;
        }

        int getFlags() {
            return this.flags;
        }
    }

    private static final class CommitSelectionHelper
    implements Iterable<RevCommit> {
        final Set<? extends ObjectId> peeledWants;
        final List<BitmapBuilderEntry> tipCommitBitmaps;
        final BitmapIndex.BitmapBuilder reusedCommitsBitmap;
        final Iterable<BitmapCommit> reusedCommits;
        final RevCommit[] commitsByOldest;
        final int commitStartPos;

        CommitSelectionHelper(Set<? extends ObjectId> peeledWant, RevCommit[] commitsByOldest, int commitStartPos, List<BitmapBuilderEntry> bitmapEntries, BitmapIndex.BitmapBuilder reusedCommitsBitmap, Iterable<BitmapCommit> reuse) {
            this.peeledWants = peeledWant;
            this.commitsByOldest = commitsByOldest;
            this.commitStartPos = commitStartPos;
            this.tipCommitBitmaps = bitmapEntries;
            this.reusedCommitsBitmap = reusedCommitsBitmap;
            this.reusedCommits = reuse;
        }

        @Override
        public Iterator<RevCommit> iterator() {
            return new Iterator<RevCommit>(){
                int pos;
                {
                    this.pos = commitStartPos;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < commitsByOldest.length;
                }

                @Override
                public RevCommit next() {
                    return commitsByOldest[this.pos++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        int getCommitCount() {
            return this.commitsByOldest.length - this.commitStartPos;
        }
    }

    private static class NotInBitmapFilter
    extends RevFilter {
        private final BitmapIndex.BitmapBuilder bitmap;

        NotInBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public final boolean include(RevWalk rw, RevCommit c) {
            if (!this.bitmap.contains(c)) {
                return true;
            }
            for (RevCommit p : c.getParents()) {
                p.add(RevFlag.SEEN);
            }
            return false;
        }

        @Override
        public final NotInBitmapFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }
}

