/*
 * Decompiled with CFR 0.152.
 */
package plugins.svg;

import freemind.controller.Controller;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import java.awt.Frame;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugins.svg.ExportPdfDialog;
import plugins.svg.ExportPdfPapers;
import plugins.svg.ExportVectorGraphic;

public class ExportPdf
extends ExportVectorGraphic {
    ExportPdfPapers papers = new ExportPdfPapers();

    public void startupMapHook() {
        super.startupMapHook();
        boolean nodeExport = Tools.safeEquals((String)"node", (String)this.getResourceString("export_type"));
        HashMap transcodingHints = null;
        List selecteds = this.getController().getSelecteds();
        Vector<File> documentsToOpen = new Vector<File>();
        while (!selecteds.isEmpty()) {
            File chosenFile;
            MindMapNode selectedNode = (MindMapNode)selecteds.remove(0);
            String nameExtension = null;
            if (nodeExport) {
                nameExtension = " " + selectedNode.getShortText(this.getController());
            }
            if ((chosenFile = this.chooseFile("pdf", this.getResourceString("export_pdf_text"), nameExtension)) == null) {
                return;
            }
            if (transcodingHints == null) {
                transcodingHints = this.choosePaper();
            }
            if (transcodingHints == null) {
                return;
            }
            this.getController().getFrame().setWaitingCursor(true);
            try {
                this.exportAsPdf(nodeExport, selectedNode, chosenFile, transcodingHints);
                documentsToOpen.add(chosenFile);
            }
            catch (Exception e) {
                Resources.getInstance().logException((Throwable)e);
                JOptionPane.showMessageDialog(this.getController().getFrame().getContentPane(), e.getLocalizedMessage(), null, 0);
            }
            this.getController().getFrame().setWaitingCursor(false);
            if (nodeExport) continue;
            selecteds.clear();
        }
        try {
            for (File fileToOpen : documentsToOpen) {
                this.getController().getFrame().openDocument(Tools.fileToUrl((File)fileToOpen));
            }
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
        }
    }

    public HashMap choosePaper() {
        HashMap<TranscodingHints.Key, Float> retValue = new HashMap<TranscodingHints.Key, Float>();
        String[] paperNames = this.papers.getPaperNames();
        Controller controller = this.getController().getController();
        ExportPdfDialog dialog = new ExportPdfDialog((Frame)this.getController().getFrame().getJFrame(), paperNames, controller);
        dialog.setVisible(true);
        if (!dialog.getResult()) {
            return null;
        }
        int orientation = dialog.getOrientation();
        String format = dialog.getFormat();
        this.logger.info("Paper format=" + format);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(orientation);
        Paper paper = this.papers.determinePaper(format);
        if (paper != null) {
            pageFormat.setPaper(paper);
            if (pageFormat.getOrientation() == 1) {
                this.logger.info("Orientation: Portrait");
                retValue.put(PDFTranscoder.KEY_HEIGHT, new Float(pageFormat.getPaper().getHeight()));
                retValue.put(PDFTranscoder.KEY_WIDTH, new Float(pageFormat.getPaper().getWidth()));
            } else {
                this.logger.info("Orientation: Landscape");
                retValue.put(PDFTranscoder.KEY_HEIGHT, new Float(pageFormat.getPaper().getWidth()));
                retValue.put(PDFTranscoder.KEY_WIDTH, new Float(pageFormat.getPaper().getHeight()));
            }
        } else {
            this.logger.severe("Paper == null");
        }
        return retValue;
    }

    public boolean exportAsPdf(boolean nodeExport, MindMapNode selectedNode, File chosenFile) throws Exception {
        return this.exportAsPdf(nodeExport, selectedNode, chosenFile, null);
    }

    public boolean exportAsPdf(boolean nodeExport, MindMapNode selectedNode, File chosenFile, HashMap pTranscoderHints) throws Exception {
        MapView view = this.getController().getView();
        if (view == null) {
            return false;
        }
        SVGGraphics2D g2d = nodeExport ? this.fillSVGGraphics2D(view, selectedNode) : this.fillSVGGraphics2D(view);
        PDFTranscoder pdfTranscoder = new PDFTranscoder();
        pdfTranscoder.addTranscodingHint(PDFTranscoder.KEY_MAX_HEIGHT, (Object)new Float(19200.0f));
        pdfTranscoder.addTranscodingHint(PDFTranscoder.KEY_MAX_WIDTH, (Object)new Float(19200.0f));
        if (pTranscoderHints != null) {
            for (TranscodingHints.Key key : pTranscoderHints.keySet()) {
                pdfTranscoder.addTranscodingHint(key, pTranscoderHints.get(key));
            }
        }
        Document doc = g2d.getDOMFactory();
        Element rootE = doc.getDocumentElement();
        g2d.getRoot(rootE);
        TranscoderInput input = new TranscoderInput(doc);
        FileOutputStream ostream = new FileOutputStream(chosenFile);
        BufferedOutputStream bufStream = new BufferedOutputStream(ostream);
        TranscoderOutput output = new TranscoderOutput((OutputStream)bufStream);
        pdfTranscoder.transcode(input, output);
        ostream.flush();
        ostream.close();
        return true;
    }
}

