/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.tagging.ac;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;

public class AutoCompletionSet
extends TreeSet<AutoCompletionItem> {
    private final Set<String> values = new TreeSet<String>();

    @Override
    public boolean add(AutoCompletionItem e) {
        String value = e.getValue();
        if (this.contains(value)) {
            Optional<AutoCompletionItem> result = this.stream().filter(i -> i.getValue().equals(e.getValue())).findFirst();
            if (result.isPresent()) {
                AutoCompletionItem item = result.get();
                AutoCompletionPriority newPriority = item.getPriority().mergeWith(e.getPriority());
                if (!item.getPriority().equals(newPriority)) {
                    super.remove(item);
                    item.setPriority(newPriority);
                    return super.add(item);
                }
                return false;
            }
            throw new IllegalStateException(value);
        }
        this.values.add(value);
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof AutoCompletionItem) {
            this.values.remove(((AutoCompletionItem)o).getValue());
        }
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.values.clear();
        super.clear();
    }

    public boolean addAll(Collection<String> values, AutoCompletionPriority priority) {
        return this.addAll(values.stream().filter(Objects::nonNull).map(v -> new AutoCompletionItem((String)v, priority)).collect(Collectors.toList()));
    }

    public boolean addUserInput(Collection<String> values) {
        int i = 0;
        boolean modified = false;
        for (String value : values) {
            if (value == null || !this.add(new AutoCompletionItem(value, new AutoCompletionPriority(false, false, false, i++)))) continue;
            modified = true;
        }
        return modified;
    }

    public boolean contains(String value) {
        return this.values.contains(value);
    }

    public boolean remove(String key) {
        return this.values.remove(key) && this.removeIf(i -> i.getValue().equals(key));
    }
}

