/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_cy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_la = "Lladin";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "ksh", "Cwleneg" },
            { "Ogam", "Ogam" },
            { "mwl", "Mirandeg" },
            { "Zsym", "Symbolau" },
            { "cch", "Atsameg" },
            { "mwr", "Marwari" },
            { "%%NJIVA", "tafodiaith Gniva/Njiva" },
            { "egy", "Hen Eiffteg" },
            { "raj", "Rajasthaneg" },
            { "tem", "Timneg" },
            { "teo", "Teso" },
            { "rap", "Rapan\u0175i" },
            { "ter", "Terena" },
            { "AC", "Ynys Ascension" },
            { "rar", "Raratongeg" },
            { "tet", "Tetumeg" },
            { "AD", "Andorra" },
            { "AE", "Emiradau Arabaidd Unedig" },
            { "nl_BE", "Fflemeg" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Yr Ariannin" },
            { "AS", "Samoa America" },
            { "AT", "Awstria" },
            { "AU", "Awstralia" },
            { "AW", "Aruba" },
            { "en_US", "Saesneg America" },
            { "AX", "Ynysoedd \u00c5land" },
            { "AZ", "Azerbaijan" },
            { "%%AREVELA", "Armeneg Dwyreiniol" },
            { "BA", "Bosnia a Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "kum", "Cwmiceg" },
            { "BE", "Gwlad Belg" },
            { "gmh", "Uchel Almaeneg Canol" },
            { "BF", "Burkina Faso" },
            { "BG", "Bwlgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolifia" },
            { "BQ", "Antilles yr Iseldiroedd" },
            { "BR", "Brasil" },
            { "BS", "Y Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Ynys Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarws" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Ynysoedd Cocos (Keeling)" },
            { "mzn", "Masanderani" },
            { "CD", "Y Congo - Kinshasa" },
            { "CF", "Gweriniaeth Canolbarth Affrica" },
            { "CG", "Y Congo - Brazzaville" },
            { "CH", "Y Swistir" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Ynysoedd Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u0175n" },
            { "CN", "Tsieina" },
            { "CO", "Colombia" },
            { "CP", "Ynys Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Ciwba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Ynys y Nadolig" },
            { "CY", "Cyprus" },
            { "CZ", "Gweriniaeth Tsiec" },
            { "vls", "Fflemeg Gorllewinol" },
            { "DE", "Yr Almaen" },
            { "goh", "Hen Uchel Almaeneg" },
            { "ace", "Acehneg" },
            { "cgg", "Tsiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmarc" },
            { "ach", "Acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "DO", "Gweriniaeth Dominica" },
            { "got", "Gotheg" },
            { "zun", "Zuni" },
            { "tig", "Tigreg" },
            { "DZ", "Algeria" },
            { "pag", "Pangasineg" },
            { "pal", "Pahlafi" },
            { "EA", "Ceuta a Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "ada", "Adangmeg" },
            { "EE", "Estonia" },
            { "tiv", "Tifeg" },
            { "EG", "Yr Aifft" },
            { "EH", "Gorllewin Sahara" },
            { "chm", "Marieg" },
            { "cho", "Siocto" },
            { "chr", "Tsieroc\u00ee" },
            { "ER", "Eritrea" },
            { "ES", "Sbaen" },
            { "ET", "Ethiopia" },
            { "EU", "Yr Undeb Ewropeaidd" },
            { "elx", "Elameg" },
            { "chy", "Cheyenne" },
            { "ady", "Circaseg Gorllewinol" },
            { "aeb", "Arabeg Tunisia" },
            { "FI", "Y Ffindir" },
            { "FJ", "Fiji" },
            { "FK", "Ynysoedd y Falkland/Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Ynysoedd Ffaro" },
            { "Taml", "Tamilaidd" },
            { "FR", "Ffrainc" },
            { "pcd", "Picardeg" },
            { "tkl", "Tocelaweg" },
            { "root", "y Gwraidd" },
            { "%%DAJNKO", "gwyddor Dajnko" },
            { "grc", "Hen Roeg" },
            { "GA", "Gabon" },
            { "tkr", "Tsakhureg" },
            { "vot", "Foteg" },
            { "GB", "Y Deyrnas Unedig" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyane Ffrengig" },
            { "GG", "Ynys y Garn" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "afh", "Affrihili" },
            { "GL", "Yr Ynys Las" },
            { "enm", "Saesneg Canol" },
            { "GM", "Gambia" },
            { "GN", "Guin\u00e9e" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Gyhydeddol" },
            { "GR", "Gwlad Groeg" },
            { "GS", "De Georgia ac Ynysoedd Sandwich y De" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Almaeneg Pensylfania" },
            { "GW", "Guin\u00e9-Bissau" },
            { "tli", "Llingit" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ckb", "Cwrdeg Sorani" },
            { "zxx", "Dim cynnwys ieithyddol" },
            { "tly", "Talysheg" },
            { "de_AT", "Almaeneg Awstria" },
            { "HK", "Hong Kong RhGA Tsieina" },
            { "HM", "Ynys Heard ac Ynysoedd McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Aghemeg" },
            { "gsw", "Almaeneg y Swistir" },
            { "HT", "Haiti" },
            { "HU", "Hwngari" },
            { "tmh", "Tamasheceg" },
            { "IC", "Yr Ynysoedd Dedwydd" },
            { "ID", "Indonesia" },
            { "peo", "Hen Bersieg" },
            { "IE", "Iwerddon" },
            { "nap", "Naplieg" },
            { "%%NDYUKA", "tafodiaith Ndyuka" },
            { "naq", "Nama" },
            { "zza", "Zaz\u00e4eg" },
            { "IL", "Israel" },
            { "IM", "Ynys Manaw" },
            { "IN", "India" },
            { "IO", "Tiriogaeth Brydeinig Cefnfor India" },
            { "IQ", "Irac" },
            { "IR", "Iran" },
            { "IS", "Gwlad yr I\u00e2" },
            { "IT", "Yr Eidal" },
            { "%%POSIX", "Cyfrifiadur" },
            { "pfl", "Almaeneg Palatin" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "Beng", "Bengalaidd" },
            { "JO", "Gwlad Iorddonen" },
            { "JP", "Japan" },
            { "%%1606NICT", "Ffrangeg Canol Diweddar hyd at 1606" },
            { "ain", "Ain\u0175eg" },
            { "%%KOCIEWIE", "KOCIEWIE" },
            { "guz", "Gusii" },
            { "de_CH", "Almaeneg Safonol y Swistir" },
            { "KE", "Kenya" },
            { "419", "America Ladin" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts a Nevis" },
            { "Knda", "Canaraidd" },
            { "fr_CA", "Ffrangeg Canada" },
            { "KP", "Gogledd Korea" },
            { "KR", "De Korea" },
            { "fr_CH", "Ffrangeg y Swistir" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Ynysoedd Cayman" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "Cyrilig" },
            { "LA", "Laos" },
            { "LB", "Libanus" },
            { "LC", "Saint Lucia" },
            { "phn", "Phoeniceg" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "Isel Almaeneg" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Acadeg" },
            { "cop", "Copteg" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Lwcsembwrg" },
            { "LV", "Latfia" },
            { "Kana", "Catacana" },
            { "LY", "Libya" },
            { "lad", "Iddew-Sbaeneg" },
            { "vun", "Funjo" },
            { "akz", "Alabam\u00e4eg" },
            { "%%LAUKIKA", "LAUKIKA" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Moroco" },
            { "MC", "Monaco" },
            { "MD", "Moldofa" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagascar" },
            { "MH", "Ynysoedd Marshall" },
            { "ale", "Alewteg" },
            { "Thai", "Tai" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Newaeg" },
            { "MO", "Macau RhGA Tsieina" },
            { "aln", "Ghegeg Albania" },
            { "MP", "Ynysoedd Gogledd Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "Alt\u00e4eg Deheuol" },
            { "MV", "Y Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mecsico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Caledonia Newydd" },
            { "NE", "Niger" },
            { "NF", "Ynys Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Yr Iseldiroedd" },
            { "NO", "Norwy" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsaconeg" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "NZ", "Seland Newydd" },
            { "rom", "Romani" },
            { "crh", "Tyrceg y Crimea" },
            { "ang", "Hen Saesneg" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "PA", "Panama" },
            { "en_GB", "Saesneg Prydain" },
            { "PE", "Periw" },
            { "PF", "Polynesia Ffrengig" },
            { "PG", "Papua Guinea Newydd" },
            { "PH", "Y Philipinau" },
            { "PK", "Pakistan" },
            { "PL", "Gwlad Pwyl" },
            { "ewo", "Ewondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Ynysoedd Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriogaethau Palesteinaidd" },
            { "PT", "Portiwgal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "tum", "Twmbwca" },
            { "Hebr", "Hebreig" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Saesneg Safonol yr Alban" },
            { "pms", "Piedmonteg" },
            { "QO", "Oceania Bellennig" },
            { "ext", "Extremadureg" },
            { "lez", "Lezgheg" },
            { "%%FONUPA", "Seineg UPA" },
            { "tvl", "Twfalweg" },
            { "001", "Y Byd" },
            { "002", "Affrica" },
            { "njo", "Ao Naga" },
            { "003", "Gogledd America" },
            { "RE", "R\u00e9union" },
            { "005", "De America" },
            { "pnt", "Ponteg" },
            { "009", "Oceania" },
            { "%%SURSILV", "SURSILV" },
            { "RO", "Rwmania" },
            { "RS", "Serbia" },
            { "RU", "Rwsia" },
            { "RW", "Rwanda" },
            { "%%METELKO", "gwyddor Metelko" },
            { "SA", "Saudi Arabia" },
            { "pon", "Pohnpeianeg" },
            { "SB", "Ynysoedd Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Gorllewin Affrica" },
            { "SC", "Seychelles" },
            { "SD", "Swdan" },
            { "013", "Canolbarth America" },
            { "SE", "Sweden" },
            { "014", "Dwyrain Affrica" },
            { "arc", "Aramaeg" },
            { "015", "Gogledd Affrica" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "017", "Canol Affrica" },
            { "SI", "Slofenia" },
            { "018", "Deheudir Affrica" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "019", "Yr Amerig" },
            { "SK", "Slofacia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Arawcaneg" },
            { "arp", "Arapaho" },
            { "SR", "Suriname" },
            { "aro", "Araonaeg" },
            { "SS", "De Swdan" },
            { "ST", "S\u00e3o Tom\u00e9 a Pr\u00edncipe" },
            { "arq", "Arabeg Algeria" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Gwlad Swazi" },
            { "arw", "Arawaceg" },
            { "arz", "Arabeg yr Aifft" },
            { "ary", "Arabeg Moroco" },
            { "rtm", "Rotumaneg" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asw" },
            { "021", "America i\u2019r Gogledd o Fecsico" },
            { "TC", "Ynysoedd Turks a Caicos" },
            { "TD", "Tchad" },
            { "TF", "Tiroedd Deheuol ac Antarctig Ffrainc" },
            { "ase", "Iaith Arwyddion America" },
            { "TG", "Togo" },
            { "TH", "Gwlad Thai" },
            { "TJ", "Tajikistan" },
            { "029", "Y Carib\u00ee" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Iembaeg" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Twrci" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Astwrianeg" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Sgript anhysbys" },
            { "UA", "Wcr\u00e1in" },
            { "rup", "Aromaneg" },
            { "030", "Dwyrain Asia" },
            { "sw_CD", "Swahili\u2019r Congo" },
            { "034", "De Asia" },
            { "hai", "Haida" },
            { "035", "De-Ddwyrain Asia" },
            { "UG", "Uganda" },
            { "039", "De Ewrop" },
            { "Sinh", "Sinhanaidd" },
            { "UM", "Ynysoedd Pellennig UDA" },
            { "US", "Yr Unol Daleithiau" },
            { "haw", "Haw\u00e4ieg" },
            { "%%1959ACAD", "Academig" },
            { "UY", "Uruguay" },
            { "prg", "Prwseg" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Tamaseit Canolbarth Moroco" },
            { "VA", "Y Fatican" },
            { "pro", "Hen Brofensaleg" },
            { "VC", "Saint Vincent a\u2019r Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Ynysoedd Gwyryf Prydain" },
            { "VI", "Ynysoedd Gwyryf yr Unol Daleithiau" },
            { "VN", "Fietnam" },
            { "VU", "Vanuatu" },
            { "rwk", "Rwa" },
            { "non", "Hen Norseg" },
            { "053", "Awstralasia" },
            { "%%AREVMDA", "Armeneg Gorllewinol" },
            { "054", "Melanesia" },
            { "WF", "Wallis a Futuna" },
            { "057", "Rhanbarth Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wae", "Walsereg" },
            { "WS", "Samoa" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "war", "Winarayeg" },
            { "awa", "Awadhi" },
            { "061", "Polynesia" },
            { "%%KSCOR", "yr Orgraff Safonol" },
            { "XK", "Kosovo" },
            { "Gujr", "Gwjarataidd" },
            { "Zxxx", "Anysgrifenedig" },
            { "wbp", "Warlpiri" },
            { "YE", "Yemen" },
            { "nqo", "N\u2019Ko" },
            { "lmo", "Lombardeg" },
            { "%%SUTSILV", "SUTSILV" },
            { "fat", "Ffanti" },
            { "YT", "Mayotte" },
            { "ZA", "De Affrica" },
            { "Deva", "Devanagari" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rhanbarth Anhysbys" },
            { "lol", "Mongo" },
            { "nso", "Sotho Gogleddol" },
            { "loz", "Lozi" },
            { "jmc", "Matsiame" },
            { "nus", "N\u0175ereg" },
            { "dak", "Dacotaeg" },
            { "hit", "Hetheg" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Luri Gogleddol" },
            { "nwc", "Hen Newari" },
            { "udm", "Fotiaceg" },
            { "Khmr", "Chmeraidd" },
            { "sad", "Sand\u00e4weg" },
            { "ltg", "Latgaleg" },
            { "sam", "Aramaeg Samaria" },
            { "saq", "Samb\u0175rw" },
            { "sas", "Sasaceg" },
            { "sat", "Santali" },
            { "jpr", "Iddew-Bersieg" },
            { "sba", "Ngambeieg" },
            { "Guru", "Gwrmwci" },
            { "%%ALUKU", "tafodiaith Aluku" },
            { "%%BISCAYAN", "BISCAYAN" },
            { "sbp", "Sangw" },
            { "nyn", "Niancole" },
            { "nym", "Niamwezi" },
            { "lun", "Lwnda" },
            { "nyo", "Nioro" },
            { "luo", "L\u0175o" },
            { "fil", "Ffilipineg" },
            { "hmn", "Hmongeg" },
            { "lus", "Lwshaieg" },
            { "bal", "Balwtsi" },
            { "ban", "Bal\u00efeg" },
            { "uga", "Wgariteg" },
            { "fit", "Ffinneg Tornedal" },
            { "luy", "Lwyia" },
            { "bas", "Bas\u00e2eg" },
            { "bax", "Bamwmeg" },
            { "jrb", "Iddew-Arabeg" },
            { "es_ES", "Sbaeneg Ewrop" },
            { "nzi", "Nzimeg" },
            { "sco", "Sgoteg" },
            { "scn", "Sisileg" },
            { "aa", "Affareg" },
            { "ab", "Abchaseg" },
            { "ae", "Afestaneg" },
            { "af", "Affric\u00e2neg" },
            { "ak", "Acaneg" },
            { "am", "Amhareg" },
            { "an", "Aragoneg" },
            { "Arab", "Arabaidd" },
            { "Jpan", "Japaneaidd" },
            { "ar", "Arabeg" },
            { "as", "Asameg" },
            { "sdc", "Sasareseg Sardinia" },
            { "av", "Afareg" },
            { "sdh", "Cwrdeg Deheuol" },
            { "ay", "Aymareg" },
            { "az", "Aserbaijaneg" },
            { "%%OSOJS", "tafodiaith Oseacco/Osojane" },
            { "ba", "Bashcorteg" },
            { "be", "Belarwseg" },
            { "bg", "Bwlgareg" },
            { "bi", "Bislama" },
            { "bm", "Bambareg" },
            { "bn", "Bengaleg" },
            { "bo", "Tibeteg" },
            { "br", "Llydaweg" },
            { "bs", "Bosnieg" },
            { "see", "Seneca" },
            { "Mymr", "Myanmaraidd" },
            { "sei", "Seri" },
            { "seh", "Sena" },
            { "sel", "Selcypeg" },
            { "ca", "Catalaneg" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Tsietsieneg" },
            { "ch", "Tsiamorro" },
            { "co", "Corseg" },
            { "Orya", "Or\u00efaidd" },
            { "cr", "Cri" },
            { "cs", "Tsieceg" },
            { "cu", "Hen Slafoneg" },
            { "cv", "Tshwfasheg" },
            { "cy", "Cymraeg" },
            { "da", "Daneg" },
            { "pt_PT", "Portiwgeeg Ewrop" },
            { "de", "Almaeneg" },
            { "bej", "Bej\u00e4eg" },
            { "din", "Dinca" },
            { "bem", "Bembeg" },
            { "sga", "Hen Wyddeleg" },
            { "dv", "Difehi" },
            { "es_419", "Sbaeneg America Ladin" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "dje", "Zarmaeg" },
            { "sgs", "Samogiteg" },
            { "ee", "Ewe" },
            { "bfd", "Baffwteg" },
            { "ro_MD", "Moldofeg" },
            { "el", "Groeg" },
            { "en", "Saesneg" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "es", "Sbaeneg" },
            { "et", "Estoneg" },
            { "eu", "Basgeg" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbeg Uchaf" },
            { "Hani", "Han" },
            { "fa", "Perseg" },
            { "Hans", "Symledig" },
            { "Hant", "Traddodiadol" },
            { "az_Arab", "Aserbaijaneg Deheuol" },
            { "ff", "Ffwla" },
            { "shu", "Arabeg Chad" },
            { "fi", "Ffinneg" },
            { "fj", "Ffij\u00efeg" },
            { "bgn", "Balochi Gorllewinol" },
            { "yue", "Cantoneeg" },
            { "fo", "Ffar\u00f6eg" },
            { "umb", "Umbundu" },
            { "fr", "Ffrangeg" },
            { "sid", "Sidamo" },
            { "fy", "Ffriseg y Gorllewin" },
            { "ga", "Gwyddeleg" },
            { "gd", "Gaeleg yr Alban" },
            { "gl", "Galisieg" },
            { "gn", "Guaran\u00ed" },
            { "und", "Iaith Anhysbys" },
            { "gu", "Gwjarati" },
            { "gv", "Manaweg" },
            { "ha", "Hawsa" },
            { "he", "Hebraeg" },
            { "hi", "Hindi" },
            { "hr", "Croateg" },
            { "ht", "Creol Haiti" },
            { "hu", "Hwngareg" },
            { "hy", "Armeneg" },
            { "hz", "Herero" },
            { "frc", "Ffrangeg Cajwn" },
            { "%%FONIPA", "Seineg IPA" },
            { "ia", "Interlingua" },
            { "id", "Indoneseg" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Nwosw" },
            { "frm", "Ffrangeg Canol" },
            { "ik", "Inwpiaceg" },
            { "fro", "Hen Ffrangeg" },
            { "frp", "Arpitaneg" },
            { "frs", "Ffriseg y Dwyrain" },
            { "frr", "Ffriseg y Gogledd" },
            { "is", "Islandeg" },
            { "it", "Eidaleg" },
            { "iu", "Inwctitwt" },
            { "sli", "Is-silesieg" },
            { "%%HOGNORSK", "HOGNORSK" },
            { "ja", "Japaneeg" },
            { "Mlym", "Malayalamaidd" },
            { "doi", "Dogri" },
            { "bkm", "Comeg" },
            { "sma", "Sami Deheuol" },
            { "jv", "Jafanaeg" },
            { "%%BAUDDHA", "BAUDDHA" },
            { "mad", "Madwreg" },
            { "smj", "Sami Lwle" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "smn", "Sami Inari" },
            { "ka", "Georgeg" },
            { "bla", "Siksika" },
            { "mak", "Macasareg" },
            { "sms", "Sami Scolt" },
            { "man", "Mandingo" },
            { "kg", "Congo" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kk", "Casacheg" },
            { "kl", "Kalaallisut" },
            { "km", "Chmereg" },
            { "kn", "Kannada" },
            { "ko", "Coreeg" },
            { "kr", "Canwri" },
            { "ks", "Cashmireg" },
            { "ku", "Cwrdeg" },
            { "kv", "Comi" },
            { "kw", "Cernyweg" },
            { "ky", "Cirgiseg" },
            { "snk", "Soninceg" },
            { "la", metaValue_la },
            { "lb", "Lwcsembwrgeg" },
            { "lg", "Ganda" },
            { "li", "Limbwrgeg" },
            { "Tibt", "Tibetaidd" },
            { "ln", "Lingala" },
            { "fur", "Ffriwleg" },
            { "lo", "Laoeg" },
            { "lt", "Lithwaneg" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latfieg" },
            { "sog", "Sogdeg" },
            { "mg", "Malagaseg" },
            { "mh", "Marsialeg" },
            { "mi", "Maori" },
            { "mk", "Macedoneg" },
            { "ml", "Malayalam" },
            { "mn", "Mongoleg" },
            { "mr", "Marathi" },
            { "ms", "Maleieg" },
            { "mt", "Malteg" },
            { "my", "Byrmaneg" },
            { "Armn", "Armenaidd" },
            { "mdf", "Mocsia" },
            { "dsb", "Sorbeg Isaf" },
            { "na", "Nawr\u0175eg" },
            { "nb", "Norwyeg Bokm\u00e5l" },
            { "nd", "Ndebele Gogleddol" },
            { "ne", "Nepaleg" },
            { "ng", "Ndonga" },
            { "mdr", "Mandareg" },
            { "nl", "Iseldireg" },
            { "nn", "Norwyeg Nynorsk" },
            { "no", "Norwyeg" },
            { "nr", "Ndebele Deheuol" },
            { "nv", "Nafaho" },
            { "kaa", "Cara-Calpaceg" },
            { "ny", "Nianja" },
            { "kab", "Cabileg" },
            { "oc", "Ocsitaneg" },
            { "kam", "Camba" },
            { "men", "Mendeg" },
            { "%%EMODENG", "Saesneg Modern Cynnar" },
            { "oj", "Ojibwa" },
            { "mer", "M\u00earw" },
            { "om", "Oromo" },
            { "or", "Oriya" },
            { "os", "Oseteg" },
            { "kbd", "Circaseg Dwyreiniol" },
            { "mfe", "Morisyen" },
            { "pa", "Pwnjabeg" },
            { "dua", "Diwaleg" },
            { "srr", "Serereg" },
            { "pi", "Pali" },
            { "pl", "Pwyleg" },
            { "dum", "Iseldireg Canol" },
            { "%%VALLADER", "VALLADER" },
            { "ps", "Pashto" },
            { "pt", "Portiwgeeg" },
            { "mga", "Gwyddeleg Canol" },
            { "pt_BR", "Portiwgeeg Brasil" },
            { "%%BOHORIC", "Gwyddor Bohori\u010d" },
            { "kcg", "Tyapeg" },
            { "mgh", "Makhuwa-Meetto" },
            { "%%JAUER", "JAUER" },
            { "Laoo", "Laoaidd" },
            { "%%SURMIRAN", "SURMIRAN" },
            { "mgo", "Meta" },
            { "brh", "Brahui" },
            { "qu", "Quechua" },
            { "zap", "Zapoteceg" },
            { "brx", "Bodo" },
            { "kde", "Macondeg" },
            { "%%VAIDIKA", "VAIDIKA" },
            { "stq", "Ffriseg Saterland" },
            { "Ethi", "Ethiopig" },
            { "%%JYUTPING", "JYUTPING" },
            { "rm", "Rom\u00e1nsh" },
            { "rn", "Rwndi" },
            { "ro", "Rwmaneg" },
            { "ru", "Rwseg" },
            { "bss", "Acwseg" },
            { "rw", "Ciniar\u0175andeg" },
            { "zbl", "Blisssymbols" },
            { "kea", "Caboferdianeg" },
            { "mic", "Micmaceg" },
            { "suk", "Swcwma" },
            { "en_AU", "Saesneg Awstralia" },
            { "sa", "Sansgrit" },
            { "sc", "Sardeg" },
            { "sus", "Sws\u0175eg" },
            { "sd", "Sindhi" },
            { "se", "Sami Gogleddol" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croateg" },
            { "si", "Sinhaleg" },
            { "sux", "Swmereg" },
            { "sk", "Slofaceg" },
            { "sl", "Slofeneg" },
            { "sm", "Sam\u00f6eg" },
            { "sn", "Shona" },
            { "so", "Somaleg" },
            { "sq", "Albaneg" },
            { "sr", "Serbeg" },
            { "ss", "Swati" },
            { "st", "Sesotheg" },
            { "su", "Swndaneg" },
            { "%%NEDIS", "tafodiaith Natisone" },
            { "sv", "Swedeg" },
            { "sw", "Swahili" },
            { "ibb", "Ibibio" },
            { "iba", "Ibaneg" },
            { "ta", "Tamileg" },
            { "142", "Asia" },
            { "bua", "Bwriateg" },
            { "143", "Canol Asia" },
            { "te", metaValue_te },
            { "145", "Gorllewin Asia" },
            { "tg", "Tajiceg" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "en_CA", "Saesneg Canada" },
            { "tk", "Twrcmeneg" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongeg" },
            { "bum", "Bwlw" },
            { "dyo", "Jola-Fonyi" },
            { "tr", "Tyrceg" },
            { "ts", "Tsongaeg" },
            { "swb", "Comoreg" },
            { "tt", "Tatareg" },
            { "tw", "Twi" },
            { "150", "Ewrop" },
            { "151", "Dwyrain Ewrop" },
            { "154", "Gogledd Ewrop" },
            { "155", "Gorllewin Ewrop" },
            { "ug", "Uighur" },
            { "Kore", "Coreaidd" },
            { "Zyyy", "Cyffredin" },
            { "uk", "Wcreineg" },
            { "zea", "Z\u00ealandeg" },
            { "ur", "Wrdw" },
            { "xal", "Calmyceg" },
            { "uz", "Wsbeceg" },
            { "kha", "C\u00e0seg" },
            { "nds_NL", "Sacsoneg Isel" },
            { "ve", "Fendeg" },
            { "vi", "Fietnameg" },
            { "khq", "Koyra Chiini" },
            { "khw", "Chowareg" },
            { "syc", "Hen Syrieg" },
            { "quc", "K\u2019iche\u2019" },
            { "wa", "Walwneg" },
            { "gag", "Gagauz" },
            { "syr", "Syrieg" },
            { "Grek", "Groegaidd" },
            { "wo", "Woloff" },
            { "zgh", "Tamaseit Safonol" },
            { "ar_001", "Arabeg Modern Safonol" },
            { "%%FONXSAMP", "FONXSAMP" },
            { "gay", "Gaio" },
            { "Mong", "Mongolaidd" },
            { "mnc", "Manshw" },
            { "szl", "Silesieg" },
            { "gba", "Gbaia" },
            { "mni", "Manipwri" },
            { "Latn", metaValue_la },
            { "xh", "Xhosa" },
            { "%%PAMAKA", "tafodiaith Pamaka" },
            { "osa", "Osageg" },
            { "gbz", "Dareg y Zoroastriaid" },
            { "moh", "Mohoceg" },
            { "%%1694ACAD", "Ffrangeg Modern Cynnar" },
            { "yi", "Iddew-Almaeneg" },
            { "mos", "Mosi" },
            { "yo", "Iorwba" },
            { "es_MX", "Sbaeneg Mecsico" },
            { "ota", "Tyrceg Otoman" },
            { "vai", "Faieg" },
            { "kln", "Kalenjin" },
            { "zh", "Tsieineeg" },
            { "Bopo", "Bopomofo" },
            { "zu", "Swlw" },
            { "Geor", "Georgaidd" },
            { "mrj", "Mari Gorllewinol" },
            { "%%ITIHASA", "ITIHASA" },
            { "ebu", "Embw" },
            { "zh_Hans", "Tsieineeg Symledig" },
            { "koi", "Komi-Permyak" },
            { "kok", "Concani" },
            { "%%1901", "orgraff draddodiadol yr Almaeneg" },
            { "vec", "Feniseg" },
            { "zh_Hant", "Tsieineeg Traddodiadol" },
            { "vep", "Feps" },
            { "ilo", "Ilocaneg" },
            { "mua", "Mundang" },
            { "mul", "mwy nag un iaith" },
            { "cad", "Cado" },
            { "gil", "Gilberteg" },
            { "%%KKCOR", "yr Orgraff Gyffredin" },
            { "car", "Caribeg" },
            { "inh", "Ingwsieg" },
            { "krl", "Careleg" },
            { "tcy", "Tulu" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Baffia" },
        };
        return data;
    }
}
