/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Kiarabu";
        final String metaValue_bn = "Kibengali";
        final String metaValue_bo = "Kitibeti";
        final String metaValue_el = "Kigiriki";
        final String metaValue_gu = "Kigujarati";
        final String metaValue_he = "Kiebrania";
        final String metaValue_hy = "Kiarmenia";
        final String metaValue_ja = "Kijapani";
        final String metaValue_ka = "Kijojia";
        final String metaValue_km = "Kikambodia";
        final String metaValue_kn = "Kikannada";
        final String metaValue_ko = "Kikorea";
        final String metaValue_la = "Kilatini";
        final String metaValue_lo = "Kilaosi";
        final String metaValue_ml = "Kimalayalam";
        final String metaValue_mn = "Kimongolia";
        final String metaValue_or = "Kioriya";
        final String metaValue_si = "Kisinhala";
        final String metaValue_ta = "Kitamil";
        final String metaValue_te = "Kitelugu";
        final Object[][] data = new Object[][] {
            { "sbp", "Kisangu" },
            { "nyn", "Kinyankole" },
            { "luo", "Kijaluo" },
            { "Zsym", "Alama" },
            { "fil", "Kifilipino" },
            { "luy", "Kiluhya" },
            { "teo", "Kiteso" },
            { "ab", "Kiabkhazi" },
            { "AC", "Kisiwa cha Ascension" },
            { "tet", "Kitetum" },
            { "AD", "Andora" },
            { "AE", "Falme za Kiarabu" },
            { "AF", "Afghanistan" },
            { "af", "Kiafrikana" },
            { "AG", "Antigua na Barbuda" },
            { "AI", "Anguilla" },
            { "ak", "Kiakani" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "am", "Kiamhari" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antaktika" },
            { "ar", metaValue_ar },
            { "AR", "Ajentina" },
            { "AS", "Samoa ya Marekani" },
            { "as", "Kiassam" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "sdh", "Kikurdi cha Kusini" },
            { "AX", "Visiwa vya Alandi" },
            { "ay", "Kiaimara" },
            { "AZ", "Azabajani" },
            { "az", "Kiazabajani" },
            { "BA", "Bosnia na Hezegovina" },
            { "ba", "Kibashkir" },
            { "BB", "Babadosi" },
            { "BD", "Bangladeshi" },
            { "BE", "Ubelgiji" },
            { "be", "Kibelarusi" },
            { "BF", "Bukinafaso" },
            { "BG", "Bulgaria" },
            { "bg", "Kibulgaria" },
            { "BH", "Bahareni" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Santabathelemi" },
            { "BM", "Bermuda" },
            { "bm", "Kibambara" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Uholanzi ya Karibiani" },
            { "BR", "Brazili" },
            { "br", "Kibretoni" },
            { "BS", "Bahama" },
            { "bs", "Kibosnia" },
            { "xog", "Kisoga" },
            { "BT", "Bhutan" },
            { "BV", "Kisiwa cha Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "Myama" },
            { "BY", "Belarusi" },
            { "seh", "Kisena" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "ca", "Kikatalani" },
            { "CC", "Visiwa vya Cocos (Keeling)" },
            { "mzn", "Kimazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Jamhuri ya Kidemokrasia ya Kongo" },
            { "ce", "Kichechenia" },
            { "CF", "Jamhuri ya Afrika ya Kati" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Uswisi" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Visiwa vya Cook" },
            { "CL", "Chile" },
            { "CM", "Kameruni" },
            { "CN", "China" },
            { "CO", "Kolombia" },
            { "co", "Kikosikani" },
            { "CP", "Kisiwa cha Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Kostarika" },
            { "cs", "Kicheki" },
            { "CU", "Kuba" },
            { "CV", "Kepuvede" },
            { "cv", "Kichuvash" },
            { "CW", "Kurakao" },
            { "CX", "Kisiwa cha Krismasi" },
            { "CY", "Cyprus" },
            { "cy", "Kiwelisi" },
            { "CZ", "Jamhuri ya Cheki" },
            { "da", "Kidenmaki" },
            { "DE", "Ujerumani" },
            { "de", "Kijerumani" },
            { "cgg", "Kichiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Denmark" },
            { "ach", "Kiakoli" },
            { "Brai", "Braille" },
            { "DM", "Dominika" },
            { "DO", "Jamhuri ya Dominika" },
            { "bem", "Kibemba" },
            { "dv", "Kidivehi" },
            { "DZ", "Aljeria" },
            { "dz", "Kizongkha" },
            { "bez", "Kibena" },
            { "EA", "Ceuta na Melilla" },
            { "EC", "Ekwado" },
            { "dje", "Kizarma" },
            { "EE", "Estonia" },
            { "ee", "Kiewe" },
            { "EG", "Misri" },
            { "EH", "Sahara Magharibi" },
            { "el", metaValue_el },
            { "en", "Kiingereza" },
            { "eo", "Kiesperanto" },
            { "chr", "Kicherokee" },
            { "ER", "Eritrea" },
            { "ES", "Hispania" },
            { "es", "Kihispania" },
            { "ET", "Uhabeshi" },
            { "et", "Kiestonia" },
            { "EU", "Umoja wa Ulaya" },
            { "eu", "Kibasque" },
            { "Hang", "Kihangul" },
            { "shi", "Kitachelhit" },
            { "hsb", "hsb" },
            { "Hani", "Kihan" },
            { "fa", "Kiajemi" },
            { "Hans", "Rahisi" },
            { "Hant", "Kihan cha Jadi" },
            { "FI", "Ufini" },
            { "fi", "Kifini" },
            { "FJ", "Fiji" },
            { "fj", "Kifiji" },
            { "FK", "Visiwa vya Falkland" },
            { "FM", "Mikronesia" },
            { "bgn", "Kibalochi cha Magharibi" },
            { "FO", "Visiwa vya Faroe" },
            { "fo", "Kifaroe" },
            { "Taml", metaValue_ta },
            { "FR", "Ufaransa" },
            { "fr", "Kifaransa" },
            { "fy", "Kifrisia cha Magharibi" },
            { "grc", "Kiyunani" },
            { "GA", "Gabon" },
            { "ga", "Kiayalandi" },
            { "GB", "Uingereza" },
            { "GD", "Grenada" },
            { "gd", "Kigaeli cha Uskoti" },
            { "GE", "Jojia" },
            { "GF", "Gwiyana ya Ufaransa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Jibralta" },
            { "GL", "Grinlandi" },
            { "gl", "Kigalisi" },
            { "GM", "Gambia" },
            { "GN", "Gine" },
            { "gn", "Kiguarani" },
            { "GP", "Gwadelupe" },
            { "GQ", "Ginekweta" },
            { "und", "Lugha Isiyojulikana" },
            { "GR", "Ugiriki" },
            { "GS", "Jojia Kusini na Visiwa vya Sandwich Kusini" },
            { "GT", "Gwatemala" },
            { "gu", metaValue_gu },
            { "GU", "Gwam" },
            { "gv", "Kimanx" },
            { "GW", "Ginebisau" },
            { "tlh", "Kiklingoni" },
            { "GY", "Guyana" },
            { "ha", "Kihausa" },
            { "ckb", "Kikurdi cha Sorani" },
            { "zxx", "Hakuna maudhui ya lugha" },
            { "he", metaValue_he },
            { "hi", "Kihindi" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kisiwa cha Heard na Visiwa vya McDonald" },
            { "HN", "Hondurasi" },
            { "HR", "Korasia" },
            { "hr", "Kroeshia" },
            { "agq", "Kiaghem" },
            { "gsw", "Kijerumani cha Uswisi" },
            { "HT", "Haiti" },
            { "ht", "Kihaiti" },
            { "HU", "Hungaria" },
            { "hu", "Kihungari" },
            { "hy", metaValue_hy },
            { "ia", "Kiintalingua" },
            { "IC", "Visiwa vya Kanari" },
            { "ID", "Indonesia" },
            { "id", "Kiindonesia" },
            { "IE", "Ayalandi" },
            { "ig", "Kiigbo" },
            { "naq", "Kinama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Israeli" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Eneo la Uingereza katika Bahari Hindi" },
            { "IQ", "Iraki" },
            { "IR", "Iran" },
            { "IS", "Aislandi" },
            { "is", "Kiaisilandi" },
            { "IT", "Italia" },
            { "it", "Kiitaliano" },
            { "iu", "Kiinuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Yordani" },
            { "JP", "Japani" },
            { "sma", "Kisami cha Kusini" },
            { "jv", "Kijava" },
            { "guz", "Kikisii" },
            { "smj", "Kisami cha Lule" },
            { "mag", "Kimagahi" },
            { "smn", "Kisami cha Inari" },
            { "ka", metaValue_ka },
            { "sms", "Kisami cha Skolt" },
            { "KE", "Kenya" },
            { "419", "Amerika ya Kilatini" },
            { "KG", "Kirigizistani" },
            { "kg", "Kikongo" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "ki", "Kikikuyu" },
            { "mas", "Kimaasai" },
            { "kk", "Kikazaki" },
            { "kl", "Kikalaallisut" },
            { "km", metaValue_km },
            { "KM", "Komoro" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Santakitzi na Nevis" },
            { "ko", metaValue_ko },
            { "KP", "Korea Kaskazini" },
            { "KR", "Korea Kusini" },
            { "ks", "Kikashmiri" },
            { "ku", "Kikurdi" },
            { "kv", "Kikomi" },
            { "KW", "Kuwaiti" },
            { "kw", "Kikorni" },
            { "tpi", "Kitokpisin" },
            { "KY", "Visiwa vya Kayman" },
            { "ky", "Kikirigizi" },
            { "KZ", "Kazakistani" },
            { "Cyrl", "Kisiriliki" },
            { "la", metaValue_la },
            { "LA", "Laosi" },
            { "LB", "Lebanoni" },
            { "lb", "Kilasembagi" },
            { "LC", "Santalusia" },
            { "lg", "Kiganda" },
            { "nds", "nds" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Kilingala" },
            { "lo", metaValue_lo },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Litwania" },
            { "lt", "Kilithuania" },
            { "LU", "Luxembourg" },
            { "lu", "Kiluba-Katanga" },
            { "LV", "Lativia" },
            { "lv", "Kilatvia" },
            { "Kana", "Kikatakana" },
            { "LY", "Libya" },
            { "vun", "Kivunjo" },
            { "lag", "Kirangi" },
            { "Thaa", "Kithaana" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "Chilamba" },
            { "MG", "Madagaska" },
            { "mg", "Malagasi" },
            { "MH", "Visiwa vya Marshall" },
            { "Thai", "Kitai" },
            { "mi", "Kimaori" },
            { "MK", "Masedonia" },
            { "mk", "Kimasedonia" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_mn },
            { "MN", "Mongolia" },
            { "new", "Kinewari" },
            { "MO", "Macau SAR China" },
            { "MP", "Visiwa vya Mariana vya Kaskazini" },
            { "MQ", "Martiniki" },
            { "MR", "Moritania" },
            { "mr", "Kimarathi" },
            { "MS", "Montserrati" },
            { "ms", "Kimalesia" },
            { "MT", "Malta" },
            { "mt", "Kimalta" },
            { "MU", "Morisi" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "my", "Kiburma" },
            { "Armn", metaValue_hy },
            { "MZ", "Msumbiji" },
            { "dsb", "Kidolnoserbski" },
            { "NA", "Namibia" },
            { "nb", "Kibokmal cha Norwe" },
            { "NC", "Nyukaledonia" },
            { "nd", "Kindebele cha Kaskazini" },
            { "NE", "Niger" },
            { "ne", "Kinepali" },
            { "NF", "Kisiwa cha Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragwa" },
            { "NL", "Uholanzi" },
            { "nl", "Kiholanzi" },
            { "nn", "Kinorwe Kipya" },
            { "NO", "Norwe" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Kirombo" },
            { "ny", "Kinyanja" },
            { "NZ", "Nyuzilandi" },
            { "kab", "Kikabylia" },
            { "oc", "Kiokitani" },
            { "kam", "Kikamba" },
            { "mer", "Kimeru" },
            { "OM", "Omani" },
            { "om", "Kioromo" },
            { "or", metaValue_or },
            { "os", "Kiosetia" },
            { "mfe", "Kimoriseni" },
            { "PA", "Panama" },
            { "pa", "Kipunjabi" },
            { "dua", "Kiduala" },
            { "PE", "Peru" },
            { "PF", "Polinesia ya Ufaransa" },
            { "PG", "Papua New Guinea" },
            { "PH", "Ufilipino" },
            { "PK", "Pakistani" },
            { "PL", "Polandi" },
            { "pl", "Kipolandi" },
            { "PM", "Santapierre na Miquelon" },
            { "PN", "Visiwa vya Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Maeneo ya Palestina" },
            { "ps", "Kipashto" },
            { "PT", "Ureno" },
            { "pt", "Kireno" },
            { "PW", "Palau" },
            { "PY", "Paragwai" },
            { "tum", "Kitumbuka" },
            { "Hebr", metaValue_he },
            { "mgh", "Kimakhuwa-Meetto" },
            { "QA", "Qatar" },
            { "Laoo", metaValue_lo },
            { "mgo", "Kimeta" },
            { "QO", "Oceania ya Nje" },
            { "qu", "Kiquechua" },
            { "brx", "Kibodo" },
            { "kde", "Kimakonde" },
            { "001", "Dunia" },
            { "Ethi", "Kiethiopia" },
            { "002", "Afrika" },
            { "003", "Amerika Kaskazini" },
            { "RE", "Riyunioni" },
            { "005", "Amerika Kusini" },
            { "009", "Oceania" },
            { "rm", "Kiromanshi" },
            { "rn", "Kirundi" },
            { "RO", "Romania" },
            { "ro", "Kiromania" },
            { "RS", "Serbia" },
            { "RU", "Urusi" },
            { "ru", "Kirusi" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kikabuverdianu" },
            { "suk", "Kisukuma" },
            { "SA", "Saudi" },
            { "sa", "Kisanskriti" },
            { "SB", "Visiwa vya Solomon" },
            { "twq", "Kitasawaq" },
            { "011", "Afrika ya Magharibi" },
            { "SC", "Shelisheli" },
            { "SD", "Sudani" },
            { "sd", "Kisindhi" },
            { "013", "Amerika ya Kati" },
            { "SE", "Uswidi" },
            { "se", "Kisami cha Kaskazini" },
            { "014", "Afrika ya Mashariki" },
            { "015", "Afrika ya Kaskazini" },
            { "SG", "Singapore" },
            { "sg", "Kisango" },
            { "SH", "Santahelena" },
            { "si", metaValue_si },
            { "017", "Afrika ya Kati" },
            { "SI", "Slovenia" },
            { "018", "Afrika ya Kusini" },
            { "SJ", "Svalbard na Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "sk", "Kislovakia" },
            { "SL", "Siera Leoni" },
            { "sl", "Kislovenia" },
            { "SM", "San Marino" },
            { "sm", "Kisamoa" },
            { "SN", "Senegali" },
            { "sn", "Kishona" },
            { "SO", "Somalia" },
            { "so", "Kisomali" },
            { "arn", "Kimapuche" },
            { "sq", "Kialbania" },
            { "SR", "Surinamu" },
            { "sr", "Kiserbia" },
            { "SS", "Sudani Kusini" },
            { "ss", "Kiswati" },
            { "ST", "S\u00e3o Tom\u00e9 na Pr\u00edncipe" },
            { "st", "Kisotho cha Kusini" },
            { "arq", "Kiarabu cha Kialjeria" },
            { "su", "Kisunda" },
            { "SV", "Elsavado" },
            { "sv", "Kiswidi" },
            { "sw", "Kiswahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "Kiyao" },
            { "SZ", "Uswazi" },
            { "arz", "Kiarabu cha Misri" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "Kiasu" },
            { "021", "Amerika ya Kaskazini" },
            { "142", "Asia" },
            { "TC", "Visiwa vya Turki na Kaiko" },
            { "143", "Asia ya Kati" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Asia ya Magharibi" },
            { "TF", "Maeneo ya Kusini ya Ufaransa" },
            { "TG", "Togo" },
            { "tg", "Kitajiki" },
            { "TH", "Tailandi" },
            { "th", "Kitailandi" },
            { "ti", "Kitigrinya" },
            { "kfo", "Kikoro" },
            { "TJ", "Tajikistani" },
            { "029", "Karibiani" },
            { "TK", "Tokelau" },
            { "tk", "Kiturukimeni" },
            { "TL", "Timor-Leste" },
            { "TM", "Turukimenistani" },
            { "TN", "Tunisia" },
            { "tn", "Kitswana" },
            { "TO", "Tonga" },
            { "to", "Kitonga" },
            { "dyo", "Kijola-Fonyi" },
            { "TR", "Uturuki" },
            { "tr", "Kituruki" },
            { "ts", "Kitsonga" },
            { "TT", "Trinidad na Tobago" },
            { "tt", "Kitatari" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ty", "Kitahiti" },
            { "TZ", "Tanzania" },
            { "nmg", "Kikwasio" },
            { "Zzzz", "Hati isiyojulikana" },
            { "150", "Ulaya" },
            { "UA", "Ukraini" },
            { "030", "Asia Mashariki" },
            { "151", "Ulaya ya Mashariki" },
            { "154", "Ulaya ya Kaskazini" },
            { "sw_CD", "Kingwana" },
            { "034", "Asia ya Kusini" },
            { "155", "Ulaya ya Magharibi" },
            { "035", "Asia ya Kusini Mashariki" },
            { "UG", "Uganda" },
            { "ug", "Kiuyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Kawaida" },
            { "039", "Ulaya ya Kusini" },
            { "uk", "Kiukrania" },
            { "Sinh", metaValue_si },
            { "UM", "Visiwa Vidogo vya Nje vya Marekani" },
            { "ur", "Kiurdu" },
            { "US", "Marekani" },
            { "haw", "Kihawai" },
            { "UY", "Urugwai" },
            { "UZ", "Uzibekistani" },
            { "uz", "Kiuzbeki" },
            { "tzm", "Central Atlas Tamazight" },
            { "VA", "Vatikani" },
            { "VC", "Santavisenti na Grenadini" },
            { "VE", "Venezuela" },
            { "ve", "Kivenda" },
            { "VG", "Visiwa vya Virgin vya Uingereza" },
            { "VI", "Visiwa vya Virgin vya Marekani" },
            { "vi", "Kivietinamu" },
            { "khq", "Kikoyra Chiini" },
            { "VN", "Vietnam" },
            { "quc", "K\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "Kiga" },
            { "rwk", "Kirwo" },
            { "gag", "Kigagauzi" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Walis na Futuna" },
            { "Grek", metaValue_el },
            { "057", "Eneo la Mikronesia" },
            { "jgo", "Kingomba" },
            { "lkt", "Kilakota" },
            { "wo", "Kiwolofu" },
            { "zgh", "Tamaziti Msingi ya Kimoroko" },
            { "ar_001", "Kiarabu Sanifu cha Kisasa" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "Latn", metaValue_la },
            { "061", "Polynesia" },
            { "xh", "Kixhosa" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Haijaandikwa" },
            { "wbp", "Kiwarlpiri" },
            { "moh", "Kimohoki" },
            { "YE", "Yemeni" },
            { "nqo", "N\u2019Ko" },
            { "yi", "Kiyidi" },
            { "yo", "Kiyoruba" },
            { "YT", "Mayotte" },
            { "vai", "Kivai" },
            { "ZA", "Afrika Kusini" },
            { "kln", "Kikalenjin" },
            { "Deva", "Kidevanagari" },
            { "zh", "Kichina" },
            { "Hira", "Kihiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Kibopomofo" },
            { "zu", "Kizulu" },
            { "ZW", "Zimbabwe" },
            { "Geor", metaValue_ka },
            { "ZZ", "Eneo lisilojulikana" },
            { "kmb", "Kimbundu" },
            { "nso", "Kisotho cha Kaskazini" },
            { "loz", "Kilozi" },
            { "ebu", "Kiembu" },
            { "jmc", "Kimachame" },
            { "zh_Hans", "Kichina (Kilichorahisishwa)" },
            { "koi", "Kikomipermyak" },
            { "kok", "Kikonkani" },
            { "nus", "Kinuer" },
            { "hit", "Kihiti" },
            { "dav", "Kitaita" },
            { "lrc", "Kiluri cha Kaskazini" },
            { "zh_Hant", "Kichina cha Jadi" },
            { "mua", "Kimundang" },
            { "nwc", "Kinewari cha kale" },
            { "Khmr", metaValue_km },
            { "saq", "Kisamburu" },
            { "efi", "Kiefiki" },
            { "Guru", "Kigurmukhi" },
            { "lua", "Kiluba-Lulua" },
            { "ksb", "Kisambaa" },
            { "Telu", metaValue_te },
            { "ksf", "Kibafia" },
        };
        return data;
    }
}
