/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_si extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0db8\u0ddc\u0dc3\u0dca\u0d9a\u0dc0\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MSK",
               "\u0db8\u0ddc\u0dc3\u0dca\u0d9a\u0dc0\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MSD",
               "\u0db8\u0ddc\u0dc3\u0dca\u0d9a\u0dc0\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0da2\u0db4\u0dcf\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "JST",
               "\u0da2\u0db4\u0dcf\u0db1 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "JDT",
               "\u0da2\u0db4\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PKT",
               "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "PKST",
               "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u0dad\u0dcf\u0dba\u0dd2\u0db4\u0dda \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CST",
               "\u0dad\u0dcf\u0dba\u0dd2\u0db4\u0dda \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CDT",
               "\u0dad\u0dcf\u0dba\u0dd2\u0db4\u0dda \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u0dc4\u0ddc\u0dc0\u0dca\u0da9\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HOVT",
               "\u0dc4\u0ddc\u0dc0\u0dca\u0da9\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HOVST",
               "\u0dc4\u0ddc\u0dc0\u0dca\u0da9\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u0db8\u0dd9\u0d9c\u0da9\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MAGT",
               "\u0db8\u0dd9\u0d9c\u0da9\u0db1\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MAGST",
               "\u0db8\u0dd9\u0d9c\u0da9\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACWST",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACWDT",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CET",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CEST",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0dc3\u0d9b\u0dbd\u0dd2\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SAKT",
               "\u0dc3\u0d9b\u0dbd\u0dd2\u0db1\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SAKST",
               "\u0dc3\u0d9b\u0dbd\u0dd2\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PYT",
               "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "PYST",
               "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EST",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EDT",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0dbd\u0ddd\u0dbb\u0dca\u0da9\u0dca \u0dc4\u0ddd\u0dc0\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "LHST",
               "\u0dbd\u0ddd\u0dbb\u0dca\u0da9\u0dca \u0dc4\u0ddd\u0dc0\u0dca \u0daf\u0dd2\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "LHDT",
               "\u0dbd\u0ddd\u0dbb\u0dca\u0da9\u0dca \u0dc4\u0ddd\u0dc0\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NZST",
               "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd2\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NZDT",
               "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0db1\u0dca \u0dc3\u0dcf\u0d9c\u0dbb \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0dba\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YAKT",
               "\u0dba\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YAKST",
               "\u0dba\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MUT",
               "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "MUST",
               "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0da7\u0dd2\u0db8\u0ddd\u0dbb\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0dc3\u0ddc\u0dbd\u0ddc\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0d9a\u0ddc\u0dc3\u0dca\u0dbb\u0dda \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0db8\u0dcf\u0dbb\u0dca\u0dc2\u0dbd\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EET",
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EEST",
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0db1\u0dd2\u0dc0\u0dca\u0dc6\u0dc0\u0dd4\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NST",
               "\u0db1\u0dd2\u0dc0\u0dca\u0dc6\u0dc0\u0dd4\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NDT",
               "\u0db1\u0dd2\u0dc0\u0dca\u0dc6\u0dc0\u0dd4\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HKT",
               "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HKST",
               "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ART",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "ARST",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0d85\u0dad\u0dca\u0dbd\u0dcf\u0db1\u0dca\u0dad\u0dd2\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AST",
               "\u0d85\u0dad\u0dca\u0dbd\u0dcf\u0db1\u0dca\u0dad\u0dd2\u0d9a\u0dca \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ADT",
               "\u0d85\u0dad\u0dca\u0dbd\u0dcf\u0db1\u0dca\u0dad\u0dd2\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u0db4\u0ddc\u0db1\u0db4\u0dda \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u0db6\u0ddc\u0dbd\u0dd2\u0dc0\u0dd2\u0dba\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PMST",
               "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PMDT",
               "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0da0\u0dd3\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0dba\u0dd9\u0d9a\u0da7\u0dd9\u0dbb\u0dd2\u0db1\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YEKT",
               "\u0dba\u0dd9\u0d9a\u0da7\u0dd9\u0dbb\u0dd2\u0db1\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YEKST",
               "\u0dba\u0dd9\u0d9a\u0da7\u0dd9\u0dbb\u0dd2\u0db1\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0db8\u0dcf\u0dbd\u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u0da7\u0dcf\u0dc4\u0dd2\u0da7\u0dd2 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IST",
               "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IDT",
               "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u0dc0\u0dd0\u0dbd\u0dd2\u0dc3\u0dca \u0dc3\u0dc4 \u0dc6\u0dd4\u0da7\u0dd4\u0db1\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0dc3\u0dca\u0dba\u0ddd\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0dbd\u0dba\u0dd2\u0db1\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "UZT",
               "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "UZST",
               "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0d94\u0db8\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "OMST",
               "\u0d94\u0db8\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "OMSST",
               "\u0d94\u0db8\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0dc3\u0dd3\u0dc2\u0dd9\u0dbd\u0dca\u0dc3\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "UYT",
               "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "UYST",
               "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0db1\u0dda\u0db4\u0dcf\u0dbd \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0d8b\u0dbd\u0dcf\u0db1\u0dca \u0db6\u0dcf\u0da7\u0dbb\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ULAT",
               "\u0d8b\u0dbd\u0dcf\u0db1\u0dca \u0db6\u0dcf\u0da7\u0dbb\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ULAST",
               "\u0d8b\u0dbd\u0dcf\u0db1\u0dca \u0db6\u0dcf\u0da7\u0dbb\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CST",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CDT",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0da0\u0dd4\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0db1\u0dd2\u0dba\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u0dc0\u0dda\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FKT",
               "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "FKST",
               "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u0dc0\u0db1\u0dd4\u0d86\u0da7\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VUT",
               "\u0dc0\u0db1\u0dd4\u0d86\u0da7\u0dd4 \u0d9c\u0dd2\u0db8\u0dca\u0dc4\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VUST",
               "\u0dc0\u0db1\u0dd4\u0d86\u0da7\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0db1\u0ddc\u0dc0\u0dc3\u0dd2\u0db6\u0dd2\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NOVT",
               "\u0db1\u0ddc\u0dc0\u0dc3\u0dd2\u0db6\u0dd2\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NOVST",
               "\u0db1\u0ddc\u0dc0\u0dc3\u0dd2\u0db6\u0dd2\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd4\u0dbb\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u0d87\u0dc3\u0ddc\u0dbb\u0dca\u0dc3\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZOT",
               "\u0d87\u0dc3\u0ddc\u0dbb\u0dca\u0dc3\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZOST",
               "\u0d87\u0dc3\u0ddc\u0dbb\u0dca\u0dc3\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u0d85\u0db4\u0dd2\u0dba\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WSST",
               "\u0d85\u0db4\u0dd2\u0dba\u0dcf \u0daf\u0dd2\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WSDT",
               "\u0d85\u0db4\u0dd2\u0dba\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u0db7\u0dd4\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0d9a\u0dca\u200d\u0dbb\u0dc3\u0dca\u0db1\u0ddc\u0dba\u0dcf\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KRAT",
               "\u0d9a\u0dca\u200d\u0dbb\u0dc3\u0dca\u0db1\u0ddc\u0dba\u0dcf\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KRAST",
               "\u0d9a\u0dca\u200d\u0dbb\u0dc3\u0dca\u0db1\u0ddc\u0dba\u0dcf\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0db8\u0dc3\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0d87\u0db8\u0dbb\u0dca\u0dc3\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AMT",
               "\u0d87\u0db8\u0dbb\u0dca\u0dc3\u0db1\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "AMST",
               "\u0d87\u0db8\u0dbb\u0dca\u0dc3\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u0dc6\u0dd2\u0da2\u0dd2 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FJT",
               "\u0dc6\u0dd2\u0da2\u0dd2 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FJST",
               "\u0dc6\u0dd2\u0da2\u0dd2 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0dbb\u0dd2\u0dba\u0dd4\u0db1\u0dd2\u0dba\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u0da0\u0dd0\u0dad\u0db8\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHAST",
               "\u0da0\u0dd0\u0dad\u0db8\u0dca \u0daf\u0dd2\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHADT",
               "\u0da0\u0dd0\u0dad\u0db8\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u0dc0\u0ddc\u0dc3\u0dca\u0da7\u0ddc\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ART",
               "\u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "ARST",
               "\u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dbb\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Tuvalu = new String[] {
               "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u0d9c\u0dbd\u0db4\u0d9c\u0ddc\u0dc3\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u0db8\u0dd0\u0d9a\u0dca\u0d9a\u0dd4\u0d85\u0dbb\u0dd2 \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2-\u0d85\u0dbd\u0dd9\u0dba\u0dd4\u0dad\u0dd2\u0dba\u0dcf\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HAST",
               "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2-\u0d85\u0dbd\u0dd9\u0dba\u0dd4\u0dad\u0dd2\u0dba\u0dcf\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HADT",
               "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2-\u0d85\u0dbd\u0dd9\u0dba\u0dd4\u0dad\u0dd2\u0dba\u0dcf\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACST",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACDT",
               "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PST",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PDT",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0dc6\u0dd3\u0db1\u0dd2\u0d9a\u0dca\u0dc3\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TMT",
               "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TMST",
               "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WET",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WEST",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0d9a\u0dda\u0db4\u0dca\u0dc0\u0dda\u0da9\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CVT",
               "\u0d9a\u0dda\u0db4\u0dca\u0dc0\u0dda\u0da9\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "CVST",
               "\u0d9a\u0dda\u0db4\u0dca\u0dc0\u0dda\u0da9\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0db1\u0ddc\u0dc6\u0ddc\u0dbd\u0dca\u0d9a\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u0d9c\u0dba\u0db1\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dcf\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0dbb\u0ddc\u0dad\u0dd9\u0dbb\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SST",
               "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "SDT",
               "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u0db4\u0dbd\u0dcf\u0dc0\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u0dad\u0dc0\u0dad\u0dca-\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZT",
               "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZST",
               "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u0db8\u0ddc\u0dc0\u0dca\u0dc3\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MST",
               "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MDT",
               "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0db4\u0dd0\u0dc3\u0dd2\u0dc6\u0dd2\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0da9\u0dcf\u0dc0\u0dd2\u0dc3\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CST",
               "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CDT",
               "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WAT",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "WAST",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da0\u0dca \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PHT",
               "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PHST",
               "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0dc3\u0dc4 \u0d87\u0db1\u0dca\u0da7\u0dcf\u0dbb\u0dca\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da2\u0ddd\u0da2\u0dd2\u0dba\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0db1\u0dc0 \u0dc3\u0dd9\u0dbd\u0da9\u0ddc\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NCT",
               "\u0db1\u0dc0 \u0dc3\u0dd9\u0dbd\u0da9\u0ddc\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NCST",
               "\u0db1\u0dc0 \u0dc3\u0dd9\u0dbd\u0da9\u0ddc\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u0db6\u0dd8\u0db1\u0dcf\u0dba\u0dd2 \u0daf\u0dbb\u0dd4\u0dc3\u0dca\u0dc3\u0dbd\u0dcf\u0db8\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0d89\u0dbb\u0dcf\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IRST",
               "\u0d89\u0dbb\u0dcf\u0db1 \u0daf\u0dd2\u0dc0\u0dcf \u0d9a\u0dcf\u0dbd\u0dba",
               "IRDT",
               "\u0d89\u0dbb\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0d8a\u0dc3\u0dca\u0da7\u0dbb\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EAST",
               "\u0d8a\u0dc3\u0dca\u0da7\u0dbb\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "EASST",
               "\u0d8a\u0dc3\u0dca\u0da7\u0dbb\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0dc0\u0dba\u0db9 \u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PST",
               "\u0dc0\u0dba\u0db9 \u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PDT",
               "\u0dc0\u0dba\u0db9 \u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0daf\u0dd4\u0db8\u0ddc\u0db1\u0dca\u0dad\u0dca-\u0da9\u0dca\u0d8b\u0dbb\u0dca\u0dc0\u0dd2\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u0da7\u0da2\u0dd2\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u0da7\u0ddc\u0d82\u0d9c\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TOT",
               "\u0da7\u0ddc\u0d82\u0d9c\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TOST",
               "\u0da7\u0ddc\u0d82\u0d9c\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u0db6\u0d82\u0d9c\u0dbd\u0dcf\u0daf\u0dda\u0dc1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BDT",
               "\u0db6\u0d82\u0d9c\u0dbd\u0dcf\u0daf\u0dda\u0dc1 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "BDST",
               "\u0db6\u0d82\u0d9c\u0dbd\u0dcf\u0daf\u0dda\u0dc1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u0db4\u0dda\u0dbb\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PET",
               "\u0db4\u0dda\u0dbb\u0dd4 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "PEST",
               "\u0db4\u0dda\u0dbb\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WGT",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "WGST",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EGT",
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "EGST",
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0d9c\u0dbd\u0dca\u0dc6\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KST",
               "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KDT",
               "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AWST",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AWDT",
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AEST",
               "\u0db1\u0dd0\u0d9f\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AEDT",
               "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0d9a\u0ddc\u0dbd\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "COT",
               "\u0d9a\u0ddc\u0dbd\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "COST",
               "\u0d9a\u0ddc\u0dbd\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0da0\u0dd2\u0dbd\u0dd3 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CLT",
               "\u0da0\u0dd2\u0dbd\u0dd3 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "CLST",
               "\u0da0\u0dd2\u0dbd\u0dd3 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0d9c\u0dd2\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da7\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9a\u0db3\u0dd4\u0d9a\u0dbb \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MST",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9a\u0db3\u0dd4\u0d9a\u0dbb \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MDT",
               "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9a\u0db3\u0dd4\u0d9a\u0dbb \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dd4\u0d91\u0dc3\u0dcf\u0dc3\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AST",
               "\u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ADT",
               "\u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0d87\u0dbd\u0dc3\u0dca\u0d9a\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AKST",
               "\u0d87\u0dbd\u0dc3\u0dca\u0d9a\u0dcf \u0daf\u0dd2\u0dc0\u0dcf\u0d86\u0dbd\u0ddd\u0d9a \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AKDT",
               "\u0d87\u0dbd\u0dc3\u0dca\u0d9a\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0dc0\u0dca\u0dbd\u0daf\u0dd2\u0dc0\u0ddd\u0dc3\u0dca\u0da7\u0ddd\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VLAT",
               "\u0dc0\u0dca\u0dbd\u0daf\u0dd2\u0dc0\u0ddd\u0dc3\u0dca\u0da7\u0ddd\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VLAST",
               "\u0dc0\u0dca\u0dbd\u0daf\u0dd2\u0dc0\u0ddd\u0dc3\u0dca\u0da7\u0ddd\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u0da0\u0db8\u0ddc\u0dbb\u0ddd \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0d89\u0dbb\u0dca\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IRKT",
               "\u0d89\u0dbb\u0dca\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IRKST",
               "\u0d89\u0dbb\u0dca\u0d9a\u0dd4\u0da7\u0dca\u0dc3\u0dca\u0d9a\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GET",
               "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GEST",
               "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u0da7\u0ddc\u0d9a\u0dd9\u0dbd\u0dcf\u0dc0\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd3\u0dba\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0dc6\u0dbb\u0dca\u0db1\u0dd0\u0db1\u0dca\u0da9\u0ddd \u0da9\u0dd2 \u0db1\u0ddc\u0dbb\u0ddc\u0db1\u0dca\u0dc4\u0dcf \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FNT",
               "\u0dc6\u0dbb\u0dca\u0db1\u0dd0\u0db1\u0dca\u0da9\u0ddd \u0da9\u0dd2 \u0db1\u0ddc\u0dbb\u0ddc\u0db1\u0dca\u0dc4\u0dcf \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "FNST",
               "\u0dc6\u0dbb\u0dca\u0db1\u0dd0\u0db1\u0dca\u0da9\u0ddd \u0da9\u0dd2 \u0db1\u0ddc\u0dbb\u0ddc\u0db1\u0dca\u0dc4\u0dcf \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0da0\u0ddc\u0dba\u0dd2\u0db6\u0dbd\u0dca\u0dc3\u0dcf\u0db1\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHOT",
               "\u0da0\u0ddc\u0dba\u0dd2\u0db6\u0dbd\u0dca\u0dc3\u0dcf\u0db1\u0dca \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHOST",
               "\u0da0\u0ddc\u0dba\u0dd2\u0db6\u0dbd\u0dca\u0dc3\u0dcf\u0db1\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BRT",
               "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0d9a\u0dcf\u0dbd\u0dba",
               "BRST",
               "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0da0\u0dd3\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CST",
               "\u0da0\u0dd3\u0db1 \u0daf\u0dc4\u0dc0\u0dbd\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CDT",
               "\u0da0\u0dd3\u0db1 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0d86\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AMT",
               "\u0d86\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AMST",
               "\u0d86\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "AMT",
            };
        final String[] India = new String[] {
               "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dca\u0db8\u0dad \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CKT",
               "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0db7\u0dcf\u0d9c \u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc2\u0dca\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CKHST",
               "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da0\u0dca \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
                    "GMT",
                    "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d9c\u0dd2\u0db8\u0dca\u0dc4\u0dcf\u0db1 \u0d9a\u0dcf\u0dbd\u0dba",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da0\u0dca \u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0dc0\u0dda\u0dbd\u0dcf\u0dc0",
                    "GMT",
                    "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad \u0d9c\u0dd2\u0db8\u0dca\u0dc4\u0dcf\u0db1 \u0d9a\u0dcf\u0dbd\u0dba",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
