/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static final Map<String, MessageDigest> CLONEABLE_DIGESTS = new HashMap<String, MessageDigest>(8, 1.0f);
    private static final String PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static Provider provider;
    private static final byte[] digits;

    private static Logger logger() {
        return LoggerFactory.getLogger(RubyDigest.class);
    }

    public static void createDigest(Ruby runtime) {
        try {
            provider = (Provider)Class.forName(PROVIDER).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RubyModule mDigest = runtime.defineModule("Digest");
        mDigest.defineAnnotatedMethods(RubyDigest.class);
        RubyModule mDigestInstance = mDigest.defineModuleUnder("Instance");
        mDigestInstance.defineAnnotatedMethods(DigestInstance.class);
        RubyClass cDigestClass = mDigest.defineClassUnder("Class", runtime.getObject(), DigestClass.DIGEST_CLASS_ALLOCATOR);
        cDigestClass.defineAnnotatedMethods(DigestClass.class);
        cDigestClass.includeModule(mDigestInstance);
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", cDigestClass, DigestBase.DIGEST_BASE_ALLOCATOR);
        cDigestBase.defineAnnotatedMethods(DigestBase.class);
    }

    private static MessageDigest createMessageDigest(String name2) throws NoSuchAlgorithmException {
        MessageDigest cloneable = CLONEABLE_DIGESTS.get(name2);
        if (cloneable != null) {
            try {
                return (MessageDigest)cloneable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (provider != null) {
            try {
                return MessageDigest.getInstance(name2, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(name2);
    }

    private static ByteList toHex(byte[] val) {
        ByteList byteList = new ByteList(val.length * 2);
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            int b2 = val[i2] & 0xFF;
            byteList.append(digits[b2 >> 4]);
            byteList.append(digits[b2 & 0xF]);
        }
        return byteList;
    }

    private static RubyString toHexString(Ruby runtime, byte[] val) {
        return RubyString.newStringNoCopy(runtime, new ByteList(ByteList.plain(RubyDigest.toHex(val)), USASCIIEncoding.INSTANCE));
    }

    @JRubyMethod(name={"hexencode"}, required=1, meta=true)
    public static RubyString hexencode(IRubyObject self2, IRubyObject arg2) {
        return RubyDigest.toHexString(self2.getRuntime(), arg2.convertToString().getBytes());
    }

    @JRubyMethod(name={"bubblebabble"}, required=1, meta=true)
    public static RubyString bubblebabble(IRubyObject recv2, IRubyObject arg2) {
        ByteList bytes2 = arg2.convertToString().getByteList();
        return RubyString.newString(recv2.getRuntime(), BubbleBabble.bubblebabble(bytes2.unsafeBytes(), bytes2.begin(), bytes2.length()));
    }

    public static void createDigestMD5(Ruby runtime) {
        runtime.getLoadService().require("digest");
        RubyModule Digest = runtime.getModule("Digest");
        RubyClass Base = Digest.getClass("Base");
        RubyClass MD52 = Digest.defineClassUnder("MD5", Base, Base.getAllocator());
        MD52.setInternalVariable("metadata", new Metadata("MD5", 64));
    }

    public static void createDigestRMD160(Ruby runtime) {
        runtime.getLoadService().require("digest");
        if (provider == null) {
            throw runtime.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule Digest = runtime.getModule("Digest");
        RubyClass Base = Digest.getClass("Base");
        RubyClass RMD1602 = Digest.defineClassUnder("RMD160", Base, Base.getAllocator());
        RMD1602.setInternalVariable("metadata", new Metadata("RIPEMD160", 64));
    }

    public static void createDigestSHA1(Ruby runtime) {
        runtime.getLoadService().require("digest");
        RubyModule Digest = runtime.getModule("Digest");
        RubyClass Base = Digest.getClass("Base");
        RubyClass SHA12 = Digest.defineClassUnder("SHA1", Base, Base.getAllocator());
        SHA12.setInternalVariable("metadata", new Metadata("SHA1", 64));
    }

    public static void createDigestSHA2(Ruby runtime) {
        runtime.getLoadService().require("digest");
        try {
            RubyDigest.createMessageDigest("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            RaiseException ex = runtime.newLoadError("SHA2 not supported");
            ex.initCause(e);
            throw ex;
        }
        RubyModule Digest = runtime.getModule("Digest");
        RubyClass Base = Digest.getClass("Base");
        RubyClass SHA2562 = Digest.defineClassUnder("SHA256", Base, Base.getAllocator());
        SHA2562.setInternalVariable("metadata", new Metadata("SHA-256", 64));
        RubyClass SHA3842 = Digest.defineClassUnder("SHA384", Base, Base.getAllocator());
        SHA3842.setInternalVariable("metadata", new Metadata("SHA-384", 128));
        RubyClass SHA5122 = Digest.defineClassUnder("SHA512", Base, Base.getAllocator());
        SHA5122.setInternalVariable("metadata", new Metadata("SHA-512", 128));
    }

    public static void createDigestBubbleBabble(Ruby runtime) {
        runtime.getLoadService().require("digest");
        RubyModule Digest = runtime.getModule("Digest");
        RubyClass Base = Digest.getClass("Base");
        RubyClass MD52 = Digest.defineClassUnder("BubbleBabble", Base, Base.getAllocator());
        MD52.setInternalVariable("metadata", new Metadata("BubbleBabble", 64));
    }

    static {
        for (String name2 : new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}) {
            try {
                MessageDigest digest2 = MessageDigest.getInstance(name2);
                digest2.clone();
                CLONEABLE_DIGESTS.put(name2, digest2);
            }
            catch (Exception e) {
                RubyDigest.logger().debug(name2 + " not clonable", e);
            }
        }
        provider = null;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    }

    @JRubyClass(name={"Digest::Base"})
    public static class DigestBase
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_BASE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new DigestBase(runtime, klass);
            }
        };
        private MessageDigest algo;
        private int blockLength = 0;

        public DigestBase(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
            if (type2 == runtime.getModule("Digest").getClass("Base")) {
                throw runtime.newNotImplementedError("Digest::Base is an abstract class");
            }
            Metadata metadata = this.getMetadata(type2);
            if (metadata == null) {
                throw runtime.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(metadata);
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
        }

        private Metadata getMetadata(RubyModule type2) {
            for (RubyModule current2 = type2; current2 != null; current2 = current2.getSuperClass()) {
                Metadata metadata = (Metadata)current2.getInternalVariable("metadata");
                if (metadata == null) continue;
                return metadata;
            }
            return null;
        }

        @Override
        @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            DigestBase from = (DigestBase)obj;
            from.checkFrozen();
            try {
                this.algo = (MessageDigest)from.algo.clone();
            }
            catch (CloneNotSupportedException e) {
                String name2 = from.algo.getAlgorithm();
                throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + name2 + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject obj) {
            ByteList bytes2 = obj.convertToString().getByteList();
            this.algo.update(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
            return this;
        }

        @JRubyMethod
        public IRubyObject finish() {
            RubyString digest2 = RubyString.newStringNoCopy(this.getRuntime(), this.algo.digest());
            this.algo.reset();
            return digest2;
        }

        @JRubyMethod
        public IRubyObject digest_length() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
        }

        @JRubyMethod
        public IRubyObject block_length() {
            if (this.blockLength == 0) {
                throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.blockLength);
        }

        @JRubyMethod
        public IRubyObject reset() {
            this.algo.reset();
            return this;
        }

        @JRubyMethod
        public IRubyObject bubblebabble(ThreadContext context) {
            byte[] digest2 = this.algo.digest();
            return RubyString.newString(context.runtime, BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        private void setAlgorithm(Metadata metadata) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(metadata.getName());
            this.blockLength = metadata.getBlockLength();
        }
    }

    @JRubyClass(name={"Digest::Class"})
    public static class DigestClass
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_CLASS_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new DigestClass(runtime, klass);
            }
        };

        public DigestClass(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        @JRubyMethod(name={"digest"}, required=1, rest=true, meta=true)
        public static IRubyObject s_digest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime = context.runtime;
            if (args2.length < 1) {
                throw runtime.newArgumentError("no data given");
            }
            RubyString str = args2[0].convertToString();
            args2 = ArraySupport.newCopy(args2, 1, args2.length - 1);
            IRubyObject obj = ((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
            return obj.callMethod(context, "digest", str);
        }

        @JRubyMethod(name={"hexdigest"}, required=1, optional=1, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime = recv2.getRuntime();
            byte[] digest2 = recv2.callMethod(context, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyDigest.toHexString(runtime, digest2);
        }

        @JRubyMethod(name={"bubblebabble"}, required=1, meta=true)
        public static RubyString bubblebabble(IRubyObject recv2, IRubyObject arg2) {
            byte[] digest2 = recv2.callMethod(recv2.getRuntime().getCurrentContext(), "digest", arg2).convertToString().getBytes();
            return RubyString.newString(recv2.getRuntime(), BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }
    }

    @JRubyModule(name={"Digest::Instance"})
    public static class DigestInstance {
        private static IRubyObject throwUnimplError(IRubyObject self2, String name2) {
            throw self2.getRuntime().newRuntimeError(String.format("%s does not implement %s()", self2.getMetaClass().getRealClass().getName(), name2));
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public static IRubyObject update(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return DigestInstance.throwUnimplError(self2, "update");
        }

        @JRubyMethod
        public static IRubyObject finish(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "finish");
        }

        @JRubyMethod
        public static IRubyObject reset(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.digest(context, self2, null).convertToString().bytesize();
        }

        @JRubyMethod
        public static IRubyObject block_length(ThreadContext context, IRubyObject self2) {
            return DigestInstance.throwUnimplError(self2, "block_length");
        }

        @JRubyMethod(name={"=="}, required=1)
        public static IRubyObject op_equal(ThreadContext context, IRubyObject self2, IRubyObject oth) {
            RubyString str2;
            RubyString str1;
            if (oth.isNil()) {
                return context.runtime.getFalse();
            }
            RubyModule instance = (RubyModule)context.runtime.getModule("Digest").getConstantAt("Instance");
            if (oth.getMetaClass().getRealClass().hasModuleInHierarchy(instance)) {
                str1 = DigestInstance.digest(context, self2, null).convertToString();
                str2 = DigestInstance.digest(context, oth, null).convertToString();
            } else {
                str1 = DigestInstance.to_s(context, self2).convertToString();
                str2 = oth.convertToString();
            }
            boolean ret = str1.bytesize().eql(str2.bytesize()) && str1.eql(str2);
            return ret ? context.runtime.getTrue() : context.runtime.getFalse();
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            return RubyString.newStringNoCopy(self2.getRuntime(), ByteList.plain("#<" + self2.getMetaClass().getRealClass().getName() + ": " + DigestInstance.hexdigest(context, self2, null) + ">"));
        }

        @JRubyMethod(name={"new"})
        public static IRubyObject newObject(ThreadContext context, IRubyObject self2) {
            return self2.rbClone().callMethod(context, "reset");
        }

        @JRubyMethod(optional=1)
        public static IRubyObject digest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            IRubyObject value2;
            if (args2 != null && args2.length > 0) {
                self2.callMethod(context, "reset");
                self2.callMethod(context, "update", args2[0]);
                value2 = self2.callMethod(context, "finish");
                self2.callMethod(context, "reset");
            } else {
                IRubyObject clone2 = self2.rbClone();
                value2 = clone2.callMethod(context, "finish");
                clone2.callMethod(context, "reset");
            }
            return value2;
        }

        @JRubyMethod(name={"digest!"})
        public static IRubyObject digest_bang(ThreadContext context, IRubyObject self2) {
            IRubyObject value2 = self2.callMethod(context, "finish");
            self2.callMethod(context, "reset");
            return value2;
        }

        @JRubyMethod(optional=1)
        public static IRubyObject hexdigest(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return RubyDigest.toHexString(context.runtime, DigestInstance.digest(context, self2, args2).convertToString().getBytes());
        }

        @JRubyMethod(name={"hexdigest!"})
        public static IRubyObject hexdigest_bang(ThreadContext context, IRubyObject self2) {
            return RubyDigest.toHexString(context.runtime, DigestInstance.digest_bang(context, self2).convertToString().getBytes());
        }

        @JRubyMethod(name={"bubblebabble"}, required=1, optional=1, meta=true)
        public static IRubyObject bubblebabble(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            byte[] digest2 = recv2.callMethod(context, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyString.newString(recv2.getRuntime(), BubbleBabble.bubblebabble(digest2, 0, digest2.length));
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return self2.callMethod(context, "hexdigest");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext context, IRubyObject self2) {
            return self2.callMethod(context, "digest_length");
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }

    private static class Metadata {
        private final String name;
        private final int blockLength;

        Metadata(String name2, int blockLength) {
            this.name = name2;
            this.blockLength = blockLength;
        }

        String getName() {
            return this.name;
        }

        int getBlockLength() {
            return this.blockLength;
        }
    }
}

