/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaUtilRegex {
    public static void define(Ruby runtime) {
        Pattern.define(runtime);
        Matcher.define(runtime);
    }

    @JRubyClass(name={"Java::JavaUtilRegex::Matcher"})
    public static class Matcher {
        private static final Method startMethod;
        private static final Method endMethod;

        static RubyClass define(Ruby runtime) {
            RubyModule Matcher2 = Java.getProxyClass(runtime, java.util.regex.Matcher.class);
            Matcher2.defineAnnotatedMethods(Matcher.class);
            return (RubyClass)Matcher2;
        }

        @JRubyMethod
        public static IRubyObject regexp(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, matcher.pattern());
        }

        @JRubyMethod
        public static IRubyObject begin(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                return context.runtime.newFixnum(Matcher.matcherStart(matcher, idx.toString()));
            }
            int group2 = idx.convertToInteger().getIntValue();
            return context.runtime.newFixnum(matcher.start(group2));
        }

        @JRubyMethod
        public static IRubyObject end(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                return context.runtime.newFixnum(Matcher.matcherEnd(matcher, idx.toString()));
            }
            int group2 = idx.convertToInteger().getIntValue();
            return context.runtime.newFixnum(matcher.end(group2));
        }

        @JRubyMethod
        public static IRubyObject offset(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            RubyFixnum end2;
            RubyFixnum beg;
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                beg = context.runtime.newFixnum(Matcher.matcherStart(matcher, idx.toString()));
                end2 = context.runtime.newFixnum(Matcher.matcherEnd(matcher, idx.toString()));
            } else {
                int group2 = idx.convertToInteger().getIntValue();
                beg = context.runtime.newFixnum(matcher.start(group2));
                end2 = context.runtime.newFixnum(matcher.end(group2));
            }
            return RubyArray.newArray(context.runtime, beg, end2);
        }

        @JRubyMethod(name={"length", "size"})
        public static RubyFixnum size(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return context.runtime.newFixnum(matcher.groupCount() + 1);
        }

        @JRubyMethod
        public static RubyString string(ThreadContext context, IRubyObject self2) {
            return Matcher.str(context, self2);
        }

        private static RubyString str(ThreadContext context, IRubyObject self2) {
            IRubyObject str = (IRubyObject)self2.getInternalVariables().getInternalVariable("str");
            return str.convertToString();
        }

        @JRubyMethod
        public static IRubyObject pre_match(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return Matcher.str(context, self2).substr(context.runtime, 0, matcher.start(0));
        }

        @JRubyMethod
        public static IRubyObject post_match(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            RubyString str = Matcher.str(context, self2);
            int offset2 = matcher.end(0);
            return str.substr(context.runtime, offset2, str.size() - offset2);
        }

        @JRubyMethod
        public static RubyArray to_a(ThreadContext context, IRubyObject self2) {
            return RubyArray.newArrayMayCopy(context.runtime, Matcher.groups(context, self2, 0));
        }

        @JRubyMethod
        public static RubyArray captures(ThreadContext context, IRubyObject self2) {
            return RubyArray.newArrayMayCopy(context.runtime, Matcher.groups(context, self2, 1));
        }

        private static IRubyObject[] groups(ThreadContext context, IRubyObject self2, int off) {
            Ruby runtime = context.runtime;
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            IRubyObject[] arr = new IRubyObject[matcher.groupCount() - off + 1];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                arr[i2] = matcher.start(i2 + off) == -1 ? context.nil : runtime.newString(matcher.group(i2 + off));
            }
            return arr;
        }

        @JRubyMethod(name={"[]"}, required=1)
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol || idx instanceof RubyString) {
                return context.runtime.newString(matcher.group(idx.toString()));
            }
            if (idx instanceof RubyInteger) {
                int group2 = ((RubyInteger)idx).getIntValue();
                return context.runtime.newString(matcher.group(group2));
            }
            return Matcher.to_a(context, self2).aref(idx);
        }

        @JRubyMethod(name={"[]"}, required=2)
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1) {
            return Matcher.to_a(context, self2).aref(arg0, arg1);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject values_at(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return Matcher.to_a(context, self2).values_at(args2);
        }

        private static Integer matcherStart(java.util.regex.Matcher matcher, String group2) {
            if (startMethod == null) {
                throw new UnsupportedOperationException("start(String) only works on Java 8+");
            }
            return Matcher.invoke(startMethod, matcher, group2);
        }

        private static Integer matcherEnd(java.util.regex.Matcher matcher, String group2) {
            if (endMethod == null) {
                throw new UnsupportedOperationException("end(String) only works on Java 8+");
            }
            return Matcher.invoke(endMethod, matcher, group2);
        }

        private static Integer invoke(Method method, java.util.regex.Matcher matcher, String group2) {
            try {
                return (Integer)method.invoke((Object)matcher, group2);
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
            catch (InvocationTargetException e) {
                Helpers.throwException(e.getTargetException());
                return null;
            }
        }

        static {
            Method end2;
            Method start2;
            try {
                start2 = java.util.regex.Matcher.class.getMethod("start", String.class);
                end2 = java.util.regex.Matcher.class.getMethod("end", String.class);
            }
            catch (NoSuchMethodException e) {
                end2 = null;
                start2 = null;
            }
            startMethod = start2;
            endMethod = end2;
        }
    }

    @JRubyClass(name={"Java::JavaUtilRegex::Pattern"})
    public static class Pattern {
        static RubyClass define(Ruby runtime) {
            RubyModule Pattern2 = Java.getProxyClass(runtime, java.util.regex.Pattern.class);
            Pattern2.defineAnnotatedMethods(Pattern.class);
            return (RubyClass)Pattern2;
        }

        @JRubyMethod(name={"=~"}, required=1)
        public static IRubyObject op_match(ThreadContext context, IRubyObject self2, IRubyObject str) {
            java.util.regex.Matcher matcher = Pattern.matcher(self2, str);
            return matcher.find() ? context.runtime.newFixnum(matcher.start()) : context.nil;
        }

        @JRubyMethod(name={"match"}, required=1)
        public static IRubyObject match(ThreadContext context, IRubyObject self2, IRubyObject str) {
            java.util.regex.Matcher matcher = Pattern.matcher(self2, str);
            if (!matcher.find()) {
                return context.nil;
            }
            RubyObject matcherProxy = (RubyObject)JavaUtil.convertJavaToUsableRubyObject(context.runtime, matcher);
            matcherProxy.setInternalVariable("str", str);
            return matcherProxy;
        }

        @JRubyMethod(name={"==="}, required=1)
        public static IRubyObject eqq(ThreadContext context, IRubyObject self2, IRubyObject str) {
            return context.runtime.newBoolean(Pattern.matcher(self2, str).find());
        }

        @JRubyMethod(name={"casefold?"})
        public static IRubyObject casefold_p(ThreadContext context, IRubyObject self2) {
            java.util.regex.Pattern regex = (java.util.regex.Pattern)JavaUtil.unwrapJavaObject(self2);
            boolean i2 = (regex.flags() & 2) != 0;
            return context.runtime.newBoolean(i2);
        }

        private static java.util.regex.Matcher matcher(IRubyObject self2, IRubyObject str) {
            java.util.regex.Pattern regex = (java.util.regex.Pattern)JavaUtil.unwrapJavaObject(self2);
            return regex.matcher((CharSequence)str.toJava(CharSequence.class));
        }
    }
}

