// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Instrumentation.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Instrumentation_h__
#define __Ice_Instrumentation_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/EndpointF.h>
#include <Ice/ConnectionF.h>
#include <Ice/Current.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{


namespace Instrumentation
{

class Observer;
class ThreadObserver;
class ConnectionObserver;
class DispatchObserver;
class ChildInvocationObserver;
class RemoteObserver;
class CollocatedObserver;
class InvocationObserver;
class ObserverUpdater;
class CommunicatorObserver;

}

}

namespace Ice
{

namespace Instrumentation
{

enum class ThreadState : unsigned char
{
    ThreadStateIdle,
    ThreadStateInUseForIO,
    ThreadStateInUseForUser,
    ThreadStateInUseForOther
};

enum class ConnectionState : unsigned char
{
    ConnectionStateValidating,
    ConnectionStateHolding,
    ConnectionStateActive,
    ConnectionStateClosing,
    ConnectionStateClosed
};

}

}

namespace Ice
{

namespace Instrumentation
{

class ICE_CLASS(ICE_API) Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~Observer();

    virtual void attach() = 0;

    virtual void detach() = 0;

    virtual void failed(const ::std::string&) = 0;
};

class ICE_CLASS(ICE_API) ThreadObserver : public virtual ::Ice::Instrumentation::Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~ThreadObserver();

    virtual void stateChanged(::Ice::Instrumentation::ThreadState, ::Ice::Instrumentation::ThreadState) = 0;
};

class ICE_CLASS(ICE_API) ConnectionObserver : public virtual ::Ice::Instrumentation::Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionObserver();

    virtual void sentBytes(int) = 0;

    virtual void receivedBytes(int) = 0;
};

class ICE_CLASS(ICE_API) DispatchObserver : public virtual ::Ice::Instrumentation::Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~DispatchObserver();

    virtual void userException() = 0;

    virtual void reply(int) = 0;
};

class ICE_CLASS(ICE_API) ChildInvocationObserver : public virtual ::Ice::Instrumentation::Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~ChildInvocationObserver();

    virtual void reply(int) = 0;
};

class ICE_CLASS(ICE_API) RemoteObserver : public virtual ::Ice::Instrumentation::ChildInvocationObserver
{
public:

    ICE_MEMBER(ICE_API) virtual ~RemoteObserver();
};

class ICE_CLASS(ICE_API) CollocatedObserver : public virtual ::Ice::Instrumentation::ChildInvocationObserver
{
public:

    ICE_MEMBER(ICE_API) virtual ~CollocatedObserver();
};

class ICE_CLASS(ICE_API) InvocationObserver : public virtual ::Ice::Instrumentation::Observer
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvocationObserver();

    virtual void retried() = 0;

    virtual void userException() = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::RemoteObserver> getRemoteObserver(const ::std::shared_ptr<::Ice::ConnectionInfo>&, const ::std::shared_ptr<::Ice::Endpoint>&, int, int) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::CollocatedObserver> getCollocatedObserver(const ::std::shared_ptr<::Ice::ObjectAdapter>&, int, int) = 0;
};

class ICE_CLASS(ICE_API) ObserverUpdater
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObserverUpdater();

    virtual void updateConnectionObservers() = 0;

    virtual void updateThreadObservers() = 0;
};

class ICE_CLASS(ICE_API) CommunicatorObserver
{
public:

    ICE_MEMBER(ICE_API) virtual ~CommunicatorObserver();

    virtual ::std::shared_ptr<::Ice::Instrumentation::Observer> getConnectionEstablishmentObserver(const ::std::shared_ptr<::Ice::Endpoint>&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::Observer> getEndpointLookupObserver(const ::std::shared_ptr<::Ice::Endpoint>&) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::ConnectionObserver> getConnectionObserver(const ::std::shared_ptr<::Ice::ConnectionInfo>&, const ::std::shared_ptr<::Ice::Endpoint>&, ::Ice::Instrumentation::ConnectionState, const ::std::shared_ptr<::Ice::Instrumentation::ConnectionObserver>&) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::ThreadObserver> getThreadObserver(const ::std::string&, const ::std::string&, ::Ice::Instrumentation::ThreadState, const ::std::shared_ptr<::Ice::Instrumentation::ThreadObserver>&) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::InvocationObserver> getInvocationObserver(const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&, const ::Ice::Context&) = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::DispatchObserver> getDispatchObserver(const ::Ice::Current&, int) = 0;

    virtual void setObserverUpdater(const ::std::shared_ptr<::Ice::Instrumentation::ObserverUpdater>&) = 0;
};

}

}

namespace Ice
{

}

namespace Ice
{

namespace Instrumentation
{

using ObserverPtr = ::std::shared_ptr<Observer>;

using ThreadObserverPtr = ::std::shared_ptr<ThreadObserver>;

using ConnectionObserverPtr = ::std::shared_ptr<ConnectionObserver>;

using DispatchObserverPtr = ::std::shared_ptr<DispatchObserver>;

using ChildInvocationObserverPtr = ::std::shared_ptr<ChildInvocationObserver>;

using RemoteObserverPtr = ::std::shared_ptr<RemoteObserver>;

using CollocatedObserverPtr = ::std::shared_ptr<CollocatedObserver>;

using InvocationObserverPtr = ::std::shared_ptr<InvocationObserver>;

using ObserverUpdaterPtr = ::std::shared_ptr<ObserverUpdater>;

using CommunicatorObserverPtr = ::std::shared_ptr<CommunicatorObserver>;

}

}

#else // C++98 mapping

namespace Ice
{

namespace Instrumentation
{

class Observer;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::Observer*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::Observer> ObserverPtr;

class ThreadObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::ThreadObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::ThreadObserver> ThreadObserverPtr;

class ConnectionObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::ConnectionObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::ConnectionObserver> ConnectionObserverPtr;

class DispatchObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::DispatchObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::DispatchObserver> DispatchObserverPtr;

class ChildInvocationObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::ChildInvocationObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::ChildInvocationObserver> ChildInvocationObserverPtr;

class RemoteObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::RemoteObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::RemoteObserver> RemoteObserverPtr;

class CollocatedObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::CollocatedObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::CollocatedObserver> CollocatedObserverPtr;

class InvocationObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::InvocationObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::InvocationObserver> InvocationObserverPtr;

class ObserverUpdater;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::ObserverUpdater*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::ObserverUpdater> ObserverUpdaterPtr;

class CommunicatorObserver;
ICE_API ::Ice::LocalObject* upCast(::Ice::Instrumentation::CommunicatorObserver*);
typedef ::IceInternal::Handle< ::Ice::Instrumentation::CommunicatorObserver> CommunicatorObserverPtr;

}

}

namespace Ice
{

namespace Instrumentation
{

enum ThreadState
{
    ThreadStateIdle,
    ThreadStateInUseForIO,
    ThreadStateInUseForUser,
    ThreadStateInUseForOther
};

enum ConnectionState
{
    ConnectionStateValidating,
    ConnectionStateHolding,
    ConnectionStateActive,
    ConnectionStateClosing,
    ConnectionStateClosed
};

}

}

namespace Ice
{

namespace Instrumentation
{

class ICE_API Observer : public virtual ::Ice::LocalObject
{
public:

    typedef ObserverPtr PointerType;

    virtual ~Observer();

    virtual void attach() = 0;

    virtual void detach() = 0;

    virtual void failed(const ::std::string&) = 0;
};

inline bool operator==(const Observer& lhs, const Observer& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Observer& lhs, const Observer& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API ThreadObserver : virtual public ::Ice::Instrumentation::Observer
{
public:

    typedef ThreadObserverPtr PointerType;

    virtual ~ThreadObserver();

    virtual void stateChanged(::Ice::Instrumentation::ThreadState, ::Ice::Instrumentation::ThreadState) = 0;
};

inline bool operator==(const ThreadObserver& lhs, const ThreadObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ThreadObserver& lhs, const ThreadObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API ConnectionObserver : virtual public ::Ice::Instrumentation::Observer
{
public:

    typedef ConnectionObserverPtr PointerType;

    virtual ~ConnectionObserver();

    virtual void sentBytes(::Ice::Int) = 0;

    virtual void receivedBytes(::Ice::Int) = 0;
};

inline bool operator==(const ConnectionObserver& lhs, const ConnectionObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ConnectionObserver& lhs, const ConnectionObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API DispatchObserver : virtual public ::Ice::Instrumentation::Observer
{
public:

    typedef DispatchObserverPtr PointerType;

    virtual ~DispatchObserver();

    virtual void userException() = 0;

    virtual void reply(::Ice::Int) = 0;
};

inline bool operator==(const DispatchObserver& lhs, const DispatchObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const DispatchObserver& lhs, const DispatchObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API ChildInvocationObserver : virtual public ::Ice::Instrumentation::Observer
{
public:

    typedef ChildInvocationObserverPtr PointerType;

    virtual ~ChildInvocationObserver();

    virtual void reply(::Ice::Int) = 0;
};

inline bool operator==(const ChildInvocationObserver& lhs, const ChildInvocationObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ChildInvocationObserver& lhs, const ChildInvocationObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API RemoteObserver : virtual public ::Ice::Instrumentation::ChildInvocationObserver
{
public:

    typedef RemoteObserverPtr PointerType;

    virtual ~RemoteObserver();
};

inline bool operator==(const RemoteObserver& lhs, const RemoteObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const RemoteObserver& lhs, const RemoteObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API CollocatedObserver : virtual public ::Ice::Instrumentation::ChildInvocationObserver
{
public:

    typedef CollocatedObserverPtr PointerType;

    virtual ~CollocatedObserver();
};

inline bool operator==(const CollocatedObserver& lhs, const CollocatedObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const CollocatedObserver& lhs, const CollocatedObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API InvocationObserver : virtual public ::Ice::Instrumentation::Observer
{
public:

    typedef InvocationObserverPtr PointerType;

    virtual ~InvocationObserver();

    virtual void retried() = 0;

    virtual void userException() = 0;

    virtual ::Ice::Instrumentation::RemoteObserverPtr getRemoteObserver(const ::Ice::ConnectionInfoPtr&, const ::Ice::EndpointPtr&, ::Ice::Int, ::Ice::Int) = 0;

    virtual ::Ice::Instrumentation::CollocatedObserverPtr getCollocatedObserver(const ::Ice::ObjectAdapterPtr&, ::Ice::Int, ::Ice::Int) = 0;
};

inline bool operator==(const InvocationObserver& lhs, const InvocationObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const InvocationObserver& lhs, const InvocationObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API ObserverUpdater : public virtual ::Ice::LocalObject
{
public:

    typedef ObserverUpdaterPtr PointerType;

    virtual ~ObserverUpdater();

    virtual void updateConnectionObservers() = 0;

    virtual void updateThreadObservers() = 0;
};

inline bool operator==(const ObserverUpdater& lhs, const ObserverUpdater& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const ObserverUpdater& lhs, const ObserverUpdater& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

class ICE_API CommunicatorObserver : public virtual ::Ice::LocalObject
{
public:

    typedef CommunicatorObserverPtr PointerType;

    virtual ~CommunicatorObserver();

    virtual ::Ice::Instrumentation::ObserverPtr getConnectionEstablishmentObserver(const ::Ice::EndpointPtr&, const ::std::string&) = 0;

    virtual ::Ice::Instrumentation::ObserverPtr getEndpointLookupObserver(const ::Ice::EndpointPtr&) = 0;

    virtual ::Ice::Instrumentation::ConnectionObserverPtr getConnectionObserver(const ::Ice::ConnectionInfoPtr&, const ::Ice::EndpointPtr&, ::Ice::Instrumentation::ConnectionState, const ::Ice::Instrumentation::ConnectionObserverPtr&) = 0;

    virtual ::Ice::Instrumentation::ThreadObserverPtr getThreadObserver(const ::std::string&, const ::std::string&, ::Ice::Instrumentation::ThreadState, const ::Ice::Instrumentation::ThreadObserverPtr&) = 0;

    virtual ::Ice::Instrumentation::InvocationObserverPtr getInvocationObserver(const ::Ice::ObjectPrx&, const ::std::string&, const ::Ice::Context&) = 0;

    virtual ::Ice::Instrumentation::DispatchObserverPtr getDispatchObserver(const ::Ice::Current&, ::Ice::Int) = 0;

    virtual void setObserverUpdater(const ::Ice::Instrumentation::ObserverUpdaterPtr&) = 0;
};

inline bool operator==(const CommunicatorObserver& lhs, const CommunicatorObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const CommunicatorObserver& lhs, const CommunicatorObserver& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

}

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
