/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.tools.SuppressForbidden;

final class JavaVersionChecker {
    private static final List<Integer> JAVA_8 = Arrays.asList(1, 8);

    private JavaVersionChecker() {
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            throw new IllegalArgumentException("expected zero arguments but was: " + Arrays.toString(args));
        }
        String javaSpecificationVersion = System.getProperty("java.specification.version");
        List<Integer> current = JavaVersionChecker.parse(javaSpecificationVersion);
        if (JavaVersionChecker.compare(current, JAVA_8) < 0) {
            String message = String.format(Locale.ROOT, "the minimum required Java version is 8; your Java version from [%s] does not meet this requirement", System.getProperty("java.home"));
            JavaVersionChecker.println(message);
            JavaVersionChecker.exit(1);
        }
        JavaVersionChecker.exit(0);
    }

    private static List<Integer> parse(String value) {
        String[] components;
        if (!value.matches("^0*[0-9]+(\\.[0-9]+)*$")) {
            throw new IllegalArgumentException(value);
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        for (String component : components = value.split("\\.")) {
            version.add(Integer.valueOf(component));
        }
        return version;
    }

    private static int compare(List<Integer> left, List<Integer> right) {
        int len = Math.max(left.size(), right.size());
        for (int i = 0; i < len; ++i) {
            int r;
            int l = i < left.size() ? left.get(i) : 0;
            int n = r = i < right.size() ? right.get(i) : 0;
            if (l < r) {
                return -1;
            }
            if (r >= l) continue;
            return 1;
        }
        return 0;
    }

    @SuppressForbidden(reason="System#err")
    private static void println(String message) {
        System.err.println(message);
    }

    @SuppressForbidden(reason="System#exit")
    private static void exit(int status) {
        System.exit(status);
    }
}

