/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Circle;

public class CircleBuilder
extends ShapeBuilder {
    public static final String FIELD_RADIUS = "radius";
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.CIRCLE;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private double radius;
    private Coordinate center;

    public CircleBuilder() {
        this.center = ZERO_ZERO;
    }

    public CircleBuilder(StreamInput in) throws IOException {
        this.center(CircleBuilder.readFromStream(in));
        this.radius(in.readDouble(), DistanceUnit.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        CircleBuilder.writeCoordinateTo(this.center, out);
        out.writeDouble(this.radius);
        this.unit.writeTo(out);
    }

    public CircleBuilder center(Coordinate center) {
        this.center = center;
        return this;
    }

    public CircleBuilder center(double lon, double lat) {
        return this.center(new Coordinate(lon, lat));
    }

    public Coordinate center() {
        return this.center;
    }

    public CircleBuilder radius(String radius) {
        return this.radius(DistanceUnit.Distance.parseDistance(radius));
    }

    public CircleBuilder radius(DistanceUnit.Distance radius) {
        return this.radius(radius.value, radius.unit);
    }

    public CircleBuilder radius(double radius, String unit) {
        return this.radius(radius, DistanceUnit.fromString(unit));
    }

    public CircleBuilder radius(double radius, DistanceUnit unit) {
        this.unit = unit;
        this.radius = radius;
        return this;
    }

    public double radius() {
        return this.radius;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field(FIELD_RADIUS, this.unit.toString(this.radius));
        builder.field("coordinates");
        CircleBuilder.toXContent(builder, this.center);
        return builder.endObject();
    }

    public Circle build() {
        return SPATIAL_CONTEXT.makeCircle(this.center.x, this.center.y, 360.0 * this.radius / this.unit.getEarthCircumference());
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    public int hashCode() {
        return Objects.hash(this.center, this.radius, this.unit.ordinal());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CircleBuilder other = (CircleBuilder)obj;
        return Objects.equals(this.center, other.center) && Objects.equals(this.radius, other.radius) && Objects.equals(this.unit.ordinal(), other.unit.ordinal());
    }
}

