/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private final ShardId shardId;
    private final Logger logger;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<ActionListener<Releasable>> delayedOperations = new ArrayList<ActionListener<Releasable>>();
    private volatile boolean closed;
    private boolean delayed;

    IndexShardOperationPermits(ShardId shardId, Logger logger, ThreadPool threadPool) {
        this.shardId = shardId;
        this.logger = logger;
        this.threadPool = threadPool;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void blockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        this.delayOperations();
        try {
            this.doBlockOperations(timeout, timeUnit, onBlocked);
        }
        finally {
            this.releaseDelayedOperations();
        }
    }

    <E extends Exception> void asyncBlockOperations(final long timeout, final TimeUnit timeUnit, final CheckedRunnable<E> onBlocked, final Consumer<Exception> onFailure) {
        this.delayOperations();
        this.threadPool.executor("generic").execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }

            @Override
            protected void doRun() throws Exception {
                IndexShardOperationPermits.this.doBlockOperations(timeout, timeUnit, onBlocked);
            }

            @Override
            public void onAfter() {
                IndexShardOperationPermits.this.releaseDelayedOperations();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            if (this.delayed) {
                throw new IllegalStateException("operations are already delayed");
            }
            assert (this.delayedOperations.isEmpty());
            this.delayed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Exception> void doBlockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.delayed);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            assert (this.semaphore.availablePermits() == 0);
            try {
                onBlocked.run();
            }
            finally {
                this.semaphore.release(Integer.MAX_VALUE);
            }
        } else {
            throw new TimeoutException("timeout while blocking operations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        ArrayList<ActionListener<Releasable>> queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.delayed);
            queuedActions = new ArrayList<ActionListener<Releasable>>(this.delayedOperations);
            this.delayedOperations.clear();
            this.delayed = false;
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (ActionListener queuedAction : queuedActions) {
                    this.acquire(queuedAction, null, false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.delayed) {
                    Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(false);
                    if (executorOnDelay != null) {
                        this.delayedOperations.add(new PermitAwareThreadedActionListener(this.threadPool, executorOnDelay, new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired), forceExecution));
                    } else {
                        this.delayedOperations.add(new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired));
                    }
                    return;
                }
                releasable = this.acquire();
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire() throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            return () -> {
                if (closed.compareAndSet(false, true)) {
                    this.semaphore.release(1);
                }
            };
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return 0;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    private static class PermitAwareThreadedActionListener
    implements ActionListener<Releasable> {
        private final ThreadPool threadPool;
        private final String executor;
        private final ActionListener<Releasable> listener;
        private final boolean forceExecution;

        private PermitAwareThreadedActionListener(ThreadPool threadPool, String executor, ActionListener<Releasable> listener, boolean forceExecution) {
            this.threadPool = threadPool;
            this.executor = executor;
            this.listener = listener;
            this.forceExecution = forceExecution;
        }

        @Override
        public void onResponse(final Releasable releasable) {
            this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

                @Override
                public boolean isForceExecution() {
                    return forceExecution;
                }

                @Override
                protected void doRun() throws Exception {
                    listener.onResponse(releasable);
                }

                @Override
                public void onRejection(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releasable});
                    super.onRejection(e);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

