/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptedMetricAggregatorFactory
extends AggregatorFactory<ScriptedMetricAggregatorFactory> {
    private final SearchScript.Factory mapScript;
    private final ExecutableScript.Factory combineScript;
    private final Script reduceScript;
    private final Map<String, Object> params;
    private final SearchLookup lookup;
    private final ExecutableScript.Factory initScript;

    public ScriptedMetricAggregatorFactory(String name, SearchScript.Factory mapScript, ExecutableScript.Factory initScript, ExecutableScript.Factory combineScript, Script reduceScript, Map<String, Object> params, SearchLookup lookup, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.mapScript = mapScript;
        this.initScript = initScript;
        this.combineScript = combineScript;
        this.reduceScript = reduceScript;
        this.lookup = lookup;
        this.params = params;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return ScriptedMetricAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        Map<String, Object> params = this.params;
        params = params != null ? ScriptedMetricAggregatorFactory.deepCopyParams(params, this.context) : new HashMap<String, Object>();
        if (!params.containsKey("_agg")) {
            params.put("_agg", new HashMap());
        }
        ExecutableScript initScript = this.initScript.newInstance(params);
        SearchScript.LeafFactory mapScript = this.mapScript.newFactory(params, this.lookup);
        ExecutableScript combineScript = this.combineScript.newInstance(params);
        Script reduceScript = ScriptedMetricAggregatorFactory.deepCopyScript(this.reduceScript, this.context);
        if (initScript != null) {
            initScript.run();
        }
        return new ScriptedMetricAggregator(this.name, mapScript, combineScript, reduceScript, params, this.context, parent, pipelineAggregators, metaData);
    }

    private static Script deepCopyScript(Script script, SearchContext context) {
        if (script != null) {
            Map<String, Object> params = script.getParams();
            if (params != null) {
                params = ScriptedMetricAggregatorFactory.deepCopyParams(params, context);
            }
            return new Script(script.getType(), script.getLang(), script.getIdOrCode(), params);
        }
        return null;
    }

    private static <T> T deepCopyParams(T original, SearchContext context) {
        Object clone;
        if (original instanceof Map) {
            Map originalMap = (Map)original;
            HashMap clonedMap = new HashMap();
            for (Map.Entry e : originalMap.entrySet()) {
                clonedMap.put(ScriptedMetricAggregatorFactory.deepCopyParams(e.getKey(), context), ScriptedMetricAggregatorFactory.deepCopyParams(e.getValue(), context));
            }
            clone = clonedMap;
        } else if (original instanceof List) {
            List originalList = (List)original;
            ArrayList clonedList = new ArrayList();
            for (Object o : originalList) {
                clonedList.add(ScriptedMetricAggregatorFactory.deepCopyParams(o, context));
            }
            clone = clonedList;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
            clone = original;
        } else {
            throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
        }
        return clone;
    }
}

