/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.status.StatusLogger;

public class StoreConfiguration<T> {
    protected static final StatusLogger LOGGER = StatusLogger.getLogger();
    private String location;
    private char[] password;

    public StoreConfiguration(String location, char[] password) {
        this.location = location;
        this.password = password;
    }

    public void clearSecrets() {
        this.location = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }

    @Deprecated
    public StoreConfiguration(String location, String password) {
        this.location = location;
        this.password = password == null ? null : password.toCharArray();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Deprecated
    public String getPassword() {
        return String.valueOf(this.password);
    }

    public char[] getPasswordAsCharArray() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password == null ? null : password.toCharArray();
    }

    protected T load() throws StoreConfigurationException {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + Arrays.hashCode(this.password);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreConfiguration other = (StoreConfiguration)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return Arrays.equals(this.password, other.password);
    }
}

