/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import tim.prune.I18nManager;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;

public class PhotoTableEntry {
    private Photo _photo = null;
    private String _photoName = null;
    private boolean _save = true;
    private String _status = null;

    public PhotoTableEntry(Photo photo) {
        this._photo = photo;
        if (photo != null) {
            this._photoName = photo.getName();
            this._status = PhotoTableEntry.getStatusString(photo.getOriginalStatus(), photo.getCurrentStatus());
        }
    }

    private static String getStatusString(MediaObject.Status status, MediaObject.Status status2) {
        if (status != status2) {
            if (status == MediaObject.Status.NOT_CONNECTED) {
                return I18nManager.getText("dialog.saveexif.photostatus.connected");
            }
            if (status2 == MediaObject.Status.NOT_CONNECTED) {
                return I18nManager.getText("dialog.saveexif.photostatus.disconnected");
            }
            return I18nManager.getText("dialog.saveexif.photostatus.modified");
        }
        return null;
    }

    public Photo getPhoto() {
        return this._photo;
    }

    public String getName() {
        return this._photoName;
    }

    public String getStatus() {
        return this._status;
    }

    public void setSaveFlag(boolean bl) {
        this._save = bl;
    }

    public boolean getSaveFlag() {
        return this._save;
    }
}

